<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
	<sch:title>schematron validation for an OVAL Definition file</sch:title>
	<sch:title xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Core portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Independent portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:apche-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#apache" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Apache portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Red Hat portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Cisco IOS portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the Linux portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">schematron validation of the MacOS portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">schematron validation of the Solaris portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">schematron validation of the UNIX portion of an OVAL Definitions file</sch:title>
	<sch:title xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">schematron validation of the Windows portion of an OVAL Definitions file</sch:title>
	<sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance" />
	<sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5" />
	<sch:ns prefix="oval-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5" />
	<sch:ns prefix="ind-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" />
	<sch:ns prefix="apache-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#apache" />
	<sch:ns prefix="hpux-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" />
	<sch:ns prefix="ios-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" />
	<sch:ns prefix="linux-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" />
	<sch:ns prefix="macos-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" />
	<sch:ns prefix="sol-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris" />
	<sch:ns prefix="unix-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix" />
	<sch:ns prefix="win-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows" />
	<sch:pattern id="entityvarref" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="oval-def:objects/*/*|oval-def:states/*/*">
			<sch:assert test="not(@var_ref) or .=''">
				<value-of select="../@id" /> - a var-ref has been supplied for the <value-of select="name()" /> entity so no value should be provided</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="famtst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:family_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:family_object/@id">
				<value-of select="../@id" /> - the object child element of a family_test must reference a family_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:family_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:family_state/@id">
				<value-of select="../@id" /> - the state child element of a family_test must reference a family_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="famstefamily" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:family_state/ind-def:family">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the family entity of a family_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the family entity of a family_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5tst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:filemd5_object/@id">
				<value-of select="../@id" /> - the object child element of a filemd5_test must reference a filemd5_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:filemd5_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:filemd5_state/@id">
				<value-of select="../@id" /> - the state child element of a filemd5_test must reference a filemd5_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5objpath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_object/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a filemd5_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a filemd5_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5objfilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_object/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a filemd5_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a filemd5_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5stepath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_state/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a filemd5_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a filemd5_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5stefilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_state/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a filemd5_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a filemd5_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="md5stemd5" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:filemd5_state/ind-def:md5">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the md5 entity of a filemd5_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the md5 entity of a filemd5_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="envtst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:environmentvariable_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:environmentvariable_object/@id">
				<value-of select="../@id" /> - the object child element of an environmentvariable_test must reference a environmentvariable_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:environmentvariable_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:environmentvariable_state/@id">
				<value-of select="../@id" /> - the state child element of an environmentvariable_test must reference a environmentvariable_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="envobjname" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:environmentvariable_object/ind-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an environmentvariable_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an environmentvariable_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="envstename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:environmentvariable_state/ind-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an environmentvariable_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an environmentvariable_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="envstevalue" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:environmentvariable_state/ind-def:value">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the value entity of an environmentvariable_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txttst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object/@id">
				<value-of select="../@id" /> - the object child element of a textfilecontent_test must reference a textfilecontent_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:textfilecontent_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent_state/@id">
				<value-of select="../@id" /> - the state child element of a textfilecontent_test must reference a textfilecontent_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtobjpath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_object/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a textfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a textfilecontent_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtobjfilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_object/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a textfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a textfilecontent_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtobjline" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_object/ind-def:line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the line entity of a textfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the line entity of a textfilecontent_object should be 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtstepath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_state/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a textfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a textfilecontent_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtstefilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_state/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a textfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a textfilecontent_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtsteline" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:textfilecontent_state/ind-def:line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the line entity of a textfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the line entity of a textfilecontent_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="txtstesubexpression" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:registry_state/ind-def:subexpression">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the subexpression entity of a textfilecontent_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="vattst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:variable_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:variable_object/@id">
				<value-of select="../@id" /> - the object child element of a variable_test must reference a variable_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:variable_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:variable_state/@id">
				<value-of select="../@id" /> - the state child element of a variable_test must reference a variable_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="varobjvar_ref" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:variable_object/ind-def:var_ref">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the var_ref entity of a variable_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the var_ref entity of a variable_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="varstevar_ref" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:variable_state/ind-def:var_ref">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the var_ref entity of a variable_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the var_ref entity of a variable_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="varstevalue" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:variable_state/ind-def:value">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='evr_string' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or'))or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='ios_version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the value entity of a variable_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmltst" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_test/ind-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object/@id">
				<value-of select="../@id" /> - the object child element of a xmlfilecontent_test must reference a xmlfilecontent_object</sch:assert>
		</sch:rule>
		<sch:rule context="ind-def:xmlfilecontent_test/ind-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ind-def:xmlfilecontent_state/@id">
				<value-of select="../@id" /> - the state child element of a xmlfilecontent_test must reference a xmlfilecontent_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlobjpath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_object/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a xmlfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a xmlfilecontent_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlobjfilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_object/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a xmlfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a xmlfilecontent_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlobjxpath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_object/ind-def:xpath">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the xpath entity of a xmlfilecontent_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals'">
				<value-of select="../@id" /> - operation attribute for the xpath entity of a xmlfilecontent_object should be 'equals'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlstepath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_state/ind-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a xmlfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a xmlfilecontent_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlstefilename" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_state/ind-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a xmlfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a xmlfilecontent_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlstexpath" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_state/ind-def:xpath">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the xpath entity of a xmlfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the xpath entity of a xmlfilecontent_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="xmlstevalue_of" xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ind-def:xmlfilecontent_state/ind-def:value_of">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the value_of entity of a xmlfilecontent_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the value_of entity of a xmlfilecontent_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="vertst" xmlns:apche-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#apache" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="apache-def:version_test/apache-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/apache-def:version_object/@id">
				<value-of select="../@id" /> - the object child element of a version_test must reference a version_object</sch:assert>
		</sch:rule>
		<sch:rule context="apache-def:version_test/apache-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/apache-def:version_state/@id">
				<value-of select="../@id" /> - the state child element of a version_test must reference a version_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="apcheversteversion" xmlns:apche-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#apache" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="apache-def:version_state/apache-def:version">
			<sch:assert test="not(@datatype) or @datatype='version'">
				<value-of select="../@id" /> - datatype attribute for the version entity of an version_state should be 'version'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the version entity of a version_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="gcobjparameter_name" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:getconf_object/hpux-def:parameter_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the parameter_name entity of a getconf_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the parameter_name entity of a getconf_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="gcobjpathname" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:getconf_object/hpux-def:pathname">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pathname entity of a getconf_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pathname entity of a getconf_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="gcsteparameter_name" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:getconf_state/hpux-def:parameter_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the parameter_name entity of a getconf_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the parameter_name entity of a getconf_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="gcstepathname" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:getconf_state/hpux-def:pathname">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pathname entity of a getconf_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pathname entity of a getconf_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="gcsteoutput" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:getconf_state/hpux-def:output">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the output entity of a getconf_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the output entity of a getconf_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchobjpatch_name" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:patch_object/hpux-def:patch_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the patch_name entity of a patch_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the patch_name entity of a patch_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchstepatch_name" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:patch_state/hpux-def:patch_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the patch_name entity of a patch_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the patch_name entity of a patch_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchsteswtype" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:patch_state/hpux-def:swtype">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the swtype entity of a patch_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the swtype entity of a patch_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchstearea_patched" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:patch_state/hpux-def:area_patched">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the area_patched entity of a patch_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the area_patched entity of a patch_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchstepatch_base" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:patch_state/hpux-def:patch_base">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the patch_base entity of a patch_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the patch_base entity of a patch_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swlistobjswlist" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_object/hpux-def:swlist">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the swlist entity of a swlist_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the swlist entity of a swlist_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststeswlist" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:swlist">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the swlist entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the swlist entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststebundle" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:bundle">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the bundle entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the bundle entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststefileset" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:fileset">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the fileset entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the fileset entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststeversion" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:version">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the version entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststetitle" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:title">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the title entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the title entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="swliststevendor" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:swlist_state/hpux-def:vendor">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the vendor entity of a swlist_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the vendor entity of a swlist_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="trustobjusername" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_object/hpux-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a trusted_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a trusted_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeusername" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeuid" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:uid">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the uid entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the uid entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepassword" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:password">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the password entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the password entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeaccount_owner" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:account_owner">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the account_owner entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the account_owner entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeboot_auth" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:boot_auth">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the boot_auth entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the boot_auth entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeaudit_id" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:audit_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the audit_id entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the audit_id entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeaudit_flag" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:audit_flag">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the audit_flag entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the audit_flag entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_change_min" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_change_min">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_change_min entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_change_min entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_max_size" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_max_size">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_max_size entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_max_size entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_expiration" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_expiration">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_expiration entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_expiration entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_life" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_life">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_life entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_life entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_change_s" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_change_s">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_change_s entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_change_s entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_change_u" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_change_u">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_change_u entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_change_u entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeacct_expire" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:acct_expire">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the acct_expire entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the acct_expire entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststemax_llogin" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:max_llogin">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the max_llogin entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the max_llogin entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeexp_warning" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:exp_warning">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exp_warning entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exp_warning entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststeusr_chg_pw" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:usr_chg_pw">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the usr_chg_pw entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the usr_chg_pw entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststegen_pw" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:gen_pw">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the gen_pw entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the gen_pw entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_restrict" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_restrict">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_restrict entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_restrict entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_null" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_null">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_null entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_null entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_gen_char" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_gen_char">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_gen_char entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_gen_char entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_gen_let" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_gen_let">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_gen_let entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_gen_let entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelogin_time" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:login_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_time entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_time entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststepw_changer" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:pw_changer">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pw_changer entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pw_changer entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelogin_time_s" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:login_time_s">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_time_s entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_time_s entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelogin_time_u" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:login_time_u">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_time_u entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_time_u entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelogin_tty_s" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:login_tty_s">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_tty_s entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_tty_s entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelogin_tty_u" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:login_tty_u">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_tty_u entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_tty_u entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststenum_u_logins" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:num_u_logins">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the num_u_logins entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the num_u_logins entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststemax_u_logins" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:max_u_logins">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the max_u_logins entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the max_u_logins entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="truststelock_flag" xmlns:hpux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#hpux" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="hpux-def:trusted_state/hpux-def:lock_flag">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the lock_flag entity of a trusted_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the lock_flag entity of a trusted_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="globaltst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:global_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:global_object/@id">
				<value-of select="../@id" /> - the object child element of a global_test must reference a global_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:global_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:global_state/@id">
				<value-of select="../@id" /> - the state child element of a global_test must reference a global_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="globalobjglobal_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:global_object/ios-def:global_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the global_command entity of a global_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the global_command entity of a global_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="globalsteglobal_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:global_state/ios-def:global_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the global_command entity of a global_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the global_command entity of a global_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacetst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:interface_object/@id">
				<value-of select="../@id" /> - the object child element of an interface_test must reference an interface_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:interface_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:interface_state/@id">
				<value-of select="../@id" /> - the state child element of an interface_test must reference an interface_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfaceobjname" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_object/ios-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an interface_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an interface_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestename" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_state/ios-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteip_directed_broadcast_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_state/ios-def:ip_directed_broadcast_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the ip_directed_broadcast_command entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the ip_directed_broadcast_command entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteno_ip_directed_broadcast_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_state/ios-def:no_ip_directed_broadcast_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the no_ip_directed_broadcast_command entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the no_ip_directed_broadcast_command entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteproxy_arp_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_state/ios-def:proxy_arp_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the proxy_arp_command entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the proxy_arp_command entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteshutdown_command" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:interface_state/ios-def:shutdown_command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the shutdown_command entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the shutdown_command entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="linetst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:line_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:line_object/@id">
				<value-of select="../@id" /> - the object child element of a line_test must reference a line_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:line_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:line_state/@id">
				<value-of select="../@id" /> - the state child element of a line_test must reference a line_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lineobjshow_subcommand" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:line_object/ios-def:show_subcommand">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the show_subcommand entity of a line_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the show_subcommand entity of a line_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="linesteshow_subcommand" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:line_state/ios-def:show_subcommand">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the show_subcommand entity of a line_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the show_subcommand entity of a line_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="linesteconfig_line" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:line_state/ios-def:config_line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the config_line entity of a line_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the config_line entity of a line_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="snmptst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:snmp_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:snmp_object/@id">
				<value-of select="../@id" /> - the object child element of a snmp_test must reference a snmp_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:snmp_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:snmp_state/@id">
				<value-of select="../@id" /> - the state child element of a snmp_test must reference a snmp_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="snmpsteaccess_list" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:snmp_state/ios-def:access_list">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the access_list entity of a snmp_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the access_list entity of a snmp_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="snmpstecommunity_name" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:snmp_state/ios-def:community_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the community_name entity of a snmp_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the community_name entity of a snmp_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="tclshtst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:tclsh_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:tclsh_object/@id">
				<value-of select="../@id" /> - the object child element of a tclsh_test must reference a tclsh_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:tclsh_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:tclsh_state/@id">
				<value-of select="../@id" /> - the state child element of a tclsh_test must reference a tclsh_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="tclshsteavailable" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:tclsh_state/ios-def:available">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the available entity of a tclsh_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the available entity of a tclsh_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="vertst" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:version_test/ios-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/ios-def:version_object/@id">
				<value-of select="../@id" /> - the object child element of a version_test must reference a version_object</sch:assert>
		</sch:rule>
		<sch:rule context="ios-def:version_test/ios-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/ios-def:version_state/@id">
				<value-of select="../@id" /> - the state child element of a version_test must reference a version_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="verstemajor_release" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:version_state/ios-def:major_release">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the major_release entity of a version_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the major_release entity of a version_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="verstetrain_number" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:version_state/ios-def:train_number">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the train_number entity of a version_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the train_number entity of a version_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="verstetrain_identifier" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:version_state/ios-def:train_identifier">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the train_identifier entity of a version_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the train_identifier entity of a version_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="versteversion_string" xmlns:ios-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#ios" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="ios-def:version_state/ios-def:version_string">
			<sch:assert test="not(@datatype) or @datatype='ios_version'">
				<value-of select="../@id" /> - datatype attribute for the version_string entity of a version_state should be 'ios_version'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the version_string entity of a version_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgobjname" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_object/linux-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a dpkginfo_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a dpkginfo_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgstename" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a dpkginfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a dpkginfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgstearch" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:arch">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the arch entity of a dpkginfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the arch entity of a dpkginfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgsteepoch" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:epoch">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the epoch entity of a dpkginfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the epoch entity of a dpkginfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgsterelease" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:release">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the release entity of a dpkginfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the release entity of a dpkginfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgsteversion" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:version">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a dpkginfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the version entity of a dpkginfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="dpkgsteevr" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:dpkginfo_state/linux-def:evr">
			<sch:assert test="not(@datatype) or @datatype='evr_string'">
				<value-of select="../@id" /> - datatype attribute for the evr entity of a dpkginfo_state should be 'evr_string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the evr entity of a dpkginfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsobjprotocol" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_object/linux-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of an inetlisteningservers_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of an inetlisteningservers_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsobjlocal_address" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_object/linux-def:local_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_address entity of an inetlisteningservers_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_address entity of an inetlisteningservers_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsobjlocal_port" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_object/linux-def:local_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_port entity of an inetlisteningservers_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_port entity of an inetlisteningservers_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteprotocol" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_address" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:local_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_port" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:local_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_port entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_port entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_full_address" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:local_full_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_full_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_full_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteprogram_name" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:program_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the program_name entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the program_name entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_address" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:foreign_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_port" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:foreign_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_port entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_port entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_full_address" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:foreign_full_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_full_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_full_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstepid" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:pid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the pid entity of an inetlisteningservers_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the pid entity of an inetlisteningservers_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteuser_id" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:inetlisteningservers_state/linux-def:user_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_id entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_id entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmobjname" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_object/linux-def:program_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a rpminfo_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a rpminfo_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmstename" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a rpminfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmstearch" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:arch">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the arch entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the arch entity of a rpminfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmsteepoch" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:epoch">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the epoch entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the epoch entity of a rpminfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmsterelease" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:release">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the release entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the release entity of a rpminfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmsteversion" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:version">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the version entity of a rpminfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmsteevr" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:evr">
			<sch:assert test="not(@datatype) or @datatype='evr_string'">
				<value-of select="../@id" /> - datatype attribute for the evr entity of a rpminfo_state should be 'evr_string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or 'pattern match'">
				<value-of select="../@id" /> - operation attribute for the evr entity of a rpminfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rpmste" xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="linux-def:rpminfo_state/linux-def:program_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the program_name entity of a rpminfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the program_name entity of a rpminfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountobjusername" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_object/macos-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of an accountinfo_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of an accountinfo_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountsteusername" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of an accountinfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of an accountinfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountstepassword" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:password">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the password entity of an accountinfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the password entity of an accountinfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountsteuid" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:uid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the uid entity of an accountinfo_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the uid entity of an accountinfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountstegid" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:gid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the gid entity of an accountinfo_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the gid entity of an accountinfo_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountsterealname" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:realname">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the realname entity of an accountinfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the realname entity of an accountinfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountstehome_dir" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:home_dir">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the home_dir entity of an accountinfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the home_dir entity of an accountinfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="accountstelogin_shell" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:accountinfo_state/macos-def:login_shell">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_shell entity of an accountinfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_shell entity of an accountinfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsobjprogram_name" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_object/macos-def:program_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the program_name entity of an inetlisteningservers_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the program_name entity of an inetlisteningservers_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteprogram_name" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:program_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the program_name entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the program_name entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_address" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:local_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_full_address" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:local_full_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_full_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_full_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstelocal_port" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:local_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_port entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_port entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_address" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:foreign_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_full_address" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:foreign_full_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_full_address entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_full_address entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteforeign_port" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:foreign_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the foreign_port entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the foreign_port entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilsstepid" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:pid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the pid entity of an inetlisteningservers_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the pid entity of an inetlisteningservers_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteprotocol" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ilssteuser_id" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:inetlisteningservers_state/macos-def:user_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_id entity of an inetlisteningservers_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_id entity of an inetlisteningservers_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="nvramobjnvram_var" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:nvram_object/macos-def:nvram_var">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the nvram_var entity of a nvram_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the nvram_var entity of a nvram_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="nvramstenvram_var" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:nvram_state/macos-def:nvram_var">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the nvram_var entity of a nvram_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the nvram_var entity of a nvram_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="nvramstenvram_value" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:nvram_state/macos-def:nvram_value">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the nvram_value entity of a nvram_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the nvram_value entity of a nvram_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpobjusername" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_object/macos-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a pwpolicy_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a pwpolicy_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpobjuserpass" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_object/macos-def:userpass">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the userpass entity of a pwpolicy_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the userpass entity of a pwpolicy_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpobjdirectory_node" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_object/macos-def:directory_node">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the directory_node entity of a pwpolicy_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the directory_node entity of a pwpolicy_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpsteusername" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a pwpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a pwpolicy_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpsteuserpass" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:userpass">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the userpass entity of a pwpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals'">
				<value-of select="../@id" /> - operation attribute for the userpass entity of a pwpolicy_state should be 'equals'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpstedirectory_node" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:directory_node">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the directory_node entity of a pwpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the directory_node entity of a pwpolicy_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpstemaxChars" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:maxChars">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the maxChars entity of a pwpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the maxChars entity of a pwpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpstemaxFailedLoginAttempts" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:maxFailedLoginAttempts">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the maxFailedLoginAttempts entity of a pwpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the maxFailedLoginAttempts entity of a pwpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpsteminChars" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:minChars">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the minChars entity of a pwpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the minChars entity of a pwpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpstepasswordCannotBeName" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:passwordCannotBeName">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the passwordCannotBeName entity of a pwpolicy_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the passwordCannotBeName entity of a pwpolicy_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpsterequiresAlpha" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:requiresAlpha">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the requiresAlpha entity of a pwpolicy_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the requiresAlpha entity of a pwpolicy_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pwpsterequiresNumeric" xmlns:macos-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#macos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5">
		<sch:rule context="macos-def:pwpolicy_state/macos-def:requiresNumeric">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the requiresNumeric entity of a pwpolicy_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the requiresNumeric entity of a pwpolicy_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="isastebits" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:isainfo_state/sol-def:bits">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the bits entity of an isainfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the bits entity of an isainfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="isastekernel_isa" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:isainfo_state/sol-def:kernel_isa">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the kernel_isa entity of an isainfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the kernel_isa entity of an isainfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="isasteapplication_isa" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:isainfo_state/sol-def:application_isa">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the application_isa entity of an isainfo_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the application_isa entity of an isainfo_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packageobjpkginst" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_object/sol-def:pkginst">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pkginst entity of a package_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pkginst entity of a package_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagestepkginst" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:pkginst">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the pkginst entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the pkginst entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagestename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagestecategory" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:category">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the category entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the category entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagesteversion" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:version">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the version entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagestevendor" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:vendor">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the vendor entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the vendor entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="packagestedescription" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:package_state/sol-def:description">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the description entity of a package_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the description entity of a package_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchobjbase" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:patch_object/sol-def:base">
			<sch:assert test="@datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the base entity of a patch_object should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the base entity of a patch_object should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchstebase" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:patch_state/sol-def:base">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the base entity of a patch_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the base entity of a patch_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="patchsteversion" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:sol-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#solaris">
		<sch:rule context="sol-def:patch_state/sol-def:version">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a patch_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the version entity of a patch_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfileobjpath" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_object/unix-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a file_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a file_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfileobjfilename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_object/unix-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a file_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a file_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestepath" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestefilename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestetype" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the type entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the type entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestegroup_id" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:group_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the group_id entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the group_id entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteuser_id" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:user_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_id entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_id entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestea_time" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:a_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the a_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the a_time entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestec_time" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:c_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the c_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the c_time entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestem_time" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:m_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the m_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the m_time entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestesize" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:size">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the size entity of a file_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the size entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestesuid" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:suid">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the suid entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the suid entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestesgid" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:sgid">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sgid entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sgid entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestesticky" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:sticky">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sticky entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sticky entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteuread" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:uread">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the uread entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the uread entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteuwrite" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:uwrite">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the uwrite entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the uwrite entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteuexec" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:uexec">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the uexec entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the uexec entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestegread" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:gread">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the gread entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the gread entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestegwrite" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:gwrite">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the gwrite entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the gwrite entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilestegexec" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:gexec">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the gexec entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the gexec entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteoread" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:oread">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the oread entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the oread entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteowrite" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:owrite">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the owrite entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the owrite entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixfilesteoexec" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_state/unix-def:oexec">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the oexec entity of a file_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the oexec entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdobjprotocol" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_object/unix-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of an inetd_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of an inetd_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdobjservice_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_object/unix-def:service_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the service_name entity of an inetd_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the service_name entity of an inetd_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdsteprotocol" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of an inetd_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdsteservice_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:service_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the service_name entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the service_name entity of an inetd_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdsteserver_program" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:server_program">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the server_program entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the server_program entity of an inetd_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdsteendpoint_type" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:endpoint_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the endpoint_type entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the endpoint_type entity of an inetd_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdsteexec_as_user" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:exec_as_user">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exec_as_user entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exec_as_user entity of an inetd_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="inetdstewait_status" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:inetd_state/unix-def:wait_status">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the wait_status entity of an inetd_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the wait_status entity of an inetd_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfaceobjname" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_object/unix-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an interface_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an interface_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacestename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacestehardware_addr" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:hardware_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hardware_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the hardware_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacesteinet_addr" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:inet_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the inet_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the inet_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacestebroadcast_addr" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:broadcast_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the broadcast_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the broadcast_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacestenetmask" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:netmask">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the netmask entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the netmask entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixinterfacesteflag" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:interface_state/unix-def:flag">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for a flag entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the flag entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordobjusername" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:password_object/unix-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a password_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a password_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordsteusername" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordstepassword" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:password">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the password entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the password entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordsteuser_id" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:user_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_id entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_id entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordstegroup_id" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:group_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the group_id entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the group_id entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordstegcos" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:gcos">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the gcos entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the gcos entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordstehome_dir" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:home_dir">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the home_dir entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the home_dir entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="passwordstelogin_shell" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:package_state/unix-def:login_shell">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the login_shell entity of a password_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the login_shell entity of a password_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessobjcommand" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_object/unix-def:command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the command entity of a process_object be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the command entity of a process_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstecommand" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:command">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the command entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the command entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocesssteexec_time" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:exec_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exec_time entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exec_time entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstepid" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:pid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the pid entity of a process_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the pid entity of a process_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocesssteppid" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:ppid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the ppid entity of a process_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the ppid entity of a process_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstepriority" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:priority">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the priority entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the priority entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstescheduling_class" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:scheduling_class">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the scheduling_class entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the scheduling_class entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstestart_time" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:start_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the start_time entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the start_time entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocessstetty" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:tty">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the tty entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the tty entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixprocesssteuser_id" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:process_state/unix-def:user_id">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_id entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_id entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlobjservice_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_object/unix-def:service_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the service_name entity of a runlevel_object be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the service_name entity of a runlevel_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlobjrunlevel" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_object/unix-def:runlevel">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the runlevel entity of a runlevel_object be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the runlevel entity of a runlevel_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlsteservice_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_state/unix-def:service_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the service_name entity of a runlevel_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the service_name entity of a runlevel_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlsterunlevel" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_state/unix-def:runlevel">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the runlevel entity of a runlevel_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the runlevel entity of a runlevel_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlstestart" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_state/unix-def:start">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the start entity of a runlevel_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the start entity of a runlevel_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unixrlstekill" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:runlevel_state/unix-def:kill">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the kill entity of a runlevel_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the kill entity of a runlevel_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsobjpath" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_object/unix-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a sccs_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a sccs_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsobjfilename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:file_object/unix-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a sccs_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a sccs_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstepath" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstefilename" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstemodule_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:module_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the module_name entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the module_name entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstemodule_type" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:module_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the module_type entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the module_type entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccssterelease" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:release">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the release entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the release entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstelevel" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:level">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the level entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the level entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstebranch" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:branch">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the branch entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the branch entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstesequence" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:sequence">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the sequence entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the sequence entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sccsstewhat_string" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:sccs_state/unix-def:what_string">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the what_string entity of a sccs_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the what_string entity of a sccs_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowobjusername" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_object/unix-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a shadow_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a shadow_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowsteusername" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:username">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the username entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the username entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowstepassword" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:password">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the password entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the password entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowstechg_lst" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:chg_lst">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the chg_lst entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the chg_lst entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowstechg_allow" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:chg_allow">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the chg_allow entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the chg_allow entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowstechg_req" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:chg_req">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the chg_req entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the chg_req entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowsteexp_warn" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:exp_warn">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exp_warn entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exp_warn entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowsteexp_inact" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:exp_inact">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exp_inact entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exp_inact entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowsteexp_date" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:exp_date">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the exp_date entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the exp_date entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="shadowsteflag" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:shadow_state/unix-def:flag">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the flag entity of a shadow_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the flag entity of a shadow_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamestemachine_class" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:machine_class">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the machine_class entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the machine_class entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamestenode_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:node_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the node_name entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the node_name entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamesteos_name" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:os_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the os_name entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the os_name entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamesteos_release" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:os_release">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the os_release entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the os_release entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamesteos_version" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:os_version">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the os_version entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the os_version entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="unamesteprocessor_type" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix">
		<sch:rule context="unix-def:uname_state/unix-def:processor_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the processor_type entity of a uname_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the processor_type entity of a uname_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="affected_platform" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="oval-def:affected[@family='windows']">
			<sch:assert test="oval-def:platform='Microsoft Windows 95' or oval-def:platform='Microsoft Windows 98' or oval-def:platform='Microsoft Windows ME' or oval-def:platform='Microsoft Windows NT' or oval-def:platform='Microsoft Windows 2000' or oval-def:platform='Microsoft Windows XP' or oval-def:platform='Microsoft Windows Server 2003'">
				<value-of select="../../@id" /> - the value "<value-of select="oval-def:platform" />" found in platform element as part of the affected element is not a valid windows platform.</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="attst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:accesstoken_object/@id">
				<value-of select="../@id" /> - the object child element of an accesstoken_test must reference an accesstoken_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:accesstoken_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:accesstoken_state/@id">
				<value-of select="../@id" /> - the state child element of an accesstoken_test must reference an accesstoken_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atobjsecurity_principle" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_object/win-def:security_principle">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the security_principle entity of an accesstoken_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the security_principle entity of an accesstoken_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesecurity_principle" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:security_principle">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the security_principle entity of an accesstoken_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the security_principle entity of an accesstoken_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseassignprimarytokenprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seassignprimarytokenprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seassignprimarytokenprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seassignprimarytokenprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseauditprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seauditprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seauditprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seauditprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesebackupprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sebackupprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sebackupprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sebackupprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesechangenotifyprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sechangenotifyprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sechangenotifyprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sechangenotifyprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesecreateglobalprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:secreateglobalprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the secreateglobalprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the secreateglobalprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesecreatepagefileprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:secreatepagefileprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the secreatepagefileprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the secreatepagefileprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesecreatepermanentprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:secreatepermanentprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the secreatepermanentprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for thesecreatepermanentprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesecreatetokenprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:secreatetokenprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the secreatetokenprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the secreatetokenprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedebugprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedebugprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedebugprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedebugprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseenabledelegationprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seenabledelegationprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seenabledelegationprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seenabledelegationprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseimpersonateprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seimpersonateprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seimpersonateprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seimpersonateprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseincreasebasepriorityprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seincreasebasepriorityprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seincreasebasepriorityprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seincreasebasepriorityprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseincreasequotaprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seincreasequotaprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seincreasequotaprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seincreasequotaprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseloaddriverprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seloaddriverprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seloaddriverprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seloaddriverprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteselockmemoryprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:selockmemoryprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the selockmemoryprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the selockmemoryprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesemachineaccountprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:semachineaccountprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the semachineaccountprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the semachineaccountprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesemanagevolumeprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:semanagevolumeprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the semanagevolumeprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the semanagevolumeprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseprofilesingleprocessprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seprofilesingleprocessprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seprofilesingleprocessprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seprofilesingleprocessprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseremoteshutdownprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seremoteshutdownprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seremoteshutdownprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seremoteshutdownprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteserestoreprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:serestoreprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the serestoreprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the serestoreprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesesecurityprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sesecurityprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sesecurityprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sesecurityprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseshutdownprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seshutdownprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seshutdownprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seshutdownprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesesyncagentprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sesyncagentprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sesyncagentprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sesyncagentprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesesystemenvironmentprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sesystemenvironmentprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sesystemenvironmentprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sesystemenvironmentprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesesystemprofileprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sesystemprofileprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sesystemprofileprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sesystemprofileprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesesystemtimeprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sesystemtimeprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sesystemtimeprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sesystemtimeprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesetakeownershipprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:setakeownershipprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the setakeownershipprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the setakeownershipprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesetcbprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:setcbprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the setcbprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the setcbprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseundockprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seundockprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seundockprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seundockprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseunsolicitedinputprivilege" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seunsolicitedinputprivilege">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seunsolicitedinputprivilege entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seunsolicitedinputprivilege entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesebatchlogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sebatchlogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sebatchlogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sebatchlogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseinteractivelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seinteractivelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seinteractivelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seinteractivelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesenetworklogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:senetworklogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the senetworklogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the senetworklogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseremoteinteractivelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seremoteinteractivelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seremoteinteractivelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seremoteinteractivelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atsteseservicelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:seservicelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the seservicelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the seservicelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedenybatchLogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedenybatchLogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedenybatchLogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedenybatchLogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedenyinteractivelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedenyinteractivelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedenyinteractivelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedenyinteractivelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedenynetworklogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedenynetworklogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedenynetworklogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedenynetworklogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedenyremoteInteractivelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedenyremoteInteractivelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedenyremoteInteractivelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedenyremoteInteractivelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="atstesedenyservicelogonright" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:accesstoken_state/win-def:sedenyservicelogonright">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the sedenyservicelogonright entity of an accesstoken_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the sedenyservicelogonright entity of an accesstoken_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adtst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:activedirectory_object/@id">
				<value-of select="../@id" /> - the object child element of an activedirectory_test must reference an activedirectory_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:activedirectory_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:activedirectory_state/@id">
				<value-of select="../@id" /> - the state child element of an activedirectory_test must reference an activedirectory_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adobjnaming_context" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_object/win-def:naming_context">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the naming_context entity of an activedirectory_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the naming_context entity of an activedirectory_object should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adobjrelative_dn" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_object/win-def:relative_dn">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the relative_dn entity of an activedirectory_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the relative_dn entity of an activedirectory_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
			<sch:assert test="not(@xsi:nil='true') or ../win-def:attribute/@xsi:nil='true'">
				<value-of select="../@id" /> - attribute entity must be nil when relative_dn is nil</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adobjattribute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_object/win-def:attribute">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the attribute entity of an activedirectory_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the attribute entity of an activedirectory_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adstenaming_context" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:naming_context">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the naming_context entity of an activedirectory_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the naming_context entity of an activedirectory_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adsterelative_dn" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:relative_dn">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the relative_dn entity of an activedirectory_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the relative_dn entity of an activedirectory_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adsteattribute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:attribute">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the attribute entity of an activedirectory_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the attribute entity of an activedirectory_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adsteobject_class" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:object_class">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the object_class entity of an activedirectory_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the object_class entity of an activedirectory_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adsteadstype" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:adstype">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the adstype entity of an activedirectory_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the adstype entity of an activedirectory_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="adstevalue" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:activedirectory_state/win-def:value">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the value entity of an activedirectory_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aeptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:auditeventpolicy_object/@id">
				<value-of select="../@id" /> - the object child element of an auditeventpolicy_test must reference an auditeventpolicy_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:auditeventpolicy_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:auditeventpolicy_state/@id">
				<value-of select="../@id" /> - the state child element of an auditeventpolicy_test must reference an auditeventpolicy_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepsteaccount_logon" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:account_logon">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the account_logon entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the account_logon entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepsteaccount_management" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:account_management">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the account_management entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the account_management entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepstedetailed_tracking" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:detailed_tracking">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the detailed_tracking entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the detailed_tracking entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepstedirectory_service_access" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:directory_service_access">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the directory_service_access entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the directory_service_access entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepstelogon" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:logon">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the logon entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the logon entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepsteobject_access" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:object_access">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the object_access entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the object_access entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepstepolicy_change" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:policy_change">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the policy_change entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the policy_change entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepsteprivilege_use" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:privilege_use">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the privilege_use entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the privilege_use entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="aepstesystem" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:auditeventpolicy_state/win-def:system">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the system entity of an auditeventpolicy_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the system entity of an auditeventpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filetst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:file_object/@id">
				<value-of select="../@id" /> - the object child element of a file_test must reference a file_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:file_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:file_state/@id">
				<value-of select="../@id" /> - the state child element of a file_test must reference a file_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fileobjpath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_object/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a file_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a file_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fileobjfilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_object/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a file_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a file_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestepath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestefilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filesteowner" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:owner">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the owner entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the owner entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestesize" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:size">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the size entity of a file_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the size entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestea_time" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:a_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the a_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the a_time entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestec_time" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:c_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the c_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the c_time entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestem_time" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:m_time">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the m_time entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the m_time entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', 'less than or equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestems_checksum" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:ms_checksum">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the ms_checksum entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the ms_checksum entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filesteversion" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:version">
			<sch:assert test="not(@datatype) or @datatype='version'">
				<value-of select="../@id" /> - datatype attribute for the version entity of a file_state should be 'version'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the version entity of a file_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestetype" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the type entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the type entity of a file_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="filestedevelopment_class" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:file_state/win-def:development_class">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the development_class entity of a file_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the development_class entity of a file_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="faptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:fileauditedpermissions_object/@id">
				<value-of select="../@id" /> - the object child element of a fileauditedpermissions_test must reference a fileauditedpermissions_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:fileauditedpermissions_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:fileauditedpermissions_state/@id">
				<value-of select="../@id" /> - the state child element of a fileauditedpermissions_test must reference a fileauditedpermissions_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapobjpath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_object/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a fileauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a fileauditedpermissions_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapobjfilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_object/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a fileauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a fileauditedpermissions_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapobjtrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_object/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a fileauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a fileauditedpermissions_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstepath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a fileauditedpermissions_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a fileauditedpermissions_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstetrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a fileauditedpermissions_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstestandard_delete" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:standard_delete">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_delete entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_delete entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstestandard_read_control" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:standard_read_control">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_read_control entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_read_control entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstestandard_write_dac" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:standard_write_dac">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_dac entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_dac entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstestandard_write_owner" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:standard_write_owner">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_owner entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_owner entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstestandard_synchronize" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:standard_synchronize">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_synchronize entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_synchronize entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapsteaccess_system_security" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:access_system_security">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the access_system_security entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the access_system_security entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstegeneric_read" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:generic_read">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_read entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_read entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstegeneric_write" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:generic_write">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_write entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_write entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstegeneric_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:generic_execute">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_execute entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_execute entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstegeneric_all" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:generic_all">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_all entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_all entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_read_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_read_data">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_read_data entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_data entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_write_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_write_data">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_write_data entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_data entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_append_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_append_data">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_append_data entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_append_data entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_read_ea" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_read_ea">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_read_ea entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_ea entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_write_ea" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_write_ea">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_write_ea entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_ea entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_execute">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_execute entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_execute entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_delete_child" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_delete_child">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_delete_child entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_delete_child entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_read_attributes" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_read_attributes">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_read_attributes entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_attributes entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fapstefile_write_attributes" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileauditedpermissions_state/win-def:file_write_attributes">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_write_attributes entity of a fileauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_attributes entity of a fileauditedpermissions_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fertst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:fileeffectiverights_object/@id">
				<value-of select="../@id" /> - the object child element of a fileeffectiverights_test must reference a fileeffectiverights_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:fileeffectiverights_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:fileeffectiverights_state/@id">
				<value-of select="../@id" /> - the state child element of a fileeffectiverights_test must reference a fileeffectiverights_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fefobjpath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_object/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a fileeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a fileeffectiverights_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fefobjfilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_object/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a fileeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a fileeffectiverights_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fefobjtrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_object/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a fileeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a fileeffectiverights_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstepath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the path entity of a fileeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the path entity of a fileeffectiverights_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefilename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:filename">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the filename entity of a fileeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the filename entity of a fileeffectiverights_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstetrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a fileeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a fileeffectiverights_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstestandard_delete" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:standard_delete">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_delete entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_delete entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstestandard_read_control" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:standard_read_control">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_read_control entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_read_control entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstestandard_write_dac" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:standard_write_dac">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_dac entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_dac entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstestandard_write_owner" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:standard_write_owner">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_owner entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_owner entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstestandard_synchronize" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:standard_synchronize">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_synchronize entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_synchronize entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="fersteaccess_system_security" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:access_system_security">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the access_system_security entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the access_system_security entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstegeneric_read" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:generic_read">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_read entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_read entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstegeneric_write" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:generic_write">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_write entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_write entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstegeneric_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:generic_execute">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_execute entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_execute entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstegeneric_all" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:generic_all">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_all entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_all entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_read_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_read_data">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_read_data entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_data entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_write_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_write_data">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_write_data entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_data entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_append_data" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_append_data">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_append_data entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_append_data entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_read_ea" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_read_ea">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_read_ea entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_ea entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_write_ea" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_write_ea">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_write_ea entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_ea entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_execute">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_execute entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_execute entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_delete_child" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_delete_child">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_delete_child entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_delete_child entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_read_attributes" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_read_attributes">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_read_attributes entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_attributes entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ferstefile_write_attributes" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:fileeffectiverights_state/win-def:file_write_attributes">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the file_write_attributes entity of a fileeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the file_write_attributes entity of a fileeffectiverights_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="grouptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:group_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:group_object/@id">
				<value-of select="../@id" /> - the object child element of a group_test must reference a group_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:group_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:group_state/@id">
				<value-of select="../@id" /> - the state child element of a group_test must reference a group_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="groupobjgroup" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:group_object/win-def:group">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the group entity of a group_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the group entity of a group_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="groupstegroup" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:group_state/win-def:group">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the group entity of a group_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the group entity of a group_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="groupsteuser" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:group_state/win-def:user">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user entity of a group_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user entity of a group_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacetst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:interface_object/@id">
				<value-of select="../@id" /> - the object child element of an interface_test must reference an interface_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:interface_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:interface_state/@id">
				<value-of select="../@id" /> - the state child element of an interface_test must reference an interface_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfaceobjname" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_object/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a interface_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a interface_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteindex" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:index">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the index entity of an interface_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the index entity of an interface_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestetype" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the type entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the type entity of an interface_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestehardware_addr" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:hardware_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hardware_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the hardware_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteinet_addr" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:inet_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the inet_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the inet_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestebroadcast_addr" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:broadcast_addr">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the broadcast_addr entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the broadcast_addr entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacestenetmask" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:netmask">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the netmask entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the netmask entity of an interface_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="interfacesteaddr_type" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:interface_state/win-def:addr_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the addr_type entity of an interface_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the addr_type entity of an interface_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:lockoutpolicy_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:lockoutpolicy_object/@id">
				<value-of select="../@id" /> - the object child element of a lockoutpolicy_test must reference a lockoutpolicy_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:lockoutpolicy_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:lockoutpolicy_state/@id">
				<value-of select="../@id" /> - the state child element of a lockoutpolicy_test must reference a lockoutpolicy_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lpsteforce_logoff" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:lockoutpolicy_state/win-def:force_logoff">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the force_logoff entity of a lockoutpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the force_logoff entity of a lockoutpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lpstelockout_duration" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:lockoutpolicy_state/win-def:lockout_duration">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the lockout_duration entity of a lockoutpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the lockout_duration entity of a lockoutpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lpstelockout_observation_window" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:lockoutpolicy_state/win-def:lockout_observation_window">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the lockout_observation_window entity of a lockoutpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the lockout_observation_window entity of a lockoutpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="lpstelockout_threshold" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:lockoutpolicy_state/win-def:lockout_threshold">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the lockout_threshold entity of a lockoutpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the lockout_threshold entity of a lockoutpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasetst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:metabase_object/@id">
				<value-of select="../@id" /> - the object child element of a metabase_test must reference a metabase_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:metabase_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:metabase_state/@id">
				<value-of select="../@id" /> - the state child element of a metabase_test must reference a metabase_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabaseobjkey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_object/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a metabase_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a metabase_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabaseobjid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_object/win-def:id">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the id entity of a metabase_object should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the id entity of a metabase_object should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasestekey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a metabase_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a metabase_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasesteid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:id">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the id entity of a metabase_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the id entity of a metabase_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasestename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a metabase_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a metabase_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasesteuser_type" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:user_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user_type entity of a metabase_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user_type entity of a metabase_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasestedata_type" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:data_type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the data_type entity of a metabase_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the data_type entity of a metabase_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="metabasestedata" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:metabase_state/win-def:data">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the data entity of a metabase_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="pptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:passwordpolicy_object/@id">
				<value-of select="../@id" /> - the object child element of a passwordpolicy_test must reference a passwordpolicy_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:passwordpolicy_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:passwordpolicy_state/@id">
				<value-of select="../@id" /> - the state child element of a passwordpolicy_test must reference a passwordpolicy_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstemax_passwd_age" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:max_passwd_age">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the max_passwd_age entity of a passwordpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the max_passwd_age entity of a passwordpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstemin_passwd_age" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:min_passwd_age">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the min_passwd_age entity of a passwordpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the min_passwd_age entity of a passwordpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstemin_passwd_len" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:min_passwd_len">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the min_passwd_len entity of a passwordpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the min_passwd_len entity of a passwordpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstepassword_hist_len" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:password_hist_len">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the password_hist_len entity of a passwordpolicy_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the password_hist_len entity of a passwordpolicy_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstepassword_complexity" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:password_complexity">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the password_complexity entity of an passwordpolicy_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the password_complexity entity of an passwordpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="ppstereversible_encryption" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:passwordpolicy_state/win-def:reversible_encryption">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the reversible_encryption entity of an passwordpolicy_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the reversible_encryption entity of an passwordpolicy_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="porttst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:port_object/@id">
				<value-of select="../@id" /> - the object child element of a port_test must reference a port_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:port_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:port_state/@id">
				<value-of select="../@id" /> - the state child element of a port_test must reference a port_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portobj" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_object/win-def:command_line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the command_line entity of a port_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the command_line entity of a port_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portobjlocal_port" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_object/win-def:local_port">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_port entity of a port_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the local_port entity of a port_object should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portobj" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_object/win-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of a port_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of a port_object should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portstelocal_address" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:local_address">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the local_address entity of a port_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the local_address entity of a port_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portstelocal_port" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:local_port">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the local_port entity of a port_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the local_port entity of a port_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portsteprotocol" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:protocol">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the protocol entity of a port_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the protocol entity of a port_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="portstepid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:pid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the pid entity of a port_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the pid entity of a port_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processtst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:process_object/@id">
				<value-of select="../@id" /> - the object child element of a process_test must reference a process_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:process_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:process_state/@id">
				<value-of select="../@id" /> - the state child element of a process_test must reference a process_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processobjcommand_line" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_object/win-def:command_line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the command_line entity of a process_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the command_line entity of a process_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processstecommand_line" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_state/win-def:command_line">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the command_line entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the command_line entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processstepid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:pid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the pid entity of a port_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the pid entity of a port_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processsteppid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:port_state/win-def:ppid">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the ppid entity of a port_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the ppid entity of a port_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processstepriority" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_state/win-def:priority">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the priority entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the priority entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processsteimage_path" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_state/win-def:image_path">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the image_path entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the image_path entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="processstecurrent_dir" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:process_state/win-def:current_dir">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the current_dir entity of a process_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the current_dir entity of a process_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regtst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:registry_object/@id">
				<value-of select="../@id" /> - the object child element of a registry_test must reference a registry_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:registry_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:registry_state/@id">
				<value-of select="../@id" /> - the state child element of a registry_test must reference a registry_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regobjhive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_object/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a registry_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a registry_object should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regobjkey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_object/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a registry_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a registry_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
			<sch:assert test="not(@xsi:nil='true') or ../win-def:name/@xsi:nil='true'">
				<value-of select="../@id" /> - name entity must be nil when key is nil</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regobjname" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_object/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a registry_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a registry_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regstehive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_state/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a registry_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a registry_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regstekey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_state/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a registry_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a registry_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regstename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_state/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a registry_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a registry_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regstetype" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_state/win-def:type">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the type entity of a registry_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the type entity of a registry_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="regstevalue" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:registry_state/win-def:value">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the value entity of a registry_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="raptst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:regkeyauditedpermissions_object/@id">
				<value-of select="../@id" /> - the object child element of a regkeyauditedpermissions_test must reference a regkeyauditedpermissions_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:regkeyauditedpermissions_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:regkeyauditedpermissions_state/@id">
				<value-of select="../@id" /> - the state child element of a regkeyauditedpermissions_test must reference a regkeyauditedpermissions_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapobjhive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_object/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a regkeyauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a regkeyauditedpermissions_object should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapobjkey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_object/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a regkeyauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a regkeyauditedpermissions_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapobjtrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_object/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a regkeyauditedpermissions_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a regkeyauditedpermissions_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstehive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a regkeyauditedpermissions_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstetrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a regkeyauditedpermissions_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstestandard_delete" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:standard_delete">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_delete entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_delete entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstestandard_read_control" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:standard_read_control">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_read_control entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_read_control entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstestandard_write_dac" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:standard_write_dac">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_dac entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_dac entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstestandard_write_owner" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:standard_write_owner">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_owner entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_owner entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstestandard_synchronize" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:standard_synchronize">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the standard_synchronize entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_synchronize entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapsteaccess_system_security" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:access_system_security">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the access_system_security entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the access_system_security entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstegeneric_read" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:generic_read">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_read entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_read entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstegeneric_write" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:generic_write">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_write entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_write entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstegeneric_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:generic_execute">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_execute entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_execute entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstegeneric_all" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:generic_all">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the generic_all entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_all entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_query_value" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_query_value">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_query_value entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_query_value entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_set_value" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_set_value">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_set_value entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_set_value entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_create_sub_key" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_create_sub_key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_create_sub_key entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_create_sub_key entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_enumerate_sub_keys" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_enumerate_sub_keys">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_enumerate_sub_keys entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_notify" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_notify">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_notify entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_notify entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_create_link" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_create_link">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_create_link entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_create_link entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapstekey_wow64_64key" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_wow64_64key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_64key entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_64key entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapste" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_wow64_32key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_32key entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_32key entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rapste" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyauditedpermissions_state/win-def:key_wow64_res">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_res entity of a regkeyauditedpermissions_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_res entity of a regkeyauditedpermissions_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rertst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:regkeyeffectiverights_object/@id">
				<value-of select="../@id" /> - the object child element of a regkeyeffectiverights_test must reference a regkeyeffectiverights_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:regkeyeffectiverights_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:regkeyeffectiverights_state/@id">
				<value-of select="../@id" /> - the state child element of a regkeyeffectiverights_test must reference a regkeyeffectiverights_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerobjhive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_object/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a regkeyeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a regkeyeffectiverights_object should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerobjkey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_object/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a regkeyeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a regkeyeffectiverights_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerobjtrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_object/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a regkeyeffectiverights_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a regkeyeffectiverights_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstehive" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:hive">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the hive entity of a regkeyeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the hive entity of a regkeyeffectiverights_state should be 'equals' or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the key entity of a regkeyeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the key entity of a regkeyeffectiverights_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstetrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a regkeyeffectiverights_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a regkeyeffectiverights_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstestandard_delete" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:standard_delete">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_delete entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_delete entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstestandard_read_control" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:standard_read_control">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_read_control entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_read_control entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstestandard_write_dac" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:standard_write_dac">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_dac entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_dac entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstestandard_write_owner" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:standard_write_owner">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_write_owner entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_write_owner entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstestandard_synchronize" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:standard_synchronize">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the standard_synchronize entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the standard_synchronize entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rersteaccess_system_security" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:access_system_security">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the access_system_security entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the access_system_security entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstegeneric_read" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:generic_read">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_read entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_read entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstegeneric_write" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:generic_write">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_write entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_write entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstegeneric_execute" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:generic_execute">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_execute entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_execute entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstegeneric_all" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:generic_all">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the generic_all entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the generic_all entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_query_value" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_query_value">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_query_value entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_query_value entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_set_value" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_set_value">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_set_value entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_set_value entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_create_sub_key" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_create_sub_key">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_create_sub_key entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_create_sub_key entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_enumerate_sub_keys" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_enumerate_sub_keys">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_enumerate_sub_keys entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_notify" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_notify">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_notify entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_notify entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_create_link" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_create_link">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_create_link entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_create_link entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_wow64_64key" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_wow64_64key">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_64key entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_64key entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_wow64_32key" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_wow64_32key">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_32key entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_32key entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="rerstekey_wow64_res" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:regkeyeffectiverights_state/win-def:key_wow64_res">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the key_wow64_res entity of a regkeyeffectiverights_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the key_wow64_res entity of a regkeyeffectiverights_state should be 'equals', or 'not equal</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sidtst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:sid_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:sid_object/@id">
				<value-of select="../@id" /> - the object child element of a sid_test must reference a sid_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:sid_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:sid_state/@id">
				<value-of select="../@id" /> - the state child element of a sid_test must reference a sid_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sidobjtrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:sid_object/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a sid_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a sid_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sidstetrustee_name" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:sid_state/win-def:trustee_name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_name entity of a sid_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_name entity of a sid_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sidstetrustee_sid" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:sid_state/win-def:trustee_sid">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_sid entity of a sid_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_sid entity of a sid_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="sidstetrustee_domain" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:sid_state/win-def:trustee_domain">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the trustee_domain entity of a sid_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the trustee_domain entity of a sid_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="usertst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:user_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:user_object/@id">
				<value-of select="../@id" /> - the object child element of a user_test must reference a user_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:user_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:user_state/@id">
				<value-of select="../@id" /> - the state child element of a user_test must reference a user_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="userobjuser" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:user_object/win-def:user">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user entity of a user_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user entity of a user_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="usersteuser" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:user_state/win-def:user">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the user entity of a user_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the user entity of a user_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="usersteenabled" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:user_state/win-def:enabled">
			<sch:assert test="not(@datatype) or @datatype='boolean'">
				<value-of select="../@id" /> - datatype attribute for the enabled entity of a user_state should be 'boolean'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal'">
				<value-of select="../@id" /> - operation attribute for the enabled entity of a user_state should be 'equals', or 'not equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="userstegroup" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:user_state/win-def:group">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the group entity of a user_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the group entity of a user_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volumetst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:volume_object/@id">
				<value-of select="../@id" /> - the object child element of a volume_test must reference a volume_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:volume_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:volume_state/@id">
				<value-of select="../@id" /> - the state child element of a volume_test must reference a volume_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volobjrootpath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_object/win-def:rootpath">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the rootpath entity of a volume_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the rootpath entity of a volume_object should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volumesterootpath" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:rootpath">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the rootpath entity of a volume_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the rootpath entity of a volume_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volumestefile_system" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_system">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the file_system entity of a volume_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the file_system entity of a volume_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volumestename" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:name">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the name entity of a volume_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the name entity of a volume_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstevolume_max_component_length" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:volume_max_component_length">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the volume_max_component_length entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the volume_max_component_length entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volsteserial_number" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:serial_number">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the serial_number entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the serial_number entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_case_sensitive_search" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_case_sensitive_search">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_case_sensitive_search entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_case_sensitive_search entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_case_preserved_names" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_case_preserved_names">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_case_preserved_names entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_case_preserved_names entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_unicode_on_disk" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_unicode_on_disk">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_unicode_on_disk entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_unicode_on_disk entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_persistent_acls" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_persistent_acls">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_persistent_acls entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_persistent_acls entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_file_compression" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_file_compression">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_file_compression entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_file_compression entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_volume_quotas" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_volume_quotas">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_volume_quotas entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_volume_quotas entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_supports_sparse_files" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_supports_sparse_files">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_supports_sparse_files entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_supports_sparse_files entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_supports_reparse_points" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_supports_reparse_points">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_supports_reparse_points entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_supports_reparse_points entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_supports_remote_storage" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_supports_remote_storage">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_supports_remote_storage entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_supports_remote_storage entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_volume_is_compressed" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_volume_is_compressed">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_volume_is_compressed entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_volume_is_compressed entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_supports_object_ids" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_supports_object_ids">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_supports_object_ids entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_supports_object_ids entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_supports_encryption" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_supports_encryption">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_supports_encryption entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_supports_encryption entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_named_streams" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_named_streams">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_named_streams entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_named_streams entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="volstefile_read_only_volume" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:volume_state/win-def:file_read_only_volume">
			<sch:assert test="not(@datatype) or @datatype='int'">
				<value-of select="../@id" /> - datatype attribute for the file_read_only_volume entity of a volume_state should be 'int'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal'">
				<value-of select="../@id" /> - operation attribute for the file_read_only_volume entity of a volume_state should be 'equals', 'not equal', 'greater than', 'greater than or equal', 'less than', or 'less than or equal'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmitst" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_test/win-def:object">
			<sch:assert test="@object_ref=/oval-def:oval_definitions/oval-def:objects/win-def:wmi_object/@id">
				<value-of select="../@id" /> - the object child element of a wmi_test must reference a wmi_object</sch:assert>
		</sch:rule>
		<sch:rule context="win-def:wmi_test/win-def:state">
			<sch:assert test="@state_ref=/oval-def:oval_definitions/oval-def:states/win-def:wmi_state/@id">
				<value-of select="../@id" /> - the state child element of a wmi_test must reference a wmi_state</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmiobjnamespace" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_object/win-def:namespace">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the namespace entity of a wmi_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals'">
				<value-of select="../@id" /> - operation attribute for the namespace entity of a wmi_object should be 'equals'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmiobj" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_object/win-def:wql">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the wql entity of a wmi_object should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals'">
				<value-of select="../@id" /> - operation attribute for the wql entity of a wmi_object should be 'equals'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmistenamespace" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_state/win-def:namespace">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the namespace entity of a wmi_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the namespace entity of a wmi_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmistewql" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_state/win-def:wql">
			<sch:assert test="not(@datatype) or @datatype='string'">
				<value-of select="../@id" /> - datatype attribute for the wql entity of a wmi_state should be 'string'</sch:assert>
			<sch:assert test="not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match'">
				<value-of select="../@id" /> - operation attribute for the wql entity of a wmi_state should be 'equals', 'not equal', or 'pattern match'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern id="wmisteresult" xmlns:oval="http://oval.mitre.org/XMLSchema/oval-common-5" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5" xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows">
		<sch:rule context="win-def:wmi_state/win-def:result">
			<sch:assert test="((@datatype='binary' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='bool' and (not(@operation) or @operation='equals' or @operation='not equal')) or (@datatype='float' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or (@datatype='int' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')) or ((@datatype='string' or not(@datatype)) and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='pattern match')) or (@datatype='version' and (not(@operation) or @operation='equals' or @operation='not equal' or @operation='greater than' or @operation='greater than or equal' or @operation='less than' or @operation='less than or equal' or @operation='bitwise and' or @operation='bitwise or')))">
				<value-of select="../@id" /> - the supplied operation attribute for the result entity of a wmi_state is not valid given a datatype of '<value-of select="@datatype" />'</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:diagnostics />
</sch:schema>
