<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
            xmlns:xsd="http://www.w3.org/2001/XMLSchema"
            queryBinding="xslt">
   <sch:title>Schematron validation for an OVAL System Characteristics file</sch:title>
   <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>
   <sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5"/>
   <sch:ns prefix="oval-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"/>
   <sch:ns prefix="ind-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"/>
   <sch:ns prefix="aix-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"/>
   <sch:ns prefix="apache-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#apache"/>
   <sch:ns prefix="catos-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#catos"/>
   <sch:ns prefix="esx-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#esx"/>
   <sch:ns prefix="freebsd-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#freebsd"/>
   <sch:ns prefix="hpux-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#hpux"/>
   <sch:ns prefix="ios-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#ios"/>
   <sch:ns prefix="linux-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"/>
   <sch:ns prefix="macos-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#macos"/>
   <sch:ns prefix="pixos-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#pixos"/>
   <sch:ns prefix="sp-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#sharepoint"/>
   <sch:ns prefix="sol-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#solaris"/>
   <sch:ns prefix="unix-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"/>
   <sch:ns prefix="win-sc"
           uri="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"/>
   <sch:ns prefix="oval-def" uri="http://oval.mitre.org/XMLSchema/oval-definitions-5"/>
   <sch:phase id="oval">
      <sch:active pattern="oval_none_exist_value_dep"/>
   </sch:phase>
   <sch:phase id="oval-sc">
      <sch:active pattern="oval-sc_entity_rules"/>
      <sch:active pattern="oval-sc_item_record_fields"/>
   </sch:phase>
   <sch:phase id="ind-sc">
      <sch:active pattern="ind-sc_famitemfamily"/>
      <sch:active pattern="ind-sc_hashitemfilepath"/>
      <sch:active pattern="ind-sc_hashitempath"/>
      <sch:active pattern="ind-sc_hashitemfilename"/>
      <sch:active pattern="ind-sc_hashitemmd5"/>
      <sch:active pattern="ind-sc_hashitemsha1"/>
      <sch:active pattern="ind-sc_envitemname"/>
      <sch:active pattern="ind-def_envitemvalue"/>
      <sch:active pattern="ind-sc_ldap_item_dep"/>
      <sch:active pattern="ind-sc_ldapitemsuffix"/>
      <sch:active pattern="ind-sc_ldapitemrelative_dn"/>
      <sch:active pattern="ind-sc_ldapitemattribute"/>
      <sch:active pattern="ind-sc_ldapitemobject_class"/>
      <sch:active pattern="ind-sc_ldapitemldaptype"/>
      <sch:active pattern="ind-def_ldapitemvalue"/>
      <sch:active pattern="ind-sc_ldap57itemsuffix"/>
      <sch:active pattern="ind-sc_ldap57itemrelative_dn"/>
      <sch:active pattern="ind-sc_ldap57itemattribute"/>
      <sch:active pattern="ind-sc_ldap57itemobject_class"/>
      <sch:active pattern="ind-sc_ldap57itemldaptype"/>
      <sch:active pattern="ind-sc_ldap57_item_value"/>
      <sch:active pattern="ind-sc_sql_item_dep"/>
      <sch:active pattern="ind-sc_sqlitemengine"/>
      <sch:active pattern="ind-sc_sqlitemversion"/>
      <sch:active pattern="ind-sc_sqlitemconnection_string"/>
      <sch:active pattern="ind-sc_sqlitemsql"/>
      <sch:active pattern="ind-def_sqlitemresult"/>
      <sch:active pattern="ind-sc_sql7itemengine"/>
      <sch:active pattern="ind-sc_sql57itemversion"/>
      <sch:active pattern="ind-sc_sql57itemconnection_string"/>
      <sch:active pattern="ind-sc_sql57itemsql"/>
      <sch:active pattern="ind-sc_sql57_item_value"/>
      <sch:active pattern="ind-sc_txtitemfilepath"/>
      <sch:active pattern="ind-sc_txtitempath"/>
      <sch:active pattern="ind-sc_txtitemfilename"/>
      <sch:active pattern="ind-sc_txtitempattern"/>
      <sch:active pattern="ind-sc_txtiteminstance"/>
      <sch:active pattern="ind-sc_txtitemline"/>
      <sch:active pattern="ind-sc_txtitemtext"/>
      <sch:active pattern="ind-def_txtitemsubexpression"/>
      <sch:active pattern="ind-sc_varitemvar_ref"/>
      <sch:active pattern="ind-sc_xmlitemfilepath"/>
      <sch:active pattern="ind-sc_xmlitempath"/>
      <sch:active pattern="ind-sc_xmlitemfilename"/>
      <sch:active pattern="ind-sc_xmlitemxpath"/>
      <sch:active pattern="ind-sc_xmlitemvalue_of"/>
      <sch:active pattern="ind-sc_ldaptype_timestamp_value_dep"/>
      <sch:active pattern="ind-sc_ldaptype_email_value_dep"/>
   </sch:phase>
   <sch:phase id="aix-sc">
      <sch:active pattern="aix-sc_interimfixitemvuid"/>
      <sch:active pattern="aix-sc_interimfixitemlabel"/>
      <sch:active pattern="aix-sc_interimfixitemabstract"/>
      <sch:active pattern="aix-sc_interimfixitemstate"/>
      <sch:active pattern="aix-sc_filesetitemflstinst"/>
      <sch:active pattern="aix-sc_filesetitemlevel"/>
      <sch:active pattern="aix-sc_filesetitemstate"/>
      <sch:active pattern="aix-sc_filesetitemdescription"/>
      <sch:active pattern="aix-sc_fixitemapar_number"/>
      <sch:active pattern="aix-sc_fixitemabstract"/>
      <sch:active pattern="aix-sc_fixitemsymptom"/>
      <sch:active pattern="aix-sc_fixiteminstallation_status"/>
      <sch:active pattern="aix-sc_oslevelitemmaintenance_level"/>
   </sch:phase>
   <sch:phase id="apache-sc">
      <sch:active pattern="apache-sc_httpditempath"/>
      <sch:active pattern="apache-sc_httpditembinaryname"/>
      <sch:active pattern="apache-sc_httpditemversion"/>
   </sch:phase>
   <sch:phase id="catos-sc">
      <sch:active pattern="catos-sc_lineitemshow_subcommand"/>
      <sch:active pattern="catos-sc_lineitemconfig_line"/>
      <sch:active pattern="catos-sc_moduleitemmodule_number"/>
      <sch:active pattern="catos-sc_moduleitemtype"/>
      <sch:active pattern="catos-sc_moduleitemmodel"/>
      <sch:active pattern="catos-sc_moduleitemsoftware_major_release"/>
      <sch:active pattern="catos-sc_moduleitemsoftware_individual_release"/>
      <sch:active pattern="catos-sc_moduleitemsoftware_version_id"/>
      <sch:active pattern="catos-sc_moduleitemhardware_major_release"/>
      <sch:active pattern="catos-sc_moduleitemhardware_individual_release"/>
      <sch:active pattern="catos-sc_moduleitemfirmware_major_release"/>
      <sch:active pattern="catos-sc_moduleitemfirmware_individual_release"/>
      <sch:active pattern="catos-sc_versionitemswitch_series"/>
      <sch:active pattern="catos-sc_versionitemimage_name"/>
      <sch:active pattern="catos-sc_versionitemcatos_release"/>
      <sch:active pattern="catos-sc_versionitemcatos_major_release"/>
      <sch:active pattern="catos-sc_versionitemcatos_individual_release"/>
      <sch:active pattern="catos-sc_versionitemcatos_version_id"/>
   </sch:phase>
   <sch:phase id="esx-sc">
      <sch:active pattern="esx-sc_patchitempatch_number"/>
      <sch:active pattern="esx-sc_patchitempatch_name"/>
      <sch:active pattern="esx-sc_patchitemkb_id"/>
      <sch:active pattern="esx-sc_patchitembundle_id"/>
      <sch:active pattern="esx-sc_patchitemclassification"/>
      <sch:active pattern="esx-sc_patchitemsupport_level"/>
      <sch:active pattern="esx-sc_patchitemstatus"/>
      <sch:active pattern="esx-sc_versionitemrelease"/>
      <sch:active pattern="esx-sc_versionitembuild"/>
   </sch:phase>
   <sch:phase id="freebsd-sc">
      <sch:active pattern="freebsd-sc_portinfoitempkginst"/>
      <sch:active pattern="freebsd-sc_portinfoitemname"/>
      <sch:active pattern="freebsd-sc_portinfoitemcategory"/>
      <sch:active pattern="freebsd-sc_portinfoitemversion"/>
      <sch:active pattern="freebsd-sc_portinfoitemvendor"/>
      <sch:active pattern="freebsd-sc_portinfoitemdescription"/>
   </sch:phase>
   <sch:phase id="hpux-sc">
      <sch:active pattern="hpux-sc_gcitemparameter_name"/>
      <sch:active pattern="hpux-sc_gcitempathname"/>
      <sch:active pattern="hpux-sc_gcitemoutput"/>
      <sch:active pattern="hpux-sc_patchitemswtype"/>
      <sch:active pattern="hpux-sc_patchitemarea_patched"/>
      <sch:active pattern="hpux-sc_patchitempatch_number"/>
      <sch:active pattern="hpux-sc_swlistitemswlist"/>
      <sch:active pattern="hpux-sc_swlistitembundle"/>
      <sch:active pattern="hpux-sc_swlistitemfileset"/>
      <sch:active pattern="hpux-sc_swlistitemversion"/>
      <sch:active pattern="hpux-sc_swlistitemtitle"/>
      <sch:active pattern="hpux-sc_swlistitemvendor"/>
      <sch:active pattern="hpux-sc_trustitemtrustitem"/>
      <sch:active pattern="hpux-sc_trustitemuid"/>
      <sch:active pattern="hpux-sc_trustitempassword"/>
      <sch:active pattern="hpux-sc_trustitemaccount_owner"/>
      <sch:active pattern="hpux-sc_trustitemboot_auth"/>
      <sch:active pattern="hpux-sc_trustitemaudit_id"/>
      <sch:active pattern="hpux-sc_trustitemaudit_flag"/>
      <sch:active pattern="hpux-sc_trustitempw_change_min"/>
      <sch:active pattern="hpux-sc_trustitempw_max_size"/>
      <sch:active pattern="hpux-sc_trustitempw_expiration"/>
      <sch:active pattern="hpux-sc_trustitempw_life"/>
      <sch:active pattern="hpux-sc_trustitempw_change_s"/>
      <sch:active pattern="hpux-sc_trustitempw_change_u"/>
      <sch:active pattern="hpux-sc_trustitemacct_expire"/>
      <sch:active pattern="hpux-sc_trustitemmax_llogin"/>
      <sch:active pattern="hpux-sc_trustitemexp_warning"/>
      <sch:active pattern="hpux-sc_trustitemusr_chg_pw"/>
      <sch:active pattern="hpux-sc_trustitemgen_pw"/>
      <sch:active pattern="hpux-sc_trustitempw_restrict"/>
      <sch:active pattern="hpux-sc_trustitempw_null"/>
      <sch:active pattern="hpux-sc_trustitempw_gen_char"/>
      <sch:active pattern="hpux-sc_trustitempw_gen_let"/>
      <sch:active pattern="hpux-sc_trustitemlogin_time"/>
      <sch:active pattern="hpux-sc_trustitempw_changer"/>
      <sch:active pattern="hpux-sc_trustitemlogin_time_s"/>
      <sch:active pattern="hpux-sc_trustitemlogin_time_u"/>
      <sch:active pattern="hpux-sc_trustitemlogin_tty_s"/>
      <sch:active pattern="hpux-sc_trustitemlogin_tty_u"/>
      <sch:active pattern="hpux-sc_trustitemnum_u_logins"/>
      <sch:active pattern="hpux-sc_trustitemmax_u_logins"/>
      <sch:active pattern="hpux-sc_trustitemlock_flag"/>
   </sch:phase>
   <sch:phase id="ios-sc">
      <sch:active pattern="ios-sc_globalitemglobal_command"/>
      <sch:active pattern="ios-sc_interfaceitemname"/>
      <sch:active pattern="ios-sc_interfaceitemip_directed_broadcast_command"/>
      <sch:active pattern="ios-sc_interfaceitemno_ip_directed_broadcast_command"/>
      <sch:active pattern="ios-sc_interfaceitemproxy_arp_command"/>
      <sch:active pattern="ios-sc_interfaceitemshutdown_command"/>
      <sch:active pattern="ios-sc_lineitemshow_subcommand"/>
      <sch:active pattern="ios-sc_lineitemconfig_line"/>
      <sch:active pattern="ios-sc_snmpitemaccess_list"/>
      <sch:active pattern="ios-sc_snmpitemcommunity_name"/>
      <sch:active pattern="ios-sc_tclshitemavailable"/>
      <sch:active pattern="ios-sc_versionitemmajor_release"/>
      <sch:active pattern="ios-sc_versionitemtrain_number"/>
      <sch:active pattern="ios-sc_versionitemmajorversion"/>
      <sch:active pattern="ios-sc_versionitemminorversion"/>
      <sch:active pattern="ios-sc_versionitemrelease"/>
      <sch:active pattern="ios-sc_versionitemtrain_identifier"/>
      <sch:active pattern="ios-sc_versionitemrebuild"/>
      <sch:active pattern="ios-sc_versionitemsubrebuild"/>
      <sch:active pattern="ios-sc_versionitemmainlinerebuild"/>
      <sch:active pattern="ios-sc_versionitemversion_string"/>
   </sch:phase>
   <sch:phase id="linux-sc">
      <sch:active pattern="linux-sc_dpkgitemname"/>
      <sch:active pattern="linux-sc_dpkgitemarch"/>
      <sch:active pattern="linux-sc_dpkgitemepoch"/>
      <sch:active pattern="linux-sc_dpkgitemrelease"/>
      <sch:active pattern="linux-sc_dpkgitemversion"/>
      <sch:active pattern="linux-sc_dpkgitemevr"/>
      <sch:active pattern="linux-sc_ilsitemprotocol"/>
      <sch:active pattern="linux-sc_ilsitemlocal_address"/>
      <sch:active pattern="linux-sc_ilsitemlocal_port"/>
      <sch:active pattern="linux-sc_ilsitemlocal_full_address"/>
      <sch:active pattern="linux-sc_ilsitemprogram_name"/>
      <sch:active pattern="linux-sc_ilsitemforeign_address"/>
      <sch:active pattern="linux-sc_ilsitemforeign_port"/>
      <sch:active pattern="linux-sc_ilsitemforeign_full_address"/>
      <sch:active pattern="linux-sc_ilsitempid"/>
      <sch:active pattern="linux-sc_ilsitemuser_id"/>
      <sch:active pattern="linux-sc_rpmitemname"/>
      <sch:active pattern="linux-sc_rpmitemarch"/>
      <sch:active pattern="linux-sc_rpmitemepoch"/>
      <sch:active pattern="linux-sc_rpmitemrelease"/>
      <sch:active pattern="linux-sc_rpmitemversion"/>
      <sch:active pattern="linux-sc_rpmitemevr"/>
      <sch:active pattern="linux-sc_rpmitemsignature_keyid"/>
      <sch:active pattern="linux-sc_spkginfoitemname"/>
      <sch:active pattern="linux-sc_spkginfoitemversion"/>
      <sch:active pattern="linux-sc_spkginfoitemarchitecture"/>
      <sch:active pattern="linux-sc_spkginfoitemrevision"/>
   </sch:phase>
   <sch:phase id="macos-sc">
      <sch:active pattern="macos-sc_accountitemusername"/>
      <sch:active pattern="macos-sc_accountitempassword"/>
      <sch:active pattern="macos-sc_accountitemuid"/>
      <sch:active pattern="macos-sc_accountitemgid"/>
      <sch:active pattern="macos-sc_accountitemrealname"/>
      <sch:active pattern="macos-sc_accountitemhome_dir"/>
      <sch:active pattern="macos-sc_accountitemlogin_shell"/>
      <sch:active pattern="macos-sc_ilsitemprogram_name"/>
      <sch:active pattern="macos-sc_ilsitemlocal_address"/>
      <sch:active pattern="macos-sc_ilsitemlocal_full_address"/>
      <sch:active pattern="macos-sc_ilsitemlocal_port"/>
      <sch:active pattern="macos-sc_ilsitemforeign_address"/>
      <sch:active pattern="macos-sc_ilsitemforeign_full_address"/>
      <sch:active pattern="macos-sc_ilsitemforeign_port"/>
      <sch:active pattern="macos-sc_ilsitempid"/>
      <sch:active pattern="macos-sc_ilsitemprotocol"/>
      <sch:active pattern="macos-sc_ilsitemuser_id"/>
      <sch:active pattern="macos-sc_nvramitemnvram_var"/>
      <sch:active pattern="macos-sc_nvramitemnvram_value"/>
      <sch:active pattern="macos-sc_pwpitemtargetuser"/>
      <sch:active pattern="macos-sc_pwpitemusername"/>
      <sch:active pattern="macos-sc_pwpitemuserpass"/>
      <sch:active pattern="macos-sc_pwpitemdirectory_node"/>
      <sch:active pattern="macos-sc_pwpitemmaxChars"/>
      <sch:active pattern="macos-sc_pwpitemmaxFailedLoginAttempts"/>
      <sch:active pattern="macos-sc_pwpitemminChars"/>
      <sch:active pattern="macos-sc_pwpitempasswordCannotBeName"/>
      <sch:active pattern="macos-sc_pwpitemrequiresAlpha"/>
      <sch:active pattern="macos-sc_pwpitemrequiresNumeric"/>
   </sch:phase>
   <sch:phase id="pixos-sc">
      <sch:active pattern="pixos-sc_lineitemshow_subcommand"/>
      <sch:active pattern="pixos-sc_lineitemconfig_line"/>
      <sch:active pattern="pixos-sc_versionitempix_release"/>
      <sch:active pattern="pixos-sc_versionitempix_major_release"/>
      <sch:active pattern="pixos-sc_versionitempix_minor_release"/>
      <sch:active pattern="pixos-sc_versionitempix_build"/>
   </sch:phase>
   <sch:phase id="sp-sc">
      <sch:active pattern="sp-sc_webappitemwebapplicationurl"/>
      <sch:active pattern="sp-sc_webappitemallowparttopartcommunication"/>
      <sch:active pattern="sp-sc_webappitemallowaccesstowebpartcatalog"/>
      <sch:active pattern="sp-sc_webappitemblockedfileextention"/>
      <sch:active pattern="sp-sc_webappitemdefaultquotatemplate"/>
      <sch:active pattern="sp-sc_webappitemexternalworkflowparticipantsenabled"/>
      <sch:active pattern="sp-sc_webappitemrecyclebinenabled"/>
      <sch:active pattern="sp-sc_webappitemautomaticallydeleteunusedsitecollections"/>
      <sch:active pattern="sp-sc_webappitemselfservicesitecreationenabled"/>
      <sch:active pattern="sp-sc_webappitemsecondstagerecyclebinquota"/>
      <sch:active pattern="sp-sc_webappitemrecyclebinretentionperiod"/>
      <sch:active pattern="sp-sc_webappitemoutboundmailserverinstance"/>
      <sch:active pattern="sp-sc_webappitemoutboundmailsenderaddress"/>
      <sch:active pattern="sp-sc_webappitemoutboundmailreplytoaddress"/>
      <sch:active pattern="sp-sc_webappitemsecvalexpires"/>
      <sch:active pattern="sp-sc_webappitemtimeout"/>
      <sch:active pattern="sp-sc_webappitemisadministrationwebapplication"/>
      <sch:active pattern="sp-sc_webappitemapplicationpoolname"/>
      <sch:active pattern="sp-sc_webappitemapplicationpoolusername"/>
      <sch:active pattern="sp-sc_webappitemopenitems"/>
      <sch:active pattern="sp-sc_webappitemaddlistitems"/>
      <sch:active pattern="sp-sc_webappitemapproveitems"/>
      <sch:active pattern="sp-sc_webappitemdeletelistitems"/>
      <sch:active pattern="sp-sc_webappitemdeleteversions"/>
      <sch:active pattern="sp-sc_webappitemeditlistitems"/>
      <sch:active pattern="sp-sc_webappitemmanagelists"/>
      <sch:active pattern="sp-sc_webappitemviewversions"/>
      <sch:active pattern="sp-sc_webappitemviewlistitems"/>
      <sch:active pattern="sp-sc_webappitemcancelcheckout"/>
      <sch:active pattern="sp-sc_webappitemcreatealerts"/>
      <sch:active pattern="sp-sc_webappitemviewformpages"/>
      <sch:active pattern="sp-sc_webappitemviewpages"/>
      <sch:active pattern="sp-sc_webappitemaddandcustomizepages"/>
      <sch:active pattern="sp-sc_webappitemapplystylesheets"/>
      <sch:active pattern="sp-sc_webappitemapplythemeandborder"/>
      <sch:active pattern="sp-sc_webappitembrowsedirectories"/>
      <sch:active pattern="sp-sc_webappitembrowseuserinfo"/>
      <sch:active pattern="sp-sc_webappitemcreategroups"/>
      <sch:active pattern="sp-sc_webappitemcreatesscsite"/>
      <sch:active pattern="sp-sc_webappitemeditmyuserinfo"/>
      <sch:active pattern="sp-sc_webappitemenumeratepermissions"/>
      <sch:active pattern="sp-sc_webappitemmanagealerts"/>
      <sch:active pattern="sp-sc_webappitemmanagepermissions"/>
      <sch:active pattern="sp-sc_webappitemmanagesubwebs"/>
      <sch:active pattern="sp-sc_webappitemmanageweb"/>
      <sch:active pattern="sp-sc_webappitemopens"/>
      <sch:active pattern="sp-sc_webappitemuseclientintegration"/>
      <sch:active pattern="sp-sc_webappitemuseremoteapis"/>
      <sch:active pattern="sp-sc_webappitemviewusagedata"/>
      <sch:active pattern="sp-sc_webappitemmanagepersonalviews"/>
      <sch:active pattern="sp-sc_webappitemadddelprivatewebparts"/>
      <sch:active pattern="sp-sc_webappitemupdatepersonalwebparts"/>
      <sch:active pattern="sp-sc_grpitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_grpitemgname"/>
      <sch:active pattern="sp-sc_grpitemautoacceptrequesttojoinleave"/>
      <sch:active pattern="sp-sc_grpitemallowmemberseditmembership"/>
      <sch:active pattern="sp-sc_grpitemonlyallowmembersviewmembership"/>
      <sch:active pattern="sp-sc_webitemwebcollectionurl"/>
      <sch:active pattern="sp-sc_webitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_webitemsecondarysitecolladmin"/>
      <sch:active pattern="sp-sc_webitemsecondsitecolladminenabled"/>
      <sch:active pattern="sp-sc_webitemallowanonymousaccess"/>
      <sch:active pattern="sp-sc_listitemspwebsiteurl"/>
      <sch:active pattern="sp-sc_listitemirmenabled"/>
      <sch:active pattern="sp-sc_listitemenableversioning"/>
      <sch:active pattern="sp-sc_listitemnocrawl"/>
      <sch:active pattern="sp-sc_avsitemspwebservicename"/>
      <sch:active pattern="sp-sc_avsitemspfarmname"/>
      <sch:active pattern="sp-sc_avsitemallowdownload"/>
      <sch:active pattern="sp-sc_avsitemcleaningenabled"/>
      <sch:active pattern="sp-sc_avsitemdownloadscanenabled"/>
      <sch:active pattern="sp-sc_avsitemnumberofthreads"/>
      <sch:active pattern="sp-sc_avsitemskipsearchcrawl"/>
      <sch:active pattern="sp-sc_avsitemtimeout"/>
      <sch:active pattern="sp-sc_avsitemuploadscanenabled"/>
      <sch:active pattern="sp-sc_avsitemvendorupdatecount"/>
      <sch:active pattern="sp-sc_siteadminitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_siteadminitemstoragemaxlevel"/>
      <sch:active pattern="sp-sc_siteadminitemstoragewarninglevel"/>
      <sch:active pattern="sp-sc_siteitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_siteitemquotaname"/>
      <sch:active pattern="sp-sc_siteitemurl"/>
      <sch:active pattern="sp-sc_critemsiteurl"/>
      <sch:active pattern="sp-sc_critemcrawlashttp"/>
      <sch:active pattern="sp-sc_critemenabled"/>
      <sch:active pattern="sp-sc_critemfollowcomplexurls"/>
      <sch:active pattern="sp-sc_critempath"/>
      <sch:active pattern="sp-sc_critempriority"/>
      <sch:active pattern="sp-sc_critemsuppressindexing"/>
      <sch:active pattern="sp-sc_critemaccountname"/>
      <sch:active pattern="sp-sc_jobdefitemwebappuri"/>
      <sch:active pattern="sp-sc_jobdefitemdisplayname"/>
      <sch:active pattern="sp-sc_jobdefitemisdisabled"/>
      <sch:active pattern="sp-sc_jobdefitemretry"/>
      <sch:active pattern="sp-sc_jobdefitemtitle"/>
      <sch:active pattern="sp-sc_bbitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_bbitembestbeturl"/>
      <sch:active pattern="sp-sc_bbitemtitle"/>
      <sch:active pattern="sp-sc_bbitemdescription"/>
      <sch:active pattern="sp-sc_policycollitemsitecollectionurl"/>
      <sch:active pattern="sp-sc_policycollitemid"/>
      <sch:active pattern="sp-sc_policycollitemname"/>
      <sch:active pattern="sp-sc_policycollitemdescription"/>
      <sch:active pattern="sp-sc_policycollitemlongdescription"/>
      <sch:active pattern="sp-sc_diagnosticserviceitemfarmname"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemdisplayname"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemlogcutinterval"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemloglocation"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemlogstokeep"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemrequired"/>
      <sch:active pattern="sp-sc_diagnosticsserviceitemtypename"/>
      <sch:active pattern="sp-sc_diagnosticslevelitemfarmname"/>
      <sch:active pattern="sp-sc_diagnosticslevelitemeventseverity"/>
      <sch:active pattern="sp-sc_diagnosticslevelitemhidden"/>
      <sch:active pattern="sp-sc_diagnosticsitemlevelid"/>
      <sch:active pattern="sp-sc_diagnosticsitemlevelname"/>
      <sch:active pattern="sp-sc_diagnosticslevelitemtraceseverity"/>
      <sch:active pattern="sp-sc_policyfeatureitemfarmname"/>
      <sch:active pattern="sp-sc_policyfeatureitemconfigpage"/>
      <sch:active pattern="sp-sc_policyfeatureitemdefaultcustomdata"/>
      <sch:active pattern="sp-sc_policyfeatureitemdescription"/>
      <sch:active pattern="sp-sc_policyfeatureitemglobalconfigpage"/>
      <sch:active pattern="sp-sc_policyfeatureitemglobalcustomdata"/>
      <sch:active pattern="sp-sc_policyfeatureitemgroup"/>
      <sch:active pattern="sp-sc_policyfeatureitemname"/>
      <sch:active pattern="sp-sc_policyfeatureitempublisher"/>
      <sch:active pattern="sp-sc_policyfeatureitemstate"/>
      <sch:active pattern="sp-sc_policyitemwebappuri"/>
      <sch:active pattern="sp-sc_policyitemurlzone"/>
      <sch:active pattern="sp-sc_policyitemdisplayname"/>
      <sch:active pattern="sp-sc_policyitemissystemuser"/>
      <sch:active pattern="sp-sc_policyitemusername"/>
      <sch:active pattern="sp-sc_policyitempolicyroletype"/>
   </sch:phase>
   <sch:phase id="sol-sc">
      <sch:active pattern="sol-sc_isaitembits"/>
      <sch:active pattern="sol-sc_isaitemkernel_isa"/>
      <sch:active pattern="sol-sc_isaitemapplication_isa"/>
      <sch:active pattern="sol-sc_packageitempkginst"/>
      <sch:active pattern="sol-sc_packageitemname"/>
      <sch:active pattern="sol-sc_packageitemcategory"/>
      <sch:active pattern="sol-sc_packageitemversion"/>
      <sch:active pattern="sol-sc_packageitemvendor"/>
      <sch:active pattern="sol-sc_packageitemdescription"/>
      <sch:active pattern="sol-sc_patchitembase"/>
      <sch:active pattern="sol-sc_patchitemversion"/>
      <sch:active pattern="sol-sc_fmriitembase"/>
      <sch:active pattern="sol-sc_srvnameitembase"/>
      <sch:active pattern="sol-sc_srvstateitembase"/>
      <sch:active pattern="sol-sc_protocolitembase"/>
      <sch:active pattern="sol-sc_srvexeitembase"/>
      <sch:active pattern="sol-sc_srvargsitembase"/>
      <sch:active pattern="sol-sc_execasuseritembase"/>
   </sch:phase>
   <sch:phase id="unix-sc">
      <sch:active pattern="unix-sc_dnscacheitemdomainname"/>
      <sch:active pattern="unix-sc_dnscacheitemttl"/>
      <sch:active pattern="unix-sc_dnscacheitemipaddress"/>
      <sch:active pattern="unix-sc_fileitemfilepath"/>
      <sch:active pattern="unix-sc_fileitempath"/>
      <sch:active pattern="unix-sc_fileitemfilename"/>
      <sch:active pattern="unix-sc_fileitemtype"/>
      <sch:active pattern="unix-sc_fileitemgroup_id"/>
      <sch:active pattern="unix-sc_fileitemuser_id"/>
      <sch:active pattern="unix-sc_fileitema_time"/>
      <sch:active pattern="unix-sc_fileitemc_time"/>
      <sch:active pattern="unix-sc_fileitemm_time"/>
      <sch:active pattern="unix-sc_fileitemsize"/>
      <sch:active pattern="unix-sc_fileitemsuid"/>
      <sch:active pattern="unix-sc_fileitemsgid"/>
      <sch:active pattern="unix-sc_fileitemsticky"/>
      <sch:active pattern="unix-sc_fileitemuread"/>
      <sch:active pattern="unix-sc_fileitemuwrite"/>
      <sch:active pattern="unix-sc_fileitemuexec"/>
      <sch:active pattern="unix-sc_fileitemgread"/>
      <sch:active pattern="unix-sc_fileitemgwrite"/>
      <sch:active pattern="unix-sc_fileitemgexec"/>
      <sch:active pattern="unix-sc_fileitemoread"/>
      <sch:active pattern="unix-sc_fileitemowrite"/>
      <sch:active pattern="unix-sc_fileitemoexec"/>
      <sch:active pattern="unix-sc_fileitemhasextendedacl"/>
      <sch:active pattern="unix-sc_inetditemprotocol"/>
      <sch:active pattern="unix-sc_inetditemservice_name"/>
      <sch:active pattern="unix-sc_inetditemserver_program"/>
      <sch:active pattern="unix-sc_inetditemserver_arguments"/>
      <sch:active pattern="unix-sc_inetditemendpoint_type"/>
      <sch:active pattern="unix-sc_inetditemexec_as_user"/>
      <sch:active pattern="unix-sc_inetditemwait_status"/>
      <sch:active pattern="unix-sc_interfaceitemname"/>
      <sch:active pattern="unix-sc_interfaceitemtype"/>
      <sch:active pattern="unix-sc_interfaceitemhardware_addr"/>
      <sch:active pattern="unix-sc_interfaceiteminet_addr"/>
      <sch:active pattern="unix-sc_interfaceitembroadcast_addr"/>
      <sch:active pattern="unix-sc_interfaceitemnetmask"/>
      <sch:active pattern="unix-sc_interfaceitemflag"/>
      <sch:active pattern="unix-sc_passworditemusername"/>
      <sch:active pattern="unix-sc_passworditempassword"/>
      <sch:active pattern="unix-sc_passworditemuser_id"/>
      <sch:active pattern="unix-sc_passworditemgroup_id"/>
      <sch:active pattern="unix-sc_passworditemgcos"/>
      <sch:active pattern="unix-sc_passworditemhome_dir"/>
      <sch:active pattern="unix-sc_passworditemlogin_shell"/>
      <sch:active pattern="unix-sc_processitemcommand"/>
      <sch:active pattern="unix-sc_processitemexec_time"/>
      <sch:active pattern="unix-sc_processitempid"/>
      <sch:active pattern="unix-sc_processitemppid"/>
      <sch:active pattern="unix-sc_processitempriority"/>
      <sch:active pattern="unix-sc_processitemscheduling_class"/>
      <sch:active pattern="unix-sc_processitemstart_time"/>
      <sch:active pattern="unix-sc_processitemtty"/>
      <sch:active pattern="unix-sc_processitemuser_id"/>
      <sch:active pattern="unix-sc_rlitemservice_name"/>
      <sch:active pattern="unix-sc_rlitemrunlevel"/>
      <sch:active pattern="unix-sc_rlitemstart"/>
      <sch:active pattern="unix-sc_rlitemkill"/>
      <sch:active pattern="unix-sc_sccsitemfilepath"/>
      <sch:active pattern="unix-sc_sccsitempath"/>
      <sch:active pattern="unix-sc_sccsitemfilename"/>
      <sch:active pattern="unix-sc_sccsitemmodule_name"/>
      <sch:active pattern="unix-sc_sccsitemmodule_type"/>
      <sch:active pattern="unix-sc_sccsitemrelease"/>
      <sch:active pattern="unix-sc_sccsitemlevel"/>
      <sch:active pattern="unix-sc_sccsitembranch"/>
      <sch:active pattern="unix-sc_sccsitemsequence"/>
      <sch:active pattern="unix-sc_sccsitemwhat_string"/>
      <sch:active pattern="unix-sc_shadowitemusername"/>
      <sch:active pattern="unix-sc_shadowitempassword"/>
      <sch:active pattern="unix-sc_shadowitemchg_lst"/>
      <sch:active pattern="unix-sc_shadowitemchg_allow"/>
      <sch:active pattern="unix-sc_shadowitemchg_req"/>
      <sch:active pattern="unix-sc_shadowitemexp_warn"/>
      <sch:active pattern="unix-sc_shadowitemexp_inact"/>
      <sch:active pattern="unix-sc_shadowitemexp_date"/>
      <sch:active pattern="unix-sc_shadowitemflag"/>
      <sch:active pattern="unix-sc_unameitemmachine_class"/>
      <sch:active pattern="unix-sc_unameitemnode_name"/>
      <sch:active pattern="unix-sc_unameitemos_name"/>
      <sch:active pattern="unix-sc_unameitemos_release"/>
      <sch:active pattern="unix-sc_unameitemos_version"/>
      <sch:active pattern="unix-sc_unameitemprocessor_type"/>
      <sch:active pattern="unix-sc_xinetditemprotocol"/>
      <sch:active pattern="unix-sc_xinetditemservice_name"/>
      <sch:active pattern="unix-sc_xinetditemflags"/>
      <sch:active pattern="unix-sc_xinetditemnoaccess"/>
      <sch:active pattern="unix-sc_xinetditemonlyfrom"/>
      <sch:active pattern="unix-sc_xinetditemport"/>
      <sch:active pattern="unix-sc_xinetditemserver"/>
      <sch:active pattern="unix-sc_xinetditemserver_arguments"/>
      <sch:active pattern="unix-sc_xinetditemsockettype"/>
      <sch:active pattern="unix-sc_xinetditemtype"/>
      <sch:active pattern="unix-sc_xinetditemuser"/>
      <sch:active pattern="unix-sc_xinetditemwait"/>
      <sch:active pattern="unix-sc_xinetditemdisabled"/>
   </sch:phase>
   <sch:phase id="win-sc">
      <sch:active pattern="win-sc_atitemsecurity_principle"/>
      <sch:active pattern="win-sc_atitemseassignprimarytokenprivilege"/>
      <sch:active pattern="win-sc_atitemseauditprivilege"/>
      <sch:active pattern="win-sc_atitemsebackupprivilege"/>
      <sch:active pattern="win-sc_atitemsechangenotifyprivilege"/>
      <sch:active pattern="win-sc_atitemsecreateglobalprivilege"/>
      <sch:active pattern="win-sc_atitemsecreatepagefileprivilege"/>
      <sch:active pattern="win-sc_atitemsecreatepermanentprivilege"/>
      <sch:active pattern="win-sc_atitemsecreatesymboliclinkprivilege"/>
      <sch:active pattern="win-sc_atitemsecreatetokenprivilege"/>
      <sch:active pattern="win-sc_atitemsedebugprivilege"/>
      <sch:active pattern="win-sc_atitemseenabledelegationprivilege"/>
      <sch:active pattern="win-sc_atitemseimpersonateprivilege"/>
      <sch:active pattern="win-sc_atitemseincreasebasepriorityprivilege"/>
      <sch:active pattern="win-sc_atitemseincreasequotaprivilege"/>
      <sch:active pattern="win-sc_atitemseincreaseworkingsetprivilege"/>
      <sch:active pattern="win-sc_atitemseloaddriverprivilege"/>
      <sch:active pattern="win-sc_atitemselockmemoryprivilege"/>
      <sch:active pattern="win-sc_atitemsemachineaccountprivilege"/>
      <sch:active pattern="win-sc_atitemsemanagevolumeprivilege"/>
      <sch:active pattern="win-sc_atitemseprofilesingleprocessprivilege"/>
      <sch:active pattern="win-sc_atitemserelabelprivilege"/>
      <sch:active pattern="win-sc_atitemseremoteshutdownprivilege"/>
      <sch:active pattern="win-sc_atitemserestoreprivilege"/>
      <sch:active pattern="win-sc_atitemsesecurityprivilege"/>
      <sch:active pattern="win-sc_atitemseshutdownprivilege"/>
      <sch:active pattern="win-sc_atitemsesyncagentprivilege"/>
      <sch:active pattern="win-sc_atitemsesystemenvironmentprivilege"/>
      <sch:active pattern="win-sc_atitemsesystemprofileprivilege"/>
      <sch:active pattern="win-sc_atitemsesystemtimeprivilege"/>
      <sch:active pattern="win-sc_atitemsetakeownershipprivilege"/>
      <sch:active pattern="win-sc_atitemsetcbprivilege"/>
      <sch:active pattern="win-sc_atitemsetimezoneprivilege"/>
      <sch:active pattern="win-sc_atitemseundockprivilege"/>
      <sch:active pattern="win-sc_atitemseunsolicitedinputprivilege"/>
      <sch:active pattern="win-sc_atitemsebatchlogonright"/>
      <sch:active pattern="win-sc_atitemseinteractivelogonright"/>
      <sch:active pattern="win-sc_atitemsenetworklogonright"/>
      <sch:active pattern="win-sc_atitemseremoteinteractivelogonright"/>
      <sch:active pattern="win-sc_atitemseservicelogonright"/>
      <sch:active pattern="win-sc_atitemsedenybatchLogonright"/>
      <sch:active pattern="win-sc_atitemsedenyinteractivelogonright"/>
      <sch:active pattern="win-sc_atitemsedenynetworklogonright"/>
      <sch:active pattern="win-sc_atitemsedenyremoteInteractivelogonright"/>
      <sch:active pattern="win-sc_atitemsedenyservicelogonright"/>
      <sch:active pattern="win-sc_activedirectory_item_dep"/>
      <sch:active pattern="win-sc_aditemnaming_context"/>
      <sch:active pattern="win-sc_aditemrelative_dn"/>
      <sch:active pattern="win-sc_aditemattribute"/>
      <sch:active pattern="win-sc_aditemobject_class"/>
      <sch:active pattern="win-sc_aditemadstype"/>
      <sch:active pattern="win-sc_aditemvalue"/>
      <sch:active pattern="win-sc_activedirectory57_item_naming_context"/>
      <sch:active pattern="win-sc_activedirectory57_item_relative_dn"/>
      <sch:active pattern="win-sc_activedirectory57_item_attribute"/>
      <sch:active pattern="win-sc_activedirectory57_item_object_class"/>
      <sch:active pattern="win-sc_activedirectory57_item_adstype"/>
      <sch:active pattern="win-sc_activedirectory57_item_value"/>
      <sch:active pattern="win-sc_aepitemaccount_logon"/>
      <sch:active pattern="win-sc_aepitemaccount_management"/>
      <sch:active pattern="win-sc_aepitemdetailed_tracking"/>
      <sch:active pattern="win-sc_aepitemdirectory_service_access"/>
      <sch:active pattern="win-sc_aepitemlogon"/>
      <sch:active pattern="win-sc_aepitemobject_access"/>
      <sch:active pattern="win-sc_aepitempolicy_change"/>
      <sch:active pattern="win-sc_aepitemprivilege_use"/>
      <sch:active pattern="win-sc_aepitemsystem"/>
      <sch:active pattern="win-sc_aepsitemcredentialvalidation"/>
      <sch:active pattern="win-sc_aepsitemkerberosauthenticationservice"/>
      <sch:active pattern="win-sc_aepsitemkerberosserviceticketoperations"/>
      <sch:active pattern="win-sc_aepsitemkerberosticketevents"/>
      <sch:active pattern="win-sc_aepsitemotheraccountlogonevents"/>
      <sch:active pattern="win-sc_aepsitemapplicationgroupmanagement"/>
      <sch:active pattern="win-sc_aepsitemcomputeraccountmanagement"/>
      <sch:active pattern="win-sc_aepsitemdistributiongroupmanagement"/>
      <sch:active pattern="win-sc_aepsitemotheraccountmanagementevents"/>
      <sch:active pattern="win-sc_aepsitemsecuritygroupmanagement"/>
      <sch:active pattern="win-sc_aepsitemuseraccountmanagement"/>
      <sch:active pattern="win-sc_aepsitemdpapiactivity"/>
      <sch:active pattern="win-sc_aepsitemprocesscreation"/>
      <sch:active pattern="win-sc_aepsitemprocesstermination"/>
      <sch:active pattern="win-sc_aepsitemrpcevents"/>
      <sch:active pattern="win-sc_aepsitemdirectoryserviceaccess"/>
      <sch:active pattern="win-sc_aepsitemdirectoryservicechanges"/>
      <sch:active pattern="win-sc_aepsitemdirectoryservicereplication"/>
      <sch:active pattern="win-sc_aepsitemdetaileddirectoryservicereplication"/>
      <sch:active pattern="win-sc_aepsitemaccountlockout"/>
      <sch:active pattern="win-sc_aepsitemipsecextendedmode"/>
      <sch:active pattern="win-sc_aepsitemipsecmainmode"/>
      <sch:active pattern="win-sc_aepsitemipsecquickmode"/>
      <sch:active pattern="win-sc_aepsitemlogoff"/>
      <sch:active pattern="win-sc_aepsitemlogon"/>
      <sch:active pattern="win-sc_aepsitemnetworkpolicyserver"/>
      <sch:active pattern="win-sc_aepsitemotherlogonlogoffevents"/>
      <sch:active pattern="win-sc_aepsitemspeciallogon"/>
      <sch:active pattern="win-sc_aepsitemapplicationgenerated"/>
      <sch:active pattern="win-sc_aepsitemcertificationservices"/>
      <sch:active pattern="win-sc_aepsitemdetailedfileshare"/>
      <sch:active pattern="win-sc_aepsitemfileshare"/>
      <sch:active pattern="win-sc_aepsitemfilesystem"/>
      <sch:active pattern="win-sc_aepsitemfilteringplatformconnection"/>
      <sch:active pattern="win-sc_aepsitemfilteringplatformpacketdrop"/>
      <sch:active pattern="win-sc_aepsitemhandlemanipulation"/>
      <sch:active pattern="win-sc_aepsitemkernelobject"/>
      <sch:active pattern="win-sc_aepsitemotherobjectaccessevents"/>
      <sch:active pattern="win-sc_aepsitemregistry"/>
      <sch:active pattern="win-sc_aepsitemsam"/>
      <sch:active pattern="win-sc_aepsitemauditpolicychange"/>
      <sch:active pattern="win-sc_aepsitemauthenticationpolicychange"/>
      <sch:active pattern="win-sc_aepsitemauthorizationpolicychange"/>
      <sch:active pattern="win-sc_aepsitemfilteringplatformpolicychange"/>
      <sch:active pattern="win-sc_aepsitemmpssvcrulelevelpolicychange"/>
      <sch:active pattern="win-sc_aepsitemotherpolicychangeevents"/>
      <sch:active pattern="win-sc_aepsitemnonsensitiveprivilegeuse"/>
      <sch:active pattern="win-sc_aepsitemotherprivilegeuseevents"/>
      <sch:active pattern="win-sc_aepsitemsensitiveprivilegeuse"/>
      <sch:active pattern="win-sc_aepsitemipsecdriver"/>
      <sch:active pattern="win-sc_aepsitemothersystemevents"/>
      <sch:active pattern="win-sc_aepsitemsecuritystatechange"/>
      <sch:active pattern="win-sc_aepsitemsecuritysystemextension"/>
      <sch:active pattern="win-sc_aepsitemsystemintegrity"/>
      <sch:active pattern="win-sc_dnscacheitemdomainname"/>
      <sch:active pattern="win-sc_dnscacheitemttl"/>
      <sch:active pattern="win-sc_dnscacheitemipaddress"/>
      <sch:active pattern="win-sc_fileitemfilepath"/>
      <sch:active pattern="win-sc_fileitempath"/>
      <sch:active pattern="win-sc_fileitemfilename"/>
      <sch:active pattern="win-sc_fileitemowner"/>
      <sch:active pattern="win-sc_fileitemsize"/>
      <sch:active pattern="win-sc_fileitema_time"/>
      <sch:active pattern="win-sc_fileitemc_time"/>
      <sch:active pattern="win-sc_fileitemm_time"/>
      <sch:active pattern="win-sc_fileitemms_checksum"/>
      <sch:active pattern="win-sc_fileitemversion"/>
      <sch:active pattern="win-sc_fileitemtype"/>
      <sch:active pattern="win-sc_fileitemdevelopment_class"/>
      <sch:active pattern="win-sc_fileitemcompany"/>
      <sch:active pattern="win-sc_fileiteminternalname"/>
      <sch:active pattern="win-sc_fileitemlanguage"/>
      <sch:active pattern="win-sc_fileitemoriginalfilename"/>
      <sch:active pattern="win-sc_fileitemproductname"/>
      <sch:active pattern="win-sc_fileitemproductversion"/>
      <sch:active pattern="win-sc_fileaudititemfilepath"/>
      <sch:active pattern="win-sc_fileaudititempath"/>
      <sch:active pattern="win-sc_fileaudititemfilename"/>
      <sch:active pattern="win-sc_fileaudititemtrustee_sid"/>
      <sch:active pattern="win-sc_fileaudititemtrustee_name"/>
      <sch:active pattern="win-sc_fileaudititemstandard_delete"/>
      <sch:active pattern="win-sc_fileaudititemstandard_read_control"/>
      <sch:active pattern="win-sc_fileaudititemstandard_write_dac"/>
      <sch:active pattern="win-sc_fileaudititemstandard_write_owner"/>
      <sch:active pattern="win-sc_fileaudititemstandard_synchronize"/>
      <sch:active pattern="win-sc_fileaudititemaccess_system_security"/>
      <sch:active pattern="win-sc_fileaudititemgeneric_read"/>
      <sch:active pattern="win-sc_fileaudititemgeneric_write"/>
      <sch:active pattern="win-sc_fileaudititemgeneric_execute"/>
      <sch:active pattern="win-sc_fileaudititemgeneric_all"/>
      <sch:active pattern="win-sc_fileaudititemfile_read_data"/>
      <sch:active pattern="win-sc_fileaudititemfile_write_data"/>
      <sch:active pattern="win-sc_fileaudititemfile_append_data"/>
      <sch:active pattern="win-sc_fileaudititemfile_read_ea"/>
      <sch:active pattern="win-sc_fileaudititemfile_write_ea"/>
      <sch:active pattern="win-sc_fileaudititemfile_execute"/>
      <sch:active pattern="win-sc_fileaudititemfile_delete_child"/>
      <sch:active pattern="win-sc_fileaudititemfile_read_attributes"/>
      <sch:active pattern="win-sc_fileaudititemfile_write_attributes"/>
      <sch:active pattern="win-sc_ferititemfilepath"/>
      <sch:active pattern="win-sc_feritempath"/>
      <sch:active pattern="win-sc_feritemfilename"/>
      <sch:active pattern="win-sc_feritemtrustee_sid"/>
      <sch:active pattern="win-sc_feritemtrustee_name"/>
      <sch:active pattern="win-sc_feritemstandard_delete"/>
      <sch:active pattern="win-sc_feritemstandard_read_control"/>
      <sch:active pattern="win-sc_feritemstandard_write_dac"/>
      <sch:active pattern="win-sc_feritemstandard_write_owner"/>
      <sch:active pattern="win-sc_feritemstandard_synchronize"/>
      <sch:active pattern="win-sc_feritemaccess_system_security"/>
      <sch:active pattern="win-sc_feritemgeneric_read"/>
      <sch:active pattern="win-sc_feritemgeneric_write"/>
      <sch:active pattern="win-sc_feritemgeneric_execute"/>
      <sch:active pattern="win-sc_feritemgeneric_all"/>
      <sch:active pattern="win-sc_feritemfile_read_data"/>
      <sch:active pattern="win-sc_feritemfile_write_data"/>
      <sch:active pattern="win-sc_feritemfile_append_data"/>
      <sch:active pattern="win-sc_feritemfile_read_ea"/>
      <sch:active pattern="win-sc_feritemfile_write_ea"/>
      <sch:active pattern="win-sc_feritemfile_execute"/>
      <sch:active pattern="win-sc_feritemfile_delete_child"/>
      <sch:active pattern="win-sc_feritemfile_read_attributes"/>
      <sch:active pattern="win-sc_feritemfile_write_attributes"/>
      <sch:active pattern="win-sc_groupitemgroup"/>
      <sch:active pattern="win-sc_groupitemuser"/>
      <sch:active pattern="win-sc_groupitemsubgroup"/>
      <sch:active pattern="win-sc_groupsiditemgroup"/>
      <sch:active pattern="win-sc_groupsiditemuser"/>
      <sch:active pattern="win-sc_groupsiditemsubgroup"/>
      <sch:active pattern="win-sc_wininterfaceitemname"/>
      <sch:active pattern="win-sc_wininterfaceitemindex"/>
      <sch:active pattern="win-sc_wininterfaceitemtype"/>
      <sch:active pattern="win-sc_wininterfaceitemhardware_addr"/>
      <sch:active pattern="win-sc_wininterfaceiteminet_addr"/>
      <sch:active pattern="win-sc_wininterfaceitembroadcast_addr"/>
      <sch:active pattern="win-sc_wininterfaceitemnetmask"/>
      <sch:active pattern="win-sc_wininterfaceitemaddr_type"/>
      <sch:active pattern="win-sc_lpitemforce_logoff"/>
      <sch:active pattern="win-sc_lpitemlockout_duration"/>
      <sch:active pattern="win-sc_lpitemlockout_observation_window"/>
      <sch:active pattern="win-sc_lpitemlockout_threshold"/>
      <sch:active pattern="win-sc_metabaseitemkey"/>
      <sch:active pattern="win-sc_metabaseitemid"/>
      <sch:active pattern="win-sc_metabaseitemname"/>
      <sch:active pattern="win-sc_metabaseitemuser_type"/>
      <sch:active pattern="win-sc_metabaseitemdata_type"/>
      <sch:active pattern="win-sc_metabaseitemdata"/>
      <sch:active pattern="win-sc_ppitemmax_passwd_age"/>
      <sch:active pattern="win-sc_ppitemmin_passwd_age"/>
      <sch:active pattern="win-sc_ppitemmin_passwd_len"/>
      <sch:active pattern="win-sc_ppitempassword_hist_len"/>
      <sch:active pattern="win-sc_ppitempassword_complexity"/>
      <sch:active pattern="win-sc_ppitemreversible_encryption"/>
      <sch:active pattern="win-sc_winportitemlocal_address"/>
      <sch:active pattern="win-sc_winportitemlocal_port"/>
      <sch:active pattern="win-sc_winportitemprotocol"/>
      <sch:active pattern="win-sc_winportitempid"/>
      <sch:active pattern="win-sc_peritemprinter_name"/>
      <sch:active pattern="win-sc_peritemtrustee_sid"/>
      <sch:active pattern="win-sc_peritemstandard_delete"/>
      <sch:active pattern="win-sc_peritemstandard_read_control"/>
      <sch:active pattern="win-sc_peritemstandard_write_dac"/>
      <sch:active pattern="win-sc_peritemstandard_write_owner"/>
      <sch:active pattern="win-sc_peritemstandard_synchronize"/>
      <sch:active pattern="win-sc_peritemaccess_system_security"/>
      <sch:active pattern="win-sc_peritemgeneric_read"/>
      <sch:active pattern="win-sc_peritemgeneric_write"/>
      <sch:active pattern="win-sc_peritemgeneric_execute"/>
      <sch:active pattern="win-sc_peritemgeneric_all"/>
      <sch:active pattern="win-sc_peritemprinter_access_administer"/>
      <sch:active pattern="win-sc_peritemprinter_access_use"/>
      <sch:active pattern="win-sc_peritemjob_access_administer"/>
      <sch:active pattern="win-sc_peritemjob_access_read"/>
      <sch:active pattern="win-sc_processitemcommand_line"/>
      <sch:active pattern="win-sc_processitempid"/>
      <sch:active pattern="win-sc_processitemppid"/>
      <sch:active pattern="win-sc_processitempriority"/>
      <sch:active pattern="win-sc_processitemimage_path"/>
      <sch:active pattern="win-sc_processitemcurrent_dir"/>
      <sch:active pattern="win-sc_regitemhive"/>
      <sch:active pattern="win-sc_regitemkey"/>
      <sch:active pattern="win-sc_regitemname"/>
      <sch:active pattern="win-sc_regitemtype"/>
      <sch:active pattern="win-sc_regitemresult"/>
      <sch:active pattern="win-sc_rapitemhive"/>
      <sch:active pattern="win-sc_rapitemkey"/>
      <sch:active pattern="win-sc_rapitemtrustee_sid"/>
      <sch:active pattern="win-sc_rapitemtrustee_name"/>
      <sch:active pattern="win-sc_rapitemstandard_delete"/>
      <sch:active pattern="win-sc_rapitemstandard_read_control"/>
      <sch:active pattern="win-sc_rapitemstandard_write_dac"/>
      <sch:active pattern="win-sc_rapitemstandard_write_owner"/>
      <sch:active pattern="win-sc_rapitemstandard_synchronize"/>
      <sch:active pattern="win-sc_rapitemaccess_system_security"/>
      <sch:active pattern="win-sc_rapitemgeneric_read"/>
      <sch:active pattern="win-sc_rapitemgeneric_write"/>
      <sch:active pattern="win-sc_rapitemgeneric_execute"/>
      <sch:active pattern="win-sc_rapitemgeneric_all"/>
      <sch:active pattern="win-sc_rapitemkey_query_value"/>
      <sch:active pattern="win-sc_rapitemkey_set_value"/>
      <sch:active pattern="win-sc_rapitemkey_create_sub_key"/>
      <sch:active pattern="win-sc_rapitemkey_enumerate_sub_keys"/>
      <sch:active pattern="win-sc_rapitemkey_notify"/>
      <sch:active pattern="win-sc_rapitemkey_create_link"/>
      <sch:active pattern="win-sc_rapitemkey_wow64_64key"/>
      <sch:active pattern="win-sc_rapitemkey_wow64_32key"/>
      <sch:active pattern="win-sc_rapitemkey_wow64_res"/>
      <sch:active pattern="win-sc_reritemhive"/>
      <sch:active pattern="win-sc_reritemkey"/>
      <sch:active pattern="win-sc_reritemtrustee_sid"/>
      <sch:active pattern="win-sc_reritemtrustee_name"/>
      <sch:active pattern="win-sc_reritemstandard_delete"/>
      <sch:active pattern="win-sc_reritemstandard_read_control"/>
      <sch:active pattern="win-sc_reritemstandard_write_dac"/>
      <sch:active pattern="win-sc_reritemstandard_write_owner"/>
      <sch:active pattern="win-sc_reritemstandard_synchronize"/>
      <sch:active pattern="win-sc_reritemaccess_system_security"/>
      <sch:active pattern="win-sc_reritemgeneric_read"/>
      <sch:active pattern="win-sc_reritemgeneric_write"/>
      <sch:active pattern="win-sc_reritemgeneric_execute"/>
      <sch:active pattern="win-sc_reritemgeneric_all"/>
      <sch:active pattern="win-sc_reritemkey_query_value"/>
      <sch:active pattern="win-sc_reritemkey_set_value"/>
      <sch:active pattern="win-sc_reritemkey_create_sub_key"/>
      <sch:active pattern="win-sc_reritemkey_enumerate_sub_keys"/>
      <sch:active pattern="win-sc_reritemkey_notify"/>
      <sch:active pattern="win-sc_reritemkey_create_link"/>
      <sch:active pattern="win-sc_reritemkey_wow64_64key"/>
      <sch:active pattern="win-sc_reritemkey_wow64_32key"/>
      <sch:active pattern="win-sc_reritemkey_wow64_res"/>
      <sch:active pattern="win-sc_svceitemservice_name"/>
      <sch:active pattern="win-sc_svceitemtrustee_sid"/>
      <sch:active pattern="win-sc_svceitemstandard_delete"/>
      <sch:active pattern="win-sc_svceitemstandard_read_control"/>
      <sch:active pattern="win-sc_svceitemstandard_write_dac"/>
      <sch:active pattern="win-sc_svceitemstandard_write_owner"/>
      <sch:active pattern="win-sc_svceitemgeneric_read"/>
      <sch:active pattern="win-sc_svceitemgeneric_write"/>
      <sch:active pattern="win-sc_svceitemgeneric_execute"/>
      <sch:active pattern="win-sc_svceitemservice_query_conf"/>
      <sch:active pattern="win-sc_svceitemservice_change_conf"/>
      <sch:active pattern="win-sc_svceitemservice_query_stat"/>
      <sch:active pattern="win-sc_svceitemservice_enum_dependents"/>
      <sch:active pattern="win-sc_svceitemservice_start"/>
      <sch:active pattern="win-sc_svceitemservice_stop"/>
      <sch:active pattern="win-sc_svceitemservice_pause"/>
      <sch:active pattern="win-sc_svceitemservice_interrogate"/>
      <sch:active pattern="win-sc_svceitemservice_user_defined"/>
      <sch:active pattern="win-sc_sritemnetname"/>
      <sch:active pattern="win-sc_sritemshared_type"/>
      <sch:active pattern="win-sc_sritemmax_uses"/>
      <sch:active pattern="win-sc_sritemcurrent_uses"/>
      <sch:active pattern="win-sc_sritemlocal_path"/>
      <sch:active pattern="win-sc_sritemaccess_read_permission"/>
      <sch:active pattern="win-sc_sritemaccess_write_permission"/>
      <sch:active pattern="win-sc_sritemaccess_create_permission"/>
      <sch:active pattern="win-sc_sritemaccess_exec_permission"/>
      <sch:active pattern="win-sc_sritemaccess_delete_permission"/>
      <sch:active pattern="win-sc_sritemaccess_atrib_permission"/>
      <sch:active pattern="win-sc_sritemaccess_perm_permission"/>
      <sch:active pattern="win-sc_sritemaccess_all_permission"/>
      <sch:active pattern="win-sc_siditemtrustee_name"/>
      <sch:active pattern="win-sc_siditemtrustee_sid"/>
      <sch:active pattern="win-sc_siditemtrustee_domain"/>
      <sch:active pattern="win-sc_sidsiditemtrustee_sid"/>
      <sch:active pattern="win-sc_sidsiditemtrustee_name"/>
      <sch:active pattern="win-sc_sidsiditemtrustee_domain"/>
      <sch:active pattern="win-sc_uacitemadminapprovalmode"/>
      <sch:active pattern="win-sc_uacitemelevationpromptadmin"/>
      <sch:active pattern="win-sc_uacitemelevationpromptstandard"/>
      <sch:active pattern="win-sc_uacitemdetectinstallations"/>
      <sch:active pattern="win-sc_uacitemelevatesignedexecutables"/>
      <sch:active pattern="win-sc_uacitemelevateuiaccess"/>
      <sch:active pattern="win-sc_uacitemrunadminsaam"/>
      <sch:active pattern="win-sc_uacitemsecuredesktop"/>
      <sch:active pattern="win-sc_uacitemvirtualizewritefailures"/>
      <sch:active pattern="win-sc_useritemuser"/>
      <sch:active pattern="win-sc_useritemenabled"/>
      <sch:active pattern="win-sc_useritemgroup"/>
      <sch:active pattern="win-sc_usersiditemuser"/>
      <sch:active pattern="win-sc_usersiditemenabled"/>
      <sch:active pattern="win-sc_usersiditemgroup"/>
      <sch:active pattern="win-sc_volitemrootpath"/>
      <sch:active pattern="win-sc_volitemfile_system"/>
      <sch:active pattern="win-sc_volitemname"/>
      <sch:active pattern="win-sc_volitemvolume_max_component_length"/>
      <sch:active pattern="win-sc_volitemserial_number"/>
      <sch:active pattern="win-sc_volitemfile_case_sensitive_search"/>
      <sch:active pattern="win-sc_volitemfile_case_preserved_names"/>
      <sch:active pattern="win-sc_volitemfile_unicode_on_disk"/>
      <sch:active pattern="win-sc_volitemfile_persistent_acls"/>
      <sch:active pattern="win-sc_volitemfile_file_compression"/>
      <sch:active pattern="win-sc_volitemfile_volume_quotas"/>
      <sch:active pattern="win-sc_volitemfile_supports_sparse_files"/>
      <sch:active pattern="win-sc_volitemfile_supports_reparse_points"/>
      <sch:active pattern="win-sc_volitemfile_supports_remote_storage"/>
      <sch:active pattern="win-sc_volitemfile_volume_is_compressed"/>
      <sch:active pattern="win-sc_volitemfile_supports_object_ids"/>
      <sch:active pattern="win-sc_volitemfile_supports_encryption"/>
      <sch:active pattern="win-sc_volitemfile_named_streams"/>
      <sch:active pattern="win-sc_volitemfile_read_only_volume"/>
      <sch:active pattern="win-sc_wmi_item_dep"/>
      <sch:active pattern="win-sc_wmiitemnamespace"/>
      <sch:active pattern="win-sc_wmiitemwql"/>
      <sch:active pattern="win-sc_wmiitemresult"/>
      <sch:active pattern="win-sc_wmi57itemnamespace"/>
      <sch:active pattern="win-sc_wmi57itemwql"/>
      <sch:active pattern="win-sc_wmi57itemresult"/>
      <sch:active pattern="win-sc_wuaupdatesearcheritemsearchcriteria"/>
      <sch:active pattern="win-sc_wuaupdatesearcheritemresult"/>
   </sch:phase>
   <sch:pattern id="oval_none_exist_value_dep">
                                   <sch:rule context="oval-def:oval_definitions/oval-def:tests/child::*">
                                        <sch:report test="@check='none exist'">
                                             DEPRECATED ATTRIBUTE VALUE IN: <sch:value-of select="name()"/> ATTRIBUTE VALUE:
                                        </sch:report>
                                   </sch:rule>
                              </sch:pattern>
   <sch:pattern id="oval-sc_entity_rules">
                    <sch:rule context="oval-sc:system_data/*/*|oval-sc:system_data/*/*/*">
                        <sch:assert test="not(@status) or @status='exists' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the status attribute is 'exists'</sch:assert>
                        <sch:assert test="not(@mask) or @mask='false' or .=''">item <sch:value-of select="../@id"/> - a value for the <sch:value-of select="name()"/> entity should only be supplied if the mask attribute is 'false'</sch:assert>
                        <!--<sch:assert test="if (@datatype='binary') then (matches(., '^[0-9a-fA-F]*$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of binary.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='boolean') then (matches(., '^true$|^false$|^1$|^0$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of boolean.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='evr_string') then (matches(., '^[^:\-]*:[^:\-]*-[^:\-]*$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of evr_string.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='float') then (matches(., '^[+\-]?[0-9]+([\.][0-9]+)?([eE][+\-]?[0-9]+)?$|^NaN$|^INF$|^\-INF$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of float.</sch:assert>-->
                        <!--<sch:assert test="if (@datatype='int') then (matches(., '^[+\-]?[0-9]+$')) else (1=1)"><sch:value-of select="../@id"/> - A value of '<sch:value-of select="."/>' for the <sch:value-of select="name()"/> entity is not valid given a datatype of int.</sch:assert>-->
                    </sch:rule>
                    <sch:rule context="oval-sc:system_data/*/*[not(@xsi:nil='true') and @datatype='int']|oval-sc:system_data/*/*/*[not(@xsi:nil='true') and @datatype='int']">
                        <sch:assert test="(not(contains(.,'.'))) and (number(.) = floor(.))">
            <sch:value-of select="../@id"/> - The datatype for the <sch:value-of select="name()"/> entity is 'int' but the value is not an integer.</sch:assert>
                        <!--  Must test for decimal point because number(x.0) = floor(x.0) is true -->                        
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="oval-sc_item_record_fields">
                    <sch:rule context="oval-sc:system_data/*/*/*">
                            <sch:assert test="not(@datatype='record')">
                                <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> field of an <sch:value-of select="name(../..)"/> should not be 'record'
                            </sch:assert>
                    </sch:rule>
                </sch:pattern>
   <sch:pattern id="ind-sc_famitemfamily">
                                                  <sch:rule context="ind-sc:family_item/ind-sc:family">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the family entity of a family_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_hashitemfilepath">
                                                  <sch:rule context="ind-sc:filehash_item/ind-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a filehash_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_hashitempath">
                                                  <sch:rule context="ind-sc:filehash_item/ind-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a filehash_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_hashitemfilename">
                                                  <sch:rule context="ind-sc:filehash_item/ind-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a filehash_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_hashitemmd5">
                                                  <sch:rule context="ind-sc:filehash_item/ind-sc:md5">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the md5 entity of a filehash_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_hashitemsha1">
                                                  <sch:rule context="ind-sc:filehash_item/ind-sc:sha1">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sha1 entity of a filehash_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_envitemname">
                                                  <sch:rule context="ind-sc:environmentvariable_item/ind-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of an environmentvariable_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-def_envitemvalue">
                                                  <sch:rule context="ind-def:environmentvariable_item/ind-def:value">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap_item_dep">
                         <sch:rule context="ind-def:ldap_item">
                              <sch:report test="true()">DEPRECATED ITEM: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="ind-sc_ldapitemsuffix">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:suffix">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldapitemrelative_dn">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:relative_dn">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap_item should be 'string'</sch:assert>
                                                       <sch:assert test="not(@xsi:nil='true') or ../ind-sc:attribute/@xsi:nil='true'">
            <sch:value-of select="../@id"/> - attribute entity must be nil when relative_dn is nil</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldapitemattribute">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:attribute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldapitemobject_class">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:object_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an ldap_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldapitemldaptype">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:ldaptype">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ldaptype entity of an ldap_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-def_ldapitemvalue">
                                                  <sch:rule context="ind-sc:ldap_item/ind-sc:value">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57itemsuffix">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:suffix">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the suffix entity of an ldap57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57itemrelative_dn">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:relative_dn">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an ldap57_item should be 'string'</sch:assert>
                                                       <sch:assert test="not(@xsi:nil='true') or ../ind-sc:attribute/@xsi:nil='true'">
            <sch:value-of select="../@id"/> - attribute entity must be nil when relative_dn is nil</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57itemattribute">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:attribute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an ldap57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57itemobject_class">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:object_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an ldap57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57itemldaptype">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:ldaptype">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ldaptype entity of an ldap57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldap57_item_value">
                                                  <sch:rule context="ind-sc:ldap57_item/ind-sc:value">
                                                       <sch:assert test="@datatype='record'">item <sch:value-of select="../@id"/> - datatype attribute for the value entity of a ldap57_item must be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql_item_dep">
                         <sch:rule context="ind-def:sql_item">
                              <sch:report test="true()">DEPRECATED ITEM: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="ind-sc_sqlitemengine">
                                                  <sch:rule context="ind-sc:sql_item/ind-sc:engine">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sqlitemversion">
                                                  <sch:rule context="ind-sc:sql_item/ind-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sqlitemconnection_string">
                                                  <sch:rule context="ind-sc:sql_item/ind-sc:connection_string">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sqlitemsql">
                                                  <sch:rule context="ind-sc:sql_item/ind-sc:sql">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sql entity of an sql_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-def_sqlitemresult">
                                                  <sch:rule context="ind-sc:sql_item/ind-sc:result">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql7itemengine">
                                                  <sch:rule context="ind-sc:sql57_item/ind-sc:engine">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the engine entity of an sql57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql57itemversion">
                                                  <sch:rule context="ind-sc:sql57_item/ind-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of an sql57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql57itemconnection_string">
                                                  <sch:rule context="ind-sc:sql57_item/ind-sc:connection_string">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the connection_string entity of an sql57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql57itemsql">
                                                  <sch:rule context="ind-sc:sql57_item/ind-sc:sql">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sql entity of an sql57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_sql57_item_value">
                                                  <sch:rule context="ind-sc:sql57_item/ind-sc:result">
                                                       <sch:assert test="@datatype='record'">item <sch:value-of select="../@id"/> - datatype attribute for the result entity of a sql57_item must be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_txtitemfilepath">
                                                  <sch:rule context="ind-sc:textfilecontent_item/ind-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a textfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_txtitempath">
                                                  <sch:rule context="ind-sc:textfilecontent_item/ind-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a textfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_txtitemfilename">
                                                  <sch:rule context="ind-sc:textfilecontent_item/ind-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a textfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_txtitempattern">
                                                       <sch:rule context="ind-sc:textfilecontent_item/ind-sc:pattern">
                                                             <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pattern entity of a textfilecontent_item should be 'string'</sch:assert>
                                                       </sch:rule>
                                                 </sch:pattern>
   <sch:pattern id="ind-sc_txtiteminstance">
                                                       <sch:rule context="ind-sc:textfilecontent_item/ind-sc:instance">
                                                             <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the instance entity of a textfilecontent_item should be 'int'</sch:assert>
                                                       </sch:rule>
                                                 </sch:pattern>
   <sch:pattern id="ind-sc_txtitemline">
                                                  <sch:rule context="ind-sc:textfilecontent_item/ind-sc:line">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the line entity of a textfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_txtitemtext">
                                                       <sch:rule context="ind-sc:textfilecontent_item/ind-sc:text">
                                                             <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the text entity of a textfilecontent_item should be 'string'</sch:assert>
                                                       </sch:rule>
                                                 </sch:pattern>
   <sch:pattern id="ind-def_txtitemsubexpression">
                                                  <sch:rule context="ind-sc:textfilecontent_item/ind-sc:subexpression">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_varitemvar_ref">
                                                  <sch:rule context="ind-sc:variable_item/ind-sc:var_ref">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the var_ref entity of a variable_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_xmlitemfilepath">
                                                  <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a xmlfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_xmlitempath">
                                                  <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a xmlfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_xmlitemfilename">
                                                  <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a xmlfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_xmlitemxpath">
                                                  <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:xpath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the xpath entity of a xmlfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_xmlitemvalue_of">
                                                  <sch:rule context="ind-sc:xmlfilecontent_item/ind-sc:value_of">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the value_of entity of a xmlfilecontent_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ind-sc_ldaptype_timestamp_value_dep">
                                        <sch:rule context="oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:ldap_item/ind-sc:ldaptype|oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:ldap57_item/ind-sc:ldaptype">
                                             <sch:report test=".='LDAPTYPE_TIMESTAMP'">
                                                  DEPRECATED ELEMENT VALUE IN: ldap_item ELEMENT VALUE: <sch:value-of select="."/> 
                                             </sch:report>
                                        </sch:rule>
                                   </sch:pattern>
   <sch:pattern id="ind-sc_ldaptype_email_value_dep">
                                        <sch:rule context="oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:ldap_item/ind-sc:ldaptype|oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:ldap57_item/ind-sc:ldaptype">
                                             <sch:report test=".='LDAPTYPE_EMAIL'">
                                                  DEPRECATED ELEMENT VALUE IN: ldap_item ELEMENT VALUE: <sch:value-of select="."/> 
                                             </sch:report>
                                        </sch:rule>
                                   </sch:pattern>
   <sch:pattern id="aix-sc_interimfixitemvuid">
                                                  <sch:rule context="aix-sc:interim_fix_item/aix-sc:vuid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the <sch:name/> entity of a <sch:name path=".."/> should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_interimfixitemlabel">
                                                  <sch:rule context="aix-sc:interim_fix_item/aix-sc:label">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the <sch:name/> entity of a <sch:name path=".."/> should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_interimfixitemabstract">
                                                  <sch:rule context="aix-sc:interim_fix_item/aix-sc:abstract">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the <sch:name/> entity of a <sch:name path=".."/> should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_interimfixitemstate">
                                                  <sch:rule context="aix-sc:interim_fix_item/aix-sc:state">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the <sch:name/> entity of a <sch:name path=".."/> should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_filesetitemflstinst">
                                                  <sch:rule context="aix-sc:fileset_item/aix-sc:flstinst">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the flstinst entity of a fileset_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_filesetitemlevel">
                                                  <sch:rule context="aix-sc:fileset_item/aix-sc:level">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the level entity of a fileset_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_filesetitemstate">
                                                  <sch:rule context="aix-sc:fileset_item/aix-sc:state">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the state entity of a fileset_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_filesetitemdescription">
                                                  <sch:rule context="aix-sc:fileset_item/aix-sc:description">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a fileset_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_fixitemapar_number">
                                                  <sch:rule context="aix-sc:fix_item/aix-sc:apar_number">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the apar_number entity of a fix_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_fixitemabstract">
                                                  <sch:rule context="aix-sc:fix_item/aix-sc:abstract">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the abstract entity of a fix_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_fixitemsymptom">
                                                  <sch:rule context="aix-sc:fix_item/aix-sc:symptom">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the symptom entity of a fix_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_fixiteminstallation_status">
                                                  <sch:rule context="aix-sc:fix_item/aix-sc:installation_status">
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the installation_status entity of a fix_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="aix-sc_oslevelitemmaintenance_level">
                                                            <sch:rule context="aix-sc:oslevel_item/aix-sc:maintenance_level">
                                                                  <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the maintenance_level entity of an oslevel_item should be 'version'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="apache-sc_httpditempath">
										<sch:rule context="apache-sc:httpd_item/apache-sc:path">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a httpd_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="apache-sc_httpditembinaryname">
										<sch:rule context="apache-sc:httpd_item/apache-sc:binary_name">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the binary_name entity of a httpd_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="apache-sc_httpditemversion">
										<sch:rule context="apache-sc:httpd_item/apache-sc:version">
											<sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a httpd_item should be 'version'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="catos-sc_lineitemshow_subcommand">
                                        <sch:rule context="catos-sc:line_item/catos-sc:show_subcommand">
                                            <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the show_subcommand entity of a line_item should be 'string'</sch:assert>
                                        </sch:rule>
                                    </sch:pattern>
   <sch:pattern id="catos-sc_lineitemconfig_line">
                                        <sch:rule context="catos-sc:line_item/catos-sc:config_line">
                                            <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the config_line entity of a line_item should be 'string'</sch:assert>
                                        </sch:rule>
                                    </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemmodule_number">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:module_number">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the module_number entity of a module_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemtype">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of a module_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemmodel">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:model">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the model entity of a module_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemsoftware_major_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:software_major_release">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the software_major_release entity of a module_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemsoftware_individual_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:software_individual_release">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the software_individual_release entity of a module_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemsoftware_version_id">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:software_version_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the software_version_id entity of a module_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemhardware_major_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:hardware_major_release">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the hardware_major_release entity of a module_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemhardware_individual_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:hardware_individual_release">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the hardware_individual_release entity of a module_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemfirmware_major_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:firmware_major_release">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the firmware_major_release entity of a module_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_moduleitemfirmware_individual_release">
                                                  <sch:rule context="catos-sc:module_item/catos-sc:firmware_individual_release">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the firmware_individual_release entity of a module_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_versionitemswitch_series">
                                                  <sch:rule context="catos-sc:version_item/catos-sc:switch_series">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the switch_series entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_versionitemimage_name">
                                                  <sch:rule context="catos-sc:version_item/catos-sc:image_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the image_name entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_versionitemcatos_release">
                                             <sch:rule context="catos-sc:version_item/catos-sc:catos_release">
                                                 <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the catos_release entity of a version_item should be 'version'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="catos-sc_versionitemcatos_major_release">
                                                  <sch:rule context="catos-sc:version_item/catos-sc:catos_major_release">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the catos_major_release entity of a version_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_versionitemcatos_individual_release">
                                                  <sch:rule context="catos-sc:version_item/catos-sc:catos_individual_release">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the catos_individual_release entity of a version_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="catos-sc_versionitemcatos_version_id">
                                                  <sch:rule context="catos-sc:version_item/catos-sc:catos_version_id">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the catos_version_id entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="esx-sc_patchitempatch_number">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:patch_number">
                                                                  <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the patch_number entity of a patch_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitempatch_name">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:patch_name">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the patch_name entity of a patch_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitemkb_id">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:knowledge_base_id">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the knowledge_base_id entity of a patch_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitembundle_id">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:bundle_id">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the bundle_id entity of a patch_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitemclassification">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:classification">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the classification entity of a patch_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitemsupport_level">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:support_level">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the support_level entity of a patch_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_patchitemstatus">
                                                            <sch:rule context="esx-sc:patch_item/esx-sc:status">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the status entity of a patch_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_versionitemrelease">
                                                            <sch:rule context="esx-sc:version_item/esx-sc:release">
                                                                  <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the release entity of a version_item should be 'version'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="esx-sc_versionitembuild">
                                                            <sch:rule context="esx-sc:version_item/esx-sc:build">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the build entity of a version_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitempkginst">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:pkginst">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pkginst entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitemname">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitemcategory">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:category">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the category entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitemversion">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitemvendor">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:vendor">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the vendor entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="freebsd-sc_portinfoitemdescription">
                                                  <sch:rule context="freebsd-sc:portinfo_item/freebsd-sc:description">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a portinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="hpux-sc_gcitemparameter_name">
										<sch:rule context="hpux-sc:getconf_item/hpux-sc:parameter_name">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the parameter_name entity of a getconf_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_gcitempathname">
										<sch:rule context="hpux-sc:getconf_item/hpux-sc:pathname">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pathname entity of a getconf_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_gcitemoutput">
										<sch:rule context="hpux-sc:getconf_item/hpux-sc:output">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the output entity of a getconf_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_patchitemswtype">
					                        <sch:rule context="hpux-sc:patch_item/hpux-sc:swtype">
					                              <sch:assert test="not(@datatype) or @datatype='string'">
            <sch:value-of select="../@id"/> - datatype attribute for the swtype entity of a patch_item should be 'string'</sch:assert>
					                         </sch:rule>
					                    </sch:pattern>
   <sch:pattern id="hpux-sc_patchitemarea_patched">
										<sch:rule context="hpux-sc:patch_item/hpux-sc:area_patched">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the area_patched entity of a patch_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_patchitempatch_number">
										<sch:rule context="hpux-sc:patch_item/hpux-sc:patch_number">
											<sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the patch_number entity of a patch_item should be 'int'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitemswlist">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:swlist">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the swlist entity of a swlist_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitembundle">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:bundle">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the bundle entity of a swlist_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitemfileset">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:fileset">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the fileset entity of a swlist_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitemversion">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:version">
										      <sch:assert test="@datatype='fileset_revision'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a swlist_item should be 'fileset_revision'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitemtitle">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:title">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the title entity of a swlist_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_swlistitemvendor">
										<sch:rule context="hpux-sc:swlist_item/hpux-sc:vendor">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the vendor entity of a swlist_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemtrustitem">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:trustitem">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustitem entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemuid">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:uid">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the uid entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempassword">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:password">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the password entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemaccount_owner">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:account_owner">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the account_owner entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemboot_auth">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:boot_auth">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the boot_auth entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemaudit_id">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:audit_id">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the audit_id entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemaudit_flag">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:audit_flag">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the audit_flag entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_change_min">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_min">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_change_min entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_max_size">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_max_size">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_max_size entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_expiration">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_expiration">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_expiration entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_life">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_life">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_life entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_change_s">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_s">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_change_s entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_change_u">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_change_u">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_change_u entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemacct_expire">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:acct_expire">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the acct_expire entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemmax_llogin">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:max_llogin">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the max_llogin entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemexp_warning">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:exp_warning">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exp_warning entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemusr_chg_pw">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:usr_chg_pw">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the usr_chg_pw entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemgen_pw">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:gen_pw">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the gen_pw entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_restrict">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_restrict">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_restrict entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_null">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_null">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_null entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_gen_char">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_gen_char">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_gen_char entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_gen_let">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:swlistpw_gen_let">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_gen_let entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlogin_time">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_time entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitempw_changer">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:pw_changer">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pw_changer entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlogin_time_s">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time_s">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_time_s entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlogin_time_u">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:login_time_u">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_time_u entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlogin_tty_s">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:login_tty_s">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_tty_s entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlogin_tty_u">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:login_tty_u">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_tty_u entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemnum_u_logins">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:num_u_logins">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the num_u_logins entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemmax_u_logins">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:max_u_logins">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the max_u_logins entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="hpux-sc_trustitemlock_flag">
										<sch:rule context="hpux-sc:trusted_item/hpux-sc:lock_flag">
											<sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the lock_flag entity of a trusted_item should be 'string'</sch:assert>
										</sch:rule>
									</sch:pattern>
   <sch:pattern id="ios-sc_globalitemglobal_command">
                                                  <sch:rule context="ios-sc:global_item/ios-sc:global_command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the global_command entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_interfaceitemname">
                                                  <sch:rule context="ios-sc:interface_item/ios-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_interfaceitemip_directed_broadcast_command">
                                                  <sch:rule context="ios-sc:interface_item/ios-sc:ip_directed_broadcast_command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ip_directed_broadcast_command entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_interfaceitemno_ip_directed_broadcast_command">
                                                  <sch:rule context="ios-sc:interface_item/ios-sc:no_ip_directed_broadcast_command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the no_ip_directed_broadcast_command entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_interfaceitemproxy_arp_command">
                                                  <sch:rule context="ios-sc:interface_item/ios-sc:proxy_arp_command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the proxy_arp_command entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_interfaceitemshutdown_command">
                                                  <sch:rule context="ios-sc:interface_item/ios-sc:shutdown_command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the shutdown_command entity of a global_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_lineitemshow_subcommand">
                                                  <sch:rule context="ios-sc:line_item/ios-sc:show_subcommand">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the show_subcommand entity of a line_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_lineitemconfig_line">
                                                  <sch:rule context="ios-sc:line_item/ios-sc:config_line">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the config_line entity of a line_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_snmpitemaccess_list">
                                                  <sch:rule context="ios-sc:snmp_item/ios-sc:access_list">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the access_list entity of a snmp_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_snmpitemcommunity_name">
                                                  <sch:rule context="ios-sc:snmp_item/ios-sc:community_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the community_name entity of a snmp_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_tclshitemavailable">
                                                  <sch:rule context="ios-sc:tclsh_item/ios-sc:available">
                                                       <sch:assert test="not(@datatype) or @datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the available entity of a tclsh_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_versionitemmajor_release">
                                                  <sch:rule context="ios-sc:version_item/ios-sc:major_release">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the major_release entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_versionitemtrain_number">
                                                  <sch:rule context="ios-sc:version_item/ios-sc:train_number">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the train_number entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_versionitemmajorversion">
                                             <sch:rule context="ios-sc:version_item/ios-sc:major_version">
                                                 <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the major_version entity of a version_item should be 'int'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemminorversion">
                                             <sch:rule context="ios-sc:version_item/ios-sc:minor_version">
                                                 <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the minor_version entity of a version_item should be 'int'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemrelease">
                                             <sch:rule context="ios-sc:version_item/ios-sc:release">
                                                 <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the release entity of a version_item should be 'int'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemtrain_identifier">
                                                  <sch:rule context="ios-sc:version_item/ios-sc:train_identifier">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the train_identifier entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="ios-sc_versionitemrebuild">
                                             <sch:rule context="ios-sc:version_item/ios-sc:rebuild">
                                                 <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the rebuild entity of a version_item should be 'int'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemsubrebuild">
                                             <sch:rule context="ios-sc:version_item/ios-sc:subrebuild">
                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the subrebuild entity of a version_item should be 'string'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemmainlinerebuild">
                                             <sch:rule context="ios-sc:version_item/ios-sc:mainline_rebuild">
                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the mainline_rebuild entity of a version_item should be 'string'</sch:assert>
                                             </sch:rule>
                                         </sch:pattern>
   <sch:pattern id="ios-sc_versionitemversion_string">
                                                  <sch:rule context="ios-sc:version_item/ios-sc:version_string">
                                                       <sch:assert test="not(@datatype) or @datatype='ios_version'">item <sch:value-of select="../@id"/> - datatype attribute for the version_string entity of a version_item should be 'ios_version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemname">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a dpkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemarch">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:arch">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the arch entity of a dpkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemepoch">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:epoch">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the epoch entity of a dpkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemrelease">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:release">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the release entity of a dpkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemversion">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a dpkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_dpkgitemevr">
                                                  <sch:rule context="linux-sc:dpkginfo_item/linux-sc:evr">
                                                       <sch:assert test="not(@datatype) or @datatype='evr_string'">item <sch:value-of select="../@id"/> - datatype attribute for the evr entity of a dpkginfo_item should be 'evr_string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemprotocol">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:protocol">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemlocal_address">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemlocal_port">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_port">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemlocal_full_address">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:local_full_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemprogram_name">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:program_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the program_name entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemforeign_address">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemforeign_port">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_port">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemforeign_full_address">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:foreign_full_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitempid">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:pid">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pid entity of an inetlisteningserver_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_ilsitemuser_id">
                                                  <sch:rule context="linux-sc:inetlisteningserver_item/linux-sc:user_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_id entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemname">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemarch">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:arch">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the arch entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemepoch">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:epoch">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the epoch entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemrelease">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:release">
                                                       <sch:assert test="not(@datatype) or @datatype='string' or @datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the release entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemversion">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string' or @datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemevr">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:evr">
                                                       <sch:assert test="not(@datatype) or @datatype='evr_string'">item <sch:value-of select="../@id"/> - datatype attribute for the evr entity of a rpminfo_item should be 'evr_string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_rpmitemsignature_keyid">
                                                  <sch:rule context="linux-sc:rpminfo_item/linux-sc:signature_keyid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the signature_keyid entity of a rpminfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_spkginfoitemname">
                                                  <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a slackwarepkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_spkginfoitemversion">
                                                  <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a slackwarepkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_spkginfoitemarchitecture">
                                                  <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:architecture">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the architecture entity of a slackwarepkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="linux-sc_spkginfoitemrevision">
                                                  <sch:rule context="linux-sc:slackwarepkginfo_item/linux-sc:revision">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the revision entity of a slackwarepkginfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemusername">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:username">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the username entity of an accountinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitempassword">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:password">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the password entity of an accountinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemuid">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:uid">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the uid entity of an accountinfo_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemgid">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:gid">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the gid entity of an accountinfo_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemrealname">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:realname">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the realname entity of an accountinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemhome_dir">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:home_dir">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the home_dir entity of an accountinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_accountitemlogin_shell">
                                                  <sch:rule context="macos-sc:accountinfo_item/macos-sc:login_shell">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_shell entity of an accountinfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemprogram_name">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:program_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the program_name entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemlocal_address">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemlocal_full_address">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_full_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemlocal_port">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:local_port">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemforeign_address">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemforeign_full_address">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_full_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_full_address entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemforeign_port">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:foreign_port">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the foreign_port entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitempid">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:pid">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pid entity of an inetlisteningserver_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemprotocol">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:protocol">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_ilsitemuser_id">
                                                  <sch:rule context="macos-sc:inetlisteningserver_item/macos-sc:user_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_id entity of an inetlisteningserver_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_nvramitemnvram_var">
                                                  <sch:rule context="macos-sc:nvram_item/macos-sc:nvram_var">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the nvram_var entity of a nvram_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_nvramitemnvram_value">
                                                  <sch:rule context="macos-sc:nvram_item/macos-sc:nvram_value">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the nvram_value entity of a nvram_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemtargetuser">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:target_user">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the target_user entity of a pwpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemusername">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:username">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the username entity of a pwpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemuserpass">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:userpass">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the userpass entity of a pwpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemdirectory_node">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:directory_node">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the directory_node entity of a pwpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemmaxChars">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:maxChars">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the maxChars entity of a pwpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemmaxFailedLoginAttempts">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:maxFailedLoginAttempts">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the maxFailedLoginAttempts entity of a pwpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemminChars">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:minChars">
                                                       <sch:assert test="not(@datatype) or @datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the minChars entity of a pwpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitempasswordCannotBeName">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:passwordCannotBeName">
                                                       <sch:assert test="not(@datatype) or @datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the passwordCannotBeName entity of a pwpolicy_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemrequiresAlpha">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:requiresAlpha">
                                                       <sch:assert test="not(@datatype) or @datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the requiresAlpha entity of a pwpolicy_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="macos-sc_pwpitemrequiresNumeric">
                                                  <sch:rule context="macos-sc:pwpolicy_item/macos-sc:requiresNumeric">
                                                       <sch:assert test="not(@datatype) or @datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the requiresNumeric entity of a pwpolicy_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_lineitemshow_subcommand">
                                                  <sch:rule context="pixos-sc:line_item/pixos-sc:show_subcommand">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the show_subcommand entity of a line_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_lineitemconfig_line">
                                                  <sch:rule context="pixos-sc:line_item/pixos-sc:config_line">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the config_line entity of a line_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_versionitempix_release">
                                                  <sch:rule context="pixos-sc:version_item/pixos-sc:pix_release">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pix_release entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_versionitempix_major_release">
                                                  <sch:rule context="pixos-sc:version_item/pixos-sc:pix_major_release">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pix_major_release entity of a version_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_versionitempix_minor_release">
                                                  <sch:rule context="pixos-sc:version_item/pixos-sc:pix_minor_release">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the pix_minor_release entity of a version_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="pixos-sc_versionitempix_build">
                                                  <sch:rule context="pixos-sc:version_item/pixos-sc:pix_build">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pix_build entity of a version_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sp-sc_webappitemwebapplicationurl">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:webapplicationurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the webapplicationurl entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemallowparttopartcommunication">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:allowparttopartcommunication">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the allowparttopartcommunication entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemallowaccesstowebpartcatalog">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:allowaccesstowebpartcatalog">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the allowaccesstowebpartcatalog entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemblockedfileextention">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:blockedfileextentions">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the blockedfileextention entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemdefaultquotatemplate">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:defaultquotatemplate">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the defaultquotatemplate entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemexternalworkflowparticipantsenabled">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:externalworkflowparticipantsenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the externalworkflowparticipantsenabled entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemrecyclebinenabled">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:recyclebinenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the recyclebinenabled entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemautomaticallydeleteunusedsitecollections">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:automaticallydeleteunusedsitecollections">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the automaticallydeleteunusedsitecollections entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemselfservicesitecreationenabled">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:selfservicesitecreationenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the selfservicesitecreationenabled entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemsecondstagerecyclebinquota">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:secondstagerecyclebinquota">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the secondstagerecyclebinquota entity of a spwebapplication_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemrecyclebinretentionperiod">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:recyclebinretentionperiod">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the recyclebinretentionperiod entity of a spwebapplication_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemoutboundmailserverinstance">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:outboundmailserverinstance">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the outboundmailserverinstance entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemoutboundmailsenderaddress">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:outboundmailsenderaddress">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the outboundmailsenderaddress entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemoutboundmailreplytoaddress">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:outboundmailreplytoaddress">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the outboundmailreplytoaddress entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemsecvalexpires">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:secvalexpires">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for thesecvalexpires entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemtimeout">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:timeout">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the timeout entity of a spwebapplication_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemisadministrationwebapplication">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:isadministrationwebapplication">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the isadministrationwebapplication entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemapplicationpoolname">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:applicationpoolname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the applicationpoolname entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemapplicationpoolusername">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:applicationpoolusername">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the applicationpoolusername entity of a spwebapplication_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemopenitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:openitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the openitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemaddlistitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:addlistitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the addlistitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemapproveitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:approveitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the approveitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemdeletelistitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:deletelistitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the deletelistitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemdeleteversions">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:deleteversions">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the deleteversions entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemeditlistitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:editlistitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the editlistitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanagelists">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:managelists">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the managelists entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemviewversions">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:viewversions">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the viewversions entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemviewlistitems">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:viewlistitems">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the viewlistitems entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemcancelcheckout">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:cancelcheckout">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the cancelcheckout entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemcreatealerts">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:createalerts">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the createalerts entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemviewformpages">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:viewformpages">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the viewformpages entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemviewpages">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:viewpages">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the viewpages entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemaddandcustomizepages">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:addandcustomizepages">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the addandcustomizepages entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemapplystylesheets">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:applystylesheets">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the applystylesheets entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemapplythemeandborder">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:applythemeandborder">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the applythemeandborder entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitembrowsedirectories">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:browsedirectories">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the browsedirectories entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitembrowseuserinfo">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:browseuserinfo">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the browseuserinfo entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemcreategroups">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:creategroups">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the creategroups entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemcreatesscsite">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:createsscsite">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the createsscsite entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemeditmyuserinfo">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:editmyuserinfo">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the editmyuserinfo entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemenumeratepermissions">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:enumeratepermissions">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the enumeratepermissions entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanagealerts">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:managealerts">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the managealerts entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanagepermissions">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:managepermissions">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the managepermissions entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanagesubwebs">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:managesubwebs">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the managesubwebs entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanageweb">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:manageweb">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the manageweb entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemopens">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:open">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the open entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemuseclientintegration">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:useclientintegration">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the useclientintegration entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemuseremoteapis">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:useremoteapis">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the useremoteapis entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemviewusagedata">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:viewusagedata">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the viewusagedata entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemmanagepersonalviews">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:managepersonalviews">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the managepersonalviews entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemadddelprivatewebparts">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:adddelprivatewebparts">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the adddelprivatewebparts entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webappitemupdatepersonalwebparts">
                                                            <sch:rule context="sp-sc:spwebapplication_item/sp-sc:updatepersonalwebparts">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the updatepersonalwebparts entity of an spwebapplication_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_grpitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:spgroup_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a spgroup_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_grpitemgname">
                                                            <sch:rule context="sp-sc:spgroup_item/sp-sc:gname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the gname entity of a spgroup_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_grpitemautoacceptrequesttojoinleave">
                                                            <sch:rule context="sp-sc:spgroup_item/sp-sc:autoacceptrequesttojoinleave">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the autoacceptrequesttojoinleave entity of an spgroup_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_grpitemallowmemberseditmembership">
                                                            <sch:rule context="sp-sc:spgroup_item/sp-sc:allowmemberseditmembership">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the allowmemberseditmembership entity of an spgroup_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_grpitemonlyallowmembersviewmembership">
                                                            <sch:rule context="sp-sc:spgroup_item/sp-sc:onlyallowmembersviewmembership">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the onlyallowmembersviewmembership entity of an spgroup_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webitemwebcollectionurl">
                                                            <sch:rule context="sp-sc:spweb_item/sp-sc:webcollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the webapplicationurl entity of a spgroup_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:spweb_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a spgroup_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webitemsecondarysitecolladmin">
                                                            <sch:rule context="sp-sc:spweb_item/sp-sc:secondarysitecolladmin">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the secondarysitecolladmin entity of a spgroup_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webitemsecondsitecolladminenabled">
                                                            <sch:rule context="sp-sc:spweb_item/sp-sc:secondsitecolladminenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secondsiteadminenabled entity of an spweb_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_webitemallowanonymousaccess">
                                                            <sch:rule context="sp-sc:spweb_item/sp-sc:allowanonymousaccess">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the allowanonymousaccess entity of an spweb_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_listitemspwebsiteurl">
                                                            <sch:rule context="sp-sc:splist_item/sp-sc:spwebsiteurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the websiteurl entity of a splist_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_listitemirmenabled">
                                                            <sch:rule context="sp-sc:splist_item/sp-sc:irmenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the irmenabled entity of an splist_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_listitemenableversioning">
                                                            <sch:rule context="sp-sc:splist_item/sp-sc:enableversioning">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the enableversioning entity of an splist_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_listitemnocrawl">
                                                            <sch:rule context="sp-sc:splist_item/sp-sc:nocrawl">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the nocrawl entity of an splist_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemspwebservicename">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:spwebservicename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the spwebservicename entity of a spantivirussettings_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemspfarmname">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:spfarmname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the spfarmname entity of a spantivirussettings_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemallowdownload">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:allowdownload">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the allowdownload entity of an spantivirussettings_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemcleaningenabled">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:cleaningenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the cleaningenabled entity of an spantivirussettings_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemdownloadscanenabled">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:downloadscanenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the downloadscanenabled entity of an spantivirussettings_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemnumberofthreads">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:numberofthreads">
                                                                  <sch:assert test="@datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the numberofthreads entity of an spantivirussettings_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemskipsearchcrawl">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:skipsearchcrawl">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the skipsearchcrawl entity of an spantivirussettings_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemtimeout">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:timeout">
                                                                  <sch:assert test="@datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the timeout entity of an spantivirussettings_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemuploadscanenabled">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:uploadscanenabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the uploadscanenabled entity of an spantivirussettings_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_avsitemvendorupdatecount">
                                                            <sch:rule context="sp-sc:spantivirussettings_item/sp-sc:vendorupdatecount">
                                                                  <sch:assert test="@datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the vendorupdatecount entity of an spantivirussettings_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteadminitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:spsiteadministration_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a spsiteadministration_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteadminitemstoragemaxlevel">
                                                            <sch:rule context="sp-sc:spsiteadministration_item/sp-sc:storagemaxlevel">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the storagemaxlevel entity of a spsiteadministration_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteadminitemstoragewarninglevel">
                                                            <sch:rule context="sp-sc:spsiteadministration_item/sp-sc:storagewarninglevel">
                                                                  <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the storagewarninglevel entity of a spwebapplication_item should be 'int'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:spsite_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a spsite_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteitemquotaname">
                                                            <sch:rule context="sp-sc:spsite_item/sp-sc:quotaname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the quotaname entity of a spsite_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_siteitemurl">
                                                            <sch:rule context="sp-sc:spsite_item/sp-sc:url">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the url entity of a spsite_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemsiteurl">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:siteurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the spsiteurl entity of a spcrawlrule_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemcrawlashttp">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:crawlashttp">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the crawlashttp entity of an spcrawlrule_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemenabled">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:enabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the enabled entity of an spcrawlrule_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemfollowcomplexurls">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:followcomplexurls">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the followcomplexurls entity of an spcrawlrule_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critempath">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:path">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a spcrawlrule_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critempriority">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:priority">
                                                                  <sch:assert test="@datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the priority entity of an spcrawlrule_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemsuppressindexing">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:suppressindexing">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the suppressindexing entity of an spcrawlrule_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_critemaccountname">
                                                            <sch:rule context="sp-sc:spcrawlrule_item/sp-sc:accountname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the accountname entity of a spcrawlrule_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_jobdefitemwebappuri">
                                                            <sch:rule context="sp-sc:spjobdefinition_item/sp-sc:webappuri">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the webappuri entity of a spjobdefinition_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_jobdefitemdisplayname">
                                                            <sch:rule context="sp-sc:spjobdefinition_item/sp-sc:displayname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the displayname entity of a spjobdefinition_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_jobdefitemisdisabled">
                                                            <sch:rule context="sp-sc:spjobdefinition_item/sp-sc:isdisabled">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the isdisabled entity of an spjobdefinition_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_jobdefitemretry">
                                                            <sch:rule context="sp-sc:spjobdefinition_item/sp-sc:retry">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the retry entity of an spjobdefinition_item should be 'boolean'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_jobdefitemtitle">
                                                            <sch:rule context="sp-sc:spjobdefinition_item/sp-sc:title">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the title entity of a spjobdefinition_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_bbitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:bestbet_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a bestbet_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_bbitembestbeturl">
                                                            <sch:rule context="sp-sc:bestbet_item/sp-sc:bestbeturl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the bestbeturl entity of a bestbet_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_bbitemtitle">
                                                            <sch:rule context="sp-sc:bestbet_item/sp-sc:title">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the title entity of a bestbet_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_bbitemdescription">
                                                            <sch:rule context="sp-sc:bestbet_item/sp-sc:description">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a bestbet_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policycollitemsitecollectionurl">
                                                            <sch:rule context="sp-sc:policycoll_item/sp-sc:sitecollectionurl">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sitecollectionurl entity of a policycoll_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policycollitemid">
                                                            <sch:rule context="sp-sc:policycoll_item/sp-sc:id">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the id entity of a policycoll_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policycollitemname">
                                                            <sch:rule context="sp-sc:policycoll_item/sp-sc:name">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a policycoll_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policycollitemdescription">
                                                            <sch:rule context="sp-sc:policycoll_item/sp-sc:description">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a policycoll_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policycollitemlongdescription">
                                                            <sch:rule context="sp-sc:infopolicy_item/sp-sc:longdescription">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the longdesc entity of a infopolicy_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticserviceitemfarmname">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:farmname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the farmname entity of a spdiagnosticsservice_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemdisplayname">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:displayname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the displayname entity of a spdiagnosticsservice_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemlogcutinterval">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:logcutinterval">
                                                                  <sch:assert test="not(@datatype) or @datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the logcutinterval entity of a spdiagnosticsservice_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemloglocation">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:loglocation">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the loglocation entity of a spdiagnosticsservice_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemlogstokeep">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:logstokeep">
                                                                  <sch:assert test="not(@datatype) or @datatype='integer'">item <sch:value-of select="../@id"/> - datatype attribute for the logstokeep entity of a spdiagnosticsservice_item should be 'integer'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemrequired">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:required">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the required entity of an spdiagnosticsservice_item should be 'boolean'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsserviceitemtypename">
                                                            <sch:rule context="sp-sc:spdiagnosticsservice_item/sp-sc:typename">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the typename entity of a spdiagnosticsservice_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticslevelitemfarmname">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:farmname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the farmname entity of a spdiagnosticslevel_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticslevelitemeventseverity">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:eventseverity">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the eventseverity entity of a spdiagnosticslevel_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticslevelitemhidden">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:hidden">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the hidden entity of an spdiagnosticslevel_item should be 'boolean'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsitemlevelid">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:levelid">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the levelid entity of a spdiagnosticslevel_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticsitemlevelname">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:levelname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the levelname entity of a spdiagnosticslevel_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_diagnosticslevelitemtraceseverity">
                                                            <sch:rule context="sp-sc:spdiagnosticslevel_item/sp-sc:traceseverity">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the traceseverity entity of a spdiagnosticslevel_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemfarmname">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:farmname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the farmname entity of a sppolicyfeature_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemconfigpage">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:configpage">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the configpage entity of a sppolicyfeature_item should be 'string'</sch:assert>   
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemdefaultcustomdata">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:defaultcustomdata">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the defaultcustomdata entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemdescription">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:description">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemglobalconfigpage">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:globalconfigpage">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the globalconfigpage entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemglobalcustomdata">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:globalcustomdata">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the globalcustomdata entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemgroup">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:group">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the group entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemname">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:name">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitempublisher">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:publisher">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the publisher entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyfeatureitemstate">
                                                            <sch:rule context="sp-sc:sppolicyfeature_item/sp-sc:state">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the state entity of a sppolicyfeature_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitemwebappuri">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:webappuri">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the webappuri entity of a sppolicy_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitemurlzone">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:urlzone">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the urlzone entity of a sppolicy_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitemdisplayname">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:displayname">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the displayname entity of a sppolicy_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitemissystemuser">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:issystemuser">
                                                                  <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the issystemuser entity of an sppolicy_item should be 'boolean'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitemusername">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:username">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the username entity of a sppolicy_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sp-sc_policyitempolicyroletype">
                                                            <sch:rule context="sp-sc:sppolicy_item/sp-sc:policyroletype">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the policyroletype entity of a sppolicy_item should be 'string'</sch:assert> 
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_isaitembits">
                                                  <sch:rule context="sol-sc:isainfo_item/sol-sc:bits">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the bits entity of an isainfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_isaitemkernel_isa">
                                                  <sch:rule context="sol-sc:isainfo_item/sol-sc:kernel_isa">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the kernel_isa entity of an isainfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_isaitemapplication_isa">
                                                  <sch:rule context="sol-sc:isainfo_item/sol-sc:application_isa">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the application_isa entity of an isainfo_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitempkginst">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:pkginst">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the pkginst entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitemname">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitemcategory">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:category">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the category entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitemversion">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitemvendor">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:vendor">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the vendor entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_packageitemdescription">
                                                  <sch:rule context="sol-sc:package_item/sol-sc:description">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the description entity of a package_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_patchitembase">
                                                  <sch:rule context="sol-sc:patch_item/sol-sc:base">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the base entity of a patch_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_patchitemversion">
                                                  <sch:rule context="sol-sc:patch_item/sol-sc:version">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a patch_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="sol-sc_fmriitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:fmri">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the fmri entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_srvnameitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:service_name">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_name entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_srvstateitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:service_state">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_state entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_protocolitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:protocol">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_srvexeitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:server_executable">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server_executable entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_srvargsitembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:server_arguements">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server_arguements entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="sol-sc_execasuseritembase">
                                                            <sch:rule context="sol-sc:smf_item/sol-sc:exec_as_user">
                                                                  <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exec_as_user entity of a smf_item should be 'string'</sch:assert>
                                                            </sch:rule>
                                                      </sch:pattern>
   <sch:pattern id="unix-sc_dnscacheitemdomainname">
                                                  <sch:rule context="unix-sc:dnscache_item/unix-sc:domain_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the domain_name entity of a dnscache_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_dnscacheitemttl">
                                                  <sch:rule context="unix-sc:dnscache_item/unix-sc:ttl">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the ttl entity of a dnscache_item should be 'int'.</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_dnscacheitemipaddress">
                                                  <sch:rule context="unix-sc:dnscache_item/unix-sc:ip_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ip_address entity of a dnscache_item should be 'string'.</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemfilepath">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitempath">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemfilename">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemtype">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemgroup_id">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:group_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the group_id entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemuser_id">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:user_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_id entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitema_time">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:a_time">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the a_time entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemc_time">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:c_time">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the c_time entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemm_time">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:m_time">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the m_time entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemsize">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:size">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the size entity of a file_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemsuid">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:suid">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the suid entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemsgid">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:sgid">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sgid entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemsticky">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:sticky">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sticky entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemuread">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:uread">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the uread entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemuwrite">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:uwrite">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the uwrite entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemuexec">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:uexec">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the uexec entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemgread">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:gread">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the gread entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemgwrite">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:gwrite">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the gwrite entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemgexec">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:gexec">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the gexec entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemoread">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:oread">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the oread entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemowrite">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:owrite">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the owrite entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemoexec">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:oexec">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the oexec entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_fileitemhasextendedacl">
                                                  <sch:rule context="unix-sc:file_item/unix-sc:has_extended_acl">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the has_extended_acl entity of a file_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemprotocol">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:protocol">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemservice_name">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:service_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_name entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemserver_program">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:server_program">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server_program entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemserver_arguments">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:server_arguments">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server_arguments entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemendpoint_type">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:endpoint_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the endpoint_type entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemexec_as_user">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:exec_as_user">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exec_as_user entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_inetditemwait_status">
                                                  <sch:rule context="unix-sc:inetd_item/unix-sc:wait_status">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the wait_status entity of an inetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitemname">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitemtype">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitemhardware_addr">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:hardware_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the hardware_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceiteminet_addr">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:inet_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the inet_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitembroadcast_addr">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:broadcast_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the broadcast_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitemnetmask">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:netmask">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the netmask entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_interfaceitemflag">
                                                  <sch:rule context="unix-sc:interface_item/unix-sc:flag">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the flag entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemusername">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:username">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the username entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditempassword">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:password">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the password entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemuser_id">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:user_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_id entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemgroup_id">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:group_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the group_id entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemgcos">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:gcos">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the gcos entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemhome_dir">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:home_dir">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the home_dir entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_passworditemlogin_shell">
                                                  <sch:rule context="unix-sc:password_item/unix-sc:login_shell">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the login_shell entity of a password_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemcommand">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:command">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the command entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemexec_time">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:exec_time">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exec_time entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitempid">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:pid">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pid entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemppid">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:ppid">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the ppid entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitempriority">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:priority">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the priority entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemscheduling_class">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:scheduling_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the scheduling_class entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemstart_time">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:start_time">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the start_time entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemtty">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:tty">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the tty entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_processitemuser_id">
                                                  <sch:rule context="unix-sc:process_item/unix-sc:user_id">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_id entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_rlitemservice_name">
                                                  <sch:rule context="unix-sc:runlevel_item/unix-sc:service_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_name entity of a runlevel_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_rlitemrunlevel">
                                                  <sch:rule context="unix-sc:runlevel_item/unix-sc:runlevel">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the runlevel entity of a runlevel_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_rlitemstart">
                                                  <sch:rule context="unix-sc:runlevel_item/unix-sc:start">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the start entity of a runlevel_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_rlitemkill">
                                                  <sch:rule context="unix-sc:runlevel_item/unix-sc:kill">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the kill entity of a runlevel_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemfilepath">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a sccs_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitempath">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemfilename">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemmodule_name">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:module_name">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the module_name entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemmodule_type">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:module_type">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the module_type entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemrelease">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:release">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the release entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemlevel">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:level">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the level entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitembranch">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:branch">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the branch entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemsequence">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:sequence">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sequence entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_sccsitemwhat_string">
                                                  <sch:rule context="unix-sc:sccs_item/unix-sc:what_string">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the what_string entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemusername">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:username">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the username entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitempassword">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:password">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the password entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemchg_lst">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:chg_lst">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the chg_lst entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemchg_allow">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:chg_allow">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the chg_allow entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemchg_req">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:chg_req">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the chg_req entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemexp_warn">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:exp_warn">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exp_warn entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemexp_inact">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:exp_inact">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exp_inact entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemexp_date">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:exp_date">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the exp_date entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_shadowitemflag">
                                                  <sch:rule context="unix-sc:shadow_item/unix-sc:flag">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the flag entity of a shadow_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemmachine_class">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:machine_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the machine_class entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemnode_name">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:node_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the node_name entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemos_name">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:os_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the os_name entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemos_release">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:os_release">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the os_release entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemos_version">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:os_version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the os_version entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_unameitemprocessor_type">
                                                  <sch:rule context="unix-sc:uname_item/unix-sc:processor_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the processor_type entity of a uname_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemprotocol">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:protocol">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemservice_name">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:service_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_name entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemflags">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:flags">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the flags entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemnoaccess">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:no_access">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the no_access entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemonlyfrom">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:only_from">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the only_from entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemport">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:port">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the port entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemserver">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:server">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemserver_arguments">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:server_arguments">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the server_arguments entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemsockettype">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:socket_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the socket_type entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemtype">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemuser">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:user">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user entity of an xinetd_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemwait">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:wait">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the wait entity of an xinetd_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="unix-sc_xinetditemdisabled">
                                                  <sch:rule context="unix-sc:xinetd_item/unix-sc:disabled">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the disabled entity of an xinetd_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecurity_principle">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:security_principle">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the security_principle entity of an accesstoken_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseassignprimarytokenprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seassignprimarytokenprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seassignprimarytokenprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseauditprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seauditprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seauditprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsebackupprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sebackupprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sebackupprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsechangenotifyprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sechangenotifyprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sechangenotifyprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecreateglobalprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:secreateglobalprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secreateglobalprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecreatepagefileprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:secreatepagefileprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secreatepagefileprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecreatepermanentprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:secreatepermanentprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secreatepermanentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecreatesymboliclinkprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:secreatesymboliclinkprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secreatesymboliclinkprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsecreatetokenprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:secreatetokenprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secreatetokenprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedebugprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedebugprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedebugprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseenabledelegationprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seenabledelegationprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seenabledelegationprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseimpersonateprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seimpersonateprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seimpersonateprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseincreasebasepriorityprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seincreasebasepriorityprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seincreasebasepriorityprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseincreasequotaprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seincreasequotaprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seincreasequotaprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseincreaseworkingsetprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seincreaseworkingsetprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seincreaseworkingsetprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseloaddriverprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seloaddriverprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seloaddriverprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemselockmemoryprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:selockmemoryprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the selockmemoryprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsemachineaccountprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:semachineaccountprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the semachineaccountprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsemanagevolumeprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:semanagevolumeprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the semanagevolumeprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseprofilesingleprocessprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seprofilesingleprocessprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seprofilesingleprocessprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemserelabelprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:serelabelprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the serelabelprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseremoteshutdownprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seremoteshutdownprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seremoteshutdownprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemserestoreprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:serestoreprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the serestoreprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsesecurityprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sesecurityprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sesecurityprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseshutdownprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seshutdownprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seshutdownprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsesyncagentprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sesyncagentprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sesyncagentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsesystemenvironmentprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemenvironmentprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sesystemenvironmentprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsesystemprofileprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemprofileprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sesystemprofileprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsesystemtimeprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sesystemtimeprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sesystemtimeprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsetakeownershipprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:setakeownershipprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the setakeownershipprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsetcbprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:setcbprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the setcbprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsetimezoneprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:setimezoneprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the setimezoneprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseundockprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seundockprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seundockprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseunsolicitedinputprivilege">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seunsolicitedinputprivilege">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seunsolicitedinputprivilege entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsebatchlogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sebatchlogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sebatchlogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseinteractivelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seinteractivelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsenetworklogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:senetworklogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the senetworklogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseremoteinteractivelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seremoteinteractivelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seremoteinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemseservicelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:seservicelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the seservicelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedenybatchLogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedenybatchLogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedenybatchLogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedenyinteractivelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyinteractivelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedenyinteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedenynetworklogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedenynetworklogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedenynetworklogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedenyremoteInteractivelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyremoteInteractivelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedenyremoteInteractivelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_atitemsedenyservicelogonright">
                                                  <sch:rule context="win-sc:accesstoken_item/win-sc:sedenyservicelogonright">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the sedenyservicelogonright entity of an accesstoken_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory_item_dep">
                         <sch:rule context="win-sc:activedirectory_item">
                              <sch:report test="true()">DEPRECATED ITEM: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="win-sc_aditemnaming_context">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:naming_context">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the naming_context entity of an activedirectory_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aditemrelative_dn">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:relative_dn">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an activedirectory_item should be 'string'</sch:assert>
                                                       <sch:assert test="not(@xsi:nil='true') or ../win-sc:attribute/@xsi:nil='true'">
            <sch:value-of select="../@id"/> - attribute entity must be nil when relative_dn is nil</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aditemattribute">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:attribute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an activedirectory_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aditemobject_class">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:object_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an activedirectory_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aditemadstype">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:adstype">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the adstype entity of an activedirectory_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aditemvalue">
                                                  <sch:rule context="win-sc:activedirectory_item/win-sc:value">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_naming_context">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:naming_context">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the naming_context entity of an activedirectory57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_relative_dn">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:relative_dn">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the relative_dn entity of an activedirectory57_item should be 'string'</sch:assert>
                                                       <sch:assert test="not(@xsi:nil='true') or ../win-sc:attribute/@xsi:nil='true'">
            <sch:value-of select="../@id"/> - attribute entity must be nil when relative_dn is nil</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_attribute">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:attribute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the attribute entity of an activedirectory57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_object_class">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:object_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the object_class entity of an activedirectory57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_adstype">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:adstype">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the adstype entity of an activedirectory57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_activedirectory57_item_value">
                                                  <sch:rule context="win-sc:activedirectory57_item/win-sc:value">
                                                       <sch:assert test="@datatype='record'">item <sch:value-of select="../@id"/> - datatype attribute for the result entity of a activedirectory57_item must be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemaccount_logon">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:account_logon">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the account_logon entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemaccount_management">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:account_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the account_management entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemdetailed_tracking">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:detailed_tracking">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the detailed_tracking entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemdirectory_service_access">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:directory_service_access">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the directory_service_access entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemlogon">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:logon">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the logon entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemobject_access">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:object_access">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the object_access entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitempolicy_change">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the policy_change entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemprivilege_use">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:privilege_use">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the privilege_use entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepitemsystem">
                                                  <sch:rule context="win-sc:auditeventpolicy_item/win-sc:system">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the system entity of an auditeventpolicy_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemcredentialvalidation">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:credential_validation">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the credential_validation entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemkerberosauthenticationservice">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:kerberos_authentication_service">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the kerberos_authentication_service entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemkerberosserviceticketoperations">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:kerberos_service_ticket_operations">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the kerberos_service_ticket_operations entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemkerberosticketevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:kerberos_ticket_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the kerberos_ticket_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotheraccountlogonevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_account_logon_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_account_logon_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemapplicationgroupmanagement">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:application_group_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the application_group_management entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemcomputeraccountmanagement">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:computer_account_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the computer_account_management entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdistributiongroupmanagement">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:distribution_group_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the distribution_group_management entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotheraccountmanagementevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_account_management_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_account_management_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsecuritygroupmanagement">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:security_group_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the security_group_management entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemuseraccountmanagement">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:user_account_management">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_account_management entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdpapiactivity">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:dpapi_activity">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the dpapi_activity entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemprocesscreation">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:process_creation">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the process_creation entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemprocesstermination">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:process_termination">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the process_termination entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemrpcevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:rpc_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the rpc_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdirectoryserviceaccess">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:directory_service_access">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the directory_service_access entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdirectoryservicechanges">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:xxx">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the directory_service_changes entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdirectoryservicereplication">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:directory_service_replication">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the directory_service_replication entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdetaileddirectoryservicereplication">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:detailed_directory_service_replication">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the detailed_directory_service_replication entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemaccountlockout">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:account_lockout">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the account_lockout entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemipsecextendedmode">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:ipsec_extended_mode">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ipsec_extended_mode entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemipsecmainmode">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:ipsec_main_mode">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ipsec_main_mode entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemipsecquickmode">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:ipsec_quick_mode">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ipsec_quick_mode entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemlogoff">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:logoff">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the logoff entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemlogon">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:logon">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the logon entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemnetworkpolicyserver">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:network_policy_server">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the network_policy_server entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotherlogonlogoffevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_logon_logoff_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_logon_logoff_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemspeciallogon">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:special_logon">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the special_logon entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemapplicationgenerated">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:application_generated">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the application_generated entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemcertificationservices">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:certification_services">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the certification_services entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemdetailedfileshare">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:detailed_file_share">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the detailed_file_share entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemfileshare">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:file_share">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_share entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemfilesystem">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:file_system">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_system entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemfilteringplatformconnection">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:filtering_platform_connection">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filtering_platform_connection entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemfilteringplatformpacketdrop">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:filtering_platform_packet_drop">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filtering_platform_packet_drop entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemhandlemanipulation">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:handle_manipulation">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the handle_manipulation entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemkernelobject">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:kernel_object">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the kernel_object entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotherobjectaccessevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_object_access_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_object_access_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemregistry">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:registry">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the registry entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsam">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:sam">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sam entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemauditpolicychange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:audit_policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the audit_policy_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemauthenticationpolicychange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:authentication_policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the authentication_policy_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemauthorizationpolicychange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:authorization_policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the authorization_policy_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemfilteringplatformpolicychange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:filtering_platform_policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filtering_platform_policy_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemmpssvcrulelevelpolicychange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:mpssvc_rule_level_policy_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the mpssvc_rule_level_policy_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotherpolicychangeevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_policy_change_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_policy_change_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemnonsensitiveprivilegeuse">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:non_sensitive_privilege_use">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the non_sensitive_privilege_use entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemotherprivilegeuseevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_privilege_use_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_privilege_use_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsensitiveprivilegeuse">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:sensitive_privilege_use">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the sensitive_privilege_use entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemipsecdriver">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:ipsec_driver">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ipsec_driver entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemothersystemevents">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:other_system_events">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the other_system_events entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsecuritystatechange">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:security_state_change">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the security_state_change entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsecuritysystemextension">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:security_system_extension">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the security_system_extension entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_aepsitemsystemintegrity">
                                                  <sch:rule context="win-sc:auditeventpolicysubcategories_item/win-sc:system_integrity">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the system_integrity entity of an auditeventpolicysubcategories_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_dnscacheitemdomainname">
                                                  <sch:rule context="win-sc:dnscache_item/win-sc:domain_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the domain_name entity of a dnscache_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_dnscacheitemttl">
                                                  <sch:rule context="win-sc:dnscache_item/win-sc:ttl">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the ttl entity of a dnscache_item should be 'int'.</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_dnscacheitemipaddress">
                                                  <sch:rule context="win-sc:dnscache_item/win-sc:ip_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ip_address entity of a dnscache_item should be 'string'.</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemfilepath">
                                                  <sch:rule context="win-sc:file_item/win-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitempath">
                                                  <sch:rule context="win-sc:file_item/win-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemfilename">
                                                  <sch:rule context="win-sc:file_item/win-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemowner">
                                                  <sch:rule context="win-sc:file_item/win-sc:owner">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the owner entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemsize">
                                                  <sch:rule context="win-sc:file_item/win-sc:size">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the size entity of a file_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitema_time">
                                                  <sch:rule context="win-sc:file_item/win-sc:a_time">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the a_time entity of a file_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemc_time">
                                                  <sch:rule context="win-sc:file_item/win-sc:c_time">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the c_time entity of a file_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemm_time">
                                                  <sch:rule context="win-sc:file_item/win-sc:m_time">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the m_time entity of a file_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemms_checksum">
                                                  <sch:rule context="win-sc:file_item/win-sc:ms_checksum">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the ms_checksum entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemversion">
                                                  <sch:rule context="win-sc:file_item/win-sc:version">
                                                       <sch:assert test="@datatype='version'">item <sch:value-of select="../@id"/> - datatype attribute for the version entity of a file_item should be 'version'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemtype">
                                                  <sch:rule context="win-sc:file_item/win-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemdevelopment_class">
                                                  <sch:rule context="win-sc:file_item/win-sc:development_class">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the development_class entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemcompany">
                                                  <sch:rule context="win-sc:file_item/win-sc:company">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the company entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileiteminternalname">
                                                  <sch:rule context="win-sc:file_item/win-sc:internal_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the internal_name entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemlanguage">
                                                  <sch:rule context="win-sc:file_item/win-sc:language">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the language entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemoriginalfilename">
                                                  <sch:rule context="win-sc:file_item/win-sc:original_filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the original_filename entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemproductname">
                                                  <sch:rule context="win-sc:file_item/win-sc:product_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the product_name entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileitemproductversion">
                                                  <sch:rule context="win-sc:file_item/win-sc:product_version">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the product_version entity of a file_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfilepath">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititempath">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfilename">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemtrustee_sid">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemtrustee_name">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:trustee_name">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemstandard_delete">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_delete">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemstandard_read_control">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_read_control">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemstandard_write_dac">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_write_dac">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemstandard_write_owner">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_write_owner">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemstandard_synchronize">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:standard_synchronize">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for thestandard_synchronize entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemaccess_system_security">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:access_system_security">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the access_system_security entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemgeneric_read">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_read">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemgeneric_write">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_write">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemgeneric_execute">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_execute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemgeneric_all">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:generic_all">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_all entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_read_data">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_data">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_write_data">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_data">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_append_data">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_append_data">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_append_data entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_read_ea">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_ea">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_ea entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_write_ea">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_ea">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_ea entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_execute">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_execute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_execute entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_delete_child">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_delete_child">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_delete_child entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_read_attributes">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_read_attributes">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_attributes entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_fileaudititemfile_write_attributes">
                                                  <sch:rule context="win-sc:fileauditedpermissions_item/win-sc:file_write_attributes">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_attributes entity of a fileauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ferititemfilepath">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:filepath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filepath entity of a fileeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritempath">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the path entity of a fileeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfilename">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:filename">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the filename entity of a fileeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemtrustee_sid">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a fileeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemtrustee_name">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:trustee_name">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a fileeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemstandard_delete">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_delete">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemstandard_read_control">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_read_control">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemstandard_write_dac">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_write_dac">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemstandard_write_owner">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_write_owner">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemstandard_synchronize">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:standard_synchronize">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemaccess_system_security">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:access_system_security">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_system_security entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemgeneric_read">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_read">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemgeneric_write">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_write">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemgeneric_execute">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_execute">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemgeneric_all">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:generic_all">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_all entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_read_data">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_data">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_write_data">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_data">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_append_data">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_append_data">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_append_data entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_read_ea">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_ea">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_ea entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_write_ea">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_ea">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_ea entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_execute">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_execute">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_execute entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_delete_child">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_delete_child">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_delete_child entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_read_attributes">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_read_attributes">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_attributes entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_feritemfile_write_attributes">
                                                  <sch:rule context="win-sc:fileeffectiverights_item/win-sc:file_write_attributes">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_write_attributes entity of a fileeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_groupitemgroup">
                                                  <sch:rule context="win-sc:group_item/win-sc:group">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the group entity of a group_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_groupitemuser">
                                                  <sch:rule context="win-sc:group_item/win-sc:user">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user entity of a group_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_groupitemsubgroup">
                                                  <sch:rule context="win-sc:group_item/win-sc:subgroup">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the subgroup entity of a group_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_groupsiditemgroup">
                                                           <sch:rule context="win-sc:group_sid_item/win-sc:group_sid">
                                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the group_sid entity of a group_sid_item should be 'string'</sch:assert>
                                                           </sch:rule>
                                                     </sch:pattern>
   <sch:pattern id="win-sc_groupsiditemuser">
                                                           <sch:rule context="win-sc:group_sid_item/win-sc:user_sid">
                                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_sid entity of a group_sid_item should be 'string'</sch:assert>
                                                           </sch:rule>
                                                     </sch:pattern>
   <sch:pattern id="win-sc_groupsiditemsubgroup">
                                                       <sch:rule context="win-sc:group_sid_item/win-sc:subgroup_sid">
                                                            <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the subgroup_sid entity of a group_sid_item should be 'string'</sch:assert>
                                                        </sch:rule>
                                                  </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemname">
                                                  <sch:rule context="win-sc:interface_item/win-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemindex">
                                                  <sch:rule context="win-sc:interface_item/win-sc:index">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the index entity of an interface_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemtype">
                                                  <sch:rule context="win-sc:interface_item/win-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemhardware_addr">
                                                  <sch:rule context="win-sc:interface_item/win-sc:hardware_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the hardware_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceiteminet_addr">
                                                  <sch:rule context="win-sc:interface_item/win-sc:inet_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the inet_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitembroadcast_addr">
                                                  <sch:rule context="win-sc:interface_item/win-sc:broadcast_addr">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the broadcast_addr entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemnetmask">
                                                  <sch:rule context="win-sc:interface_item/win-sc:netmask">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the netmask entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wininterfaceitemaddr_type">
                                                  <sch:rule context="win-sc:interface_item/win-sc:addr_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the addr_type entity of an interface_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_lpitemforce_logoff">
                                                  <sch:rule context="win-sc:lockoutpolicy_item/win-sc:force_logoff">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the force_logoff entity of a lockoutpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_lpitemlockout_duration">
                                                  <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_duration">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the lockout_duration entity of a lockoutpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_lpitemlockout_observation_window">
                                                  <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_observation_window">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the lockout_observation_window entity of a lockoutpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_lpitemlockout_threshold">
                                                  <sch:rule context="win-sc:lockoutpolicy_item/win-sc:lockout_threshold">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the lockout_threshold entity of a lockoutpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemkey">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key entity of a metabase_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemid">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:id">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the id entity of a metabase_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemname">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a metabase_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemuser_type">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:user_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_type entity of a metabase_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemdata_type">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:data_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the data_type entity of a metabase_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_metabaseitemdata">
                                                  <sch:rule context="win-sc:metabase_item/win-sc:data">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitemmax_passwd_age">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:max_passwd_age">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the max_passwd_age entity of a passwordpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitemmin_passwd_age">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:min_passwd_age">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the min_passwd_age entity of a passwordpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitemmin_passwd_len">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:min_passwd_len">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the min_passwd_len entity of a passwordpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitempassword_hist_len">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:password_hist_len">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the password_hist_len entity of a passwordpolicy_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitempassword_complexity">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:password_complexity">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the password_complexity entity of a passwordpolicy_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_ppitemreversible_encryption">
                                                  <sch:rule context="win-sc:passwordpolicy_item/win-sc:reversible_encryption">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the reversible_encryption entity of a passwordpolicy_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_winportitemlocal_address">
                                                  <sch:rule context="win-sc:port_item/win-sc:local_address">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_address entity of a port_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_winportitemlocal_port">
                                                  <sch:rule context="win-sc:port_item/win-sc:local_port">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the local_port entity of a port_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_winportitemprotocol">
                                                  <sch:rule context="win-sc:port_item/win-sc:protocol">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the protocol entity of a port_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_winportitempid">
                                                  <sch:rule context="win-sc:port_item/win-sc:pid">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pid entity of a port_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemprinter_name">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:printer_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the printer_name entity of a printereffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemtrustee_sid">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a printereffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemstandard_delete">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:standard_delete">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemstandard_read_control">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:standard_read_control">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemstandard_write_dac">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:standard_write_dac">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemstandard_write_owner">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:standard_write_owner">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemstandard_synchronize">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:standard_synchronize">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemaccess_system_security">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:access_system_security">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_system_security entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemgeneric_read">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:generic_read">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemgeneric_write">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:generic_write">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemgeneric_execute">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:generic_execute">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemgeneric_all">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:generic_all">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_all entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemprinter_access_administer">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:printer_access_administer">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the printer_access_administer entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemprinter_access_use">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:printer_access_use">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the printer_access_use entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemjob_access_administer">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:job_access_administer">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the job_access_administer entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_peritemjob_access_read">
                                                  <sch:rule context="win-sc:printereffectiverights_item/win-sc:job_access_read">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the job_access_read entity of a printereffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitemcommand_line">
                                                  <sch:rule context="win-sc:process_item/win-sc:command_line">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the command_line entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitempid">
                                                  <sch:rule context="win-sc:process_item/win-sc:pid">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the pid entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitemppid">
                                                  <sch:rule context="win-sc:process_item/win-sc:ppid">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the ppid entity of a process_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitempriority">
                                                  <sch:rule context="win-sc:process_item/win-sc:priority">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the priority entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitemimage_path">
                                                  <sch:rule context="win-sc:process_item/win-sc:image_path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the image_path entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_processitemcurrent_dir">
                                                  <sch:rule context="win-sc:process_item/win-sc:current_dir">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the current_dir entity of a process_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_regitemhive">
                                                  <sch:rule context="win-sc:registry_item/win-sc:hive">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the hive entity of a registry_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_regitemkey">
                                                  <sch:rule context="win-sc:registry_item/win-sc:key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key entity of a registry_item should be 'string'</sch:assert>
                                                       <sch:assert test="not(@xsi:nil='true') or ../win-sc:name/@xsi:nil='true'">
            <sch:value-of select="../@id"/> - name entity must be nil when key is nil</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_regitemname">
                                                  <sch:rule context="win-sc:registry_item/win-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a registry_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_regitemtype">
                                                  <sch:rule context="win-sc:registry_item/win-sc:type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the type entity of a registry_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_regitemresult">
                                                  <sch:rule context="win-sc:registry_item/win-sc:value">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemhive">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:hive">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the hive entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemtrustee_sid">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemtrustee_name">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:trustee_name">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemstandard_delete">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_delete">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemstandard_read_control">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_read_control">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemstandard_write_dac">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_write_dac">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemstandard_write_owner">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_write_owner">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemstandard_synchronize">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:standard_synchronize">
                                                       <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemaccess_system_security">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:access_system_security">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the access_system_security entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemgeneric_read">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_read">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemgeneric_write">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_write">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemgeneric_execute">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_execute">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemgeneric_all">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:generic_all">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_all entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_query_value">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_query_value">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_query_value entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_set_value">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_set_value">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_set_value entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_create_sub_key">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_create_sub_key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_create_sub_key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_enumerate_sub_keys">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_enumerate_sub_keys">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_notify">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_notify">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_notify entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_create_link">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_create_link">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_create_link entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_wow64_64key">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_64key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_64key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_wow64_32key">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_32key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_32key entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_rapitemkey_wow64_res">
                                                  <sch:rule context="win-sc:regkeyauditedpermissions_item/win-sc:key_wow64_res">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_res entity of a regkeyauditedpermissions_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemhive">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:hive">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the hive entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the key entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemtrustee_sid">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemtrustee_name">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:trustee_name">
                                                        <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                        <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a regkeyeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemstandard_delete">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_delete">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemstandard_read_control">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_read_control">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemstandard_write_dac">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_write_dac">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemstandard_write_owner">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_write_owner">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemstandard_synchronize">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:standard_synchronize">
                                                       <sch:report test="true()">DEPRECATED ELEMENT: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the standard_synchronize entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemaccess_system_security">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:access_system_security">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_system_security entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemgeneric_read">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_read">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemgeneric_write">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_write">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemgeneric_execute">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_execute">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemgeneric_all">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:generic_all">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the generic_all entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_query_value">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_query_value">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_query_value entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_set_value">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_set_value">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_set_value entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_create_sub_key">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_create_sub_key">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_create_sub_key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_enumerate_sub_keys">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_enumerate_sub_keys">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_enumerate_sub_keys entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_notify">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_notify">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_notify entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_create_link">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_create_link">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_create_link entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_wow64_64key">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_64key">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_64key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_wow64_32key">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_32key">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_32key entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_reritemkey_wow64_res">
                                                  <sch:rule context="win-sc:regkeyeffectiverights_item/win-sc:key_wow64_res">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the key_wow64_res entity of a regkeyeffectiverights_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_name">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the service_name entity of a serviceeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemtrustee_sid">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a serviceeffectiverights_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemstandard_delete">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:standard_delete">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the standard_delete entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemstandard_read_control">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:standard_read_control">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the standard_read_control entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemstandard_write_dac">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:standard_write_dac">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the standard_write_dac entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemstandard_write_owner">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:standard_write_owner">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the standard_write_owner entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemgeneric_read">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:generic_read">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the generic_read entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemgeneric_write">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:generic_write">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the generic_write entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemgeneric_execute">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:generic_execute">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the generic_execute entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_query_conf">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_query_conf">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_query_conf entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_change_conf">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_change_conf">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_change_conf entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_query_stat">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_query_stat">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_query_stat entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_enum_dependents">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_enum_dependents">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_enum_dependents entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_start">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_start">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_start entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_stop">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_stop">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_stop entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_pause">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_pause">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_pause entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_interrogate">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_interrogate">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_interrogate entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_svceitemservice_user_defined">
                                                  <sch:rule context="win-sc:serviceeffectiverights_item/win-sc:service_user_defined">
                                                       <sch:assert test="@datatype='boolean'">
            <sch:value-of select="../@id"/> - datatype attribute for the service_user_defined entity of a serviceeffectiverights_state should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemnetname">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:netname">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the netname entity of a sharedresource_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemshared_type">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:shared_type">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the shared_type entity of a sharedresource_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemmax_uses">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:max_uses">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the max_uses entity of a sharedresource_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemcurrent_uses">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:current_uses">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the current_uses entity of a sharedresource_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemlocal_path">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:local_path">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the local_path entity of a sharedresource_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_read_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_read_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_read_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_write_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_write_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_write_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_create_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_create_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_create_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_exec_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_exec_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_exec_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_delete_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_delete_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_delete_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_atrib_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_atrib_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_atrib_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_perm_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_perm_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_perm_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sritemaccess_all_permission">
                                                  <sch:rule context="win-sc:sharedresource_item/win-sc:access_all_permission">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the access_all_permission entity of a sharedresource_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_siditemtrustee_name">
                                                  <sch:rule context="win-sc:sid_item/win-sc:trustee_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_siditemtrustee_sid">
                                                  <sch:rule context="win-sc:sid_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_siditemtrustee_domain">
                                                  <sch:rule context="win-sc:sid_item/win-sc:trustee_domain">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sidsiditemtrustee_sid">
                                                  <sch:rule context="win-sc:sid_sid_item/win-sc:trustee_sid">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_sid entity of a sid_sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sidsiditemtrustee_name">
                                                  <sch:rule context="win-sc:sid_sid_item/win-sc:trustee_name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_name entity of a sid_sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_sidsiditemtrustee_domain">
                                                  <sch:rule context="win-sc:sid_sid_item/win-sc:trustee_domain">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the trustee_domain entity of a sid_sid_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemadminapprovalmode">
                                                  <sch:rule context="win-sc:uac_item/win-sc:admin_approval_mode">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the admin_approval_mode entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemelevationpromptadmin">
                                                  <sch:rule context="win-sc:uac_item/win-sc:elevation_prompt_admin">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the elevation_prompt_admin entity of a uac_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemelevationpromptstandard">
                                                  <sch:rule context="win-sc:uac_item/win-sc:elevation_prompt_standard">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the elevation_prompt_standard entity of a uac_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemdetectinstallations">
                                                  <sch:rule context="win-sc:uac_item/win-sc:detect_installations">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the detect_installations entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemelevatesignedexecutables">
                                                  <sch:rule context="win-sc:uac_item/win-sc:elevate_signed_executables">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the elevate_signed_executables entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemelevateuiaccess">
                                                  <sch:rule context="win-sc:uac_item/win-sc:elevate_uiaccess">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the elevate_uiaccess entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemrunadminsaam">
                                                  <sch:rule context="win-sc:uac_item/win-sc:run_admins_aam">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the run_admins_aam entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemsecuredesktop">
                                                  <sch:rule context="win-sc:uac_item/win-sc:secure_desktop">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the secure_desktop entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_uacitemvirtualizewritefailures">
                                                  <sch:rule context="win-sc:uac_item/win-sc:virtualize_write_failures">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the virtualize_write_failures entity of a uac_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_useritemuser">
                                                  <sch:rule context="win-sc:user_item/win-sc:user">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user entity of a user_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_useritemenabled">
                                                  <sch:rule context="win-sc:user_item/win-sc:enabled">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the enabled entity of a user_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_useritemgroup">
                                                  <sch:rule context="win-sc:user_item/win-sc:group">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for a group entity of a user_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_usersiditemuser">
                                                           <sch:rule context="win-sc:user_sid_item/win-sc:user_sid">
                                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the user_sid entity of a user_sid_item should be 'string'</sch:assert>
                                                           </sch:rule>
                                                     </sch:pattern>
   <sch:pattern id="win-sc_usersiditemenabled">
                                                           <sch:rule context="win-sc:user_sid_item/win-sc:enabled">
                                                                 <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the enabled entity of a user_sid_item should be 'boolean'</sch:assert>
                                                           </sch:rule>
                                                     </sch:pattern>
   <sch:pattern id="win-sc_usersiditemgroup">
                                                           <sch:rule context="win-sc:user_sid_item/win-sc:group_sid">
                                                                 <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for a group_sid entity of a user_sid_item should be 'string'</sch:assert>
                                                           </sch:rule>
                                                     </sch:pattern>
   <sch:pattern id="win-sc_volitemrootpath">
                                                  <sch:rule context="win-sc:volume_item/win-sc:rootpath">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the rootpath entity of a volume_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_system">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_system">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the file_system entity of a volume_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemname">
                                                  <sch:rule context="win-sc:volume_item/win-sc:name">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the name entity of a volume_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemvolume_max_component_length">
                                                  <sch:rule context="win-sc:volume_item/win-sc:volume_max_component_length">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the volume_max_component_length entity of a volume_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemserial_number">
                                                  <sch:rule context="win-sc:volume_item/win-sc:serial_number">
                                                       <sch:assert test="@datatype='int'">item <sch:value-of select="../@id"/> - datatype attribute for the serial_number entity of a volume_item should be 'int'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_case_sensitive_search">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_case_sensitive_search">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_case_sensitive_search entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_case_preserved_names">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_case_preserved_names">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_case_preserved_names entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_unicode_on_disk">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_unicode_on_disk">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_unicode_on_disk entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_persistent_acls">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_persistent_acls">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_persistent_acls entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_file_compression">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_file_compression">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_file_compression entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_volume_quotas">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_volume_quotas">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_volume_quotas entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_supports_sparse_files">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_supports_sparse_files">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_supports_sparse_files entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_supports_reparse_points">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_supports_reparse_points">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_supports_reparse_points entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_supports_remote_storage">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_supports_remote_storage">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_supports_remote_storage entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_volume_is_compressed">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_volume_is_compressed">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_volume_is_compressed entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_supports_object_ids">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_supports_object_ids">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_supports_object_ids entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_supports_encryption">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_supports_encryption">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_supports_encryption entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_named_streams">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_named_streams">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_named_streams entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_volitemfile_read_only_volume">
                                                  <sch:rule context="win-sc:volume_item/win-sc:file_read_only_volume">
                                                       <sch:assert test="@datatype='boolean'">item <sch:value-of select="../@id"/> - datatype attribute for the file_read_only_volume entity of a volume_item should be 'boolean'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmi_item_dep">
                         <sch:rule context="win-sc:wmi_item">
                              <sch:report test="true()">DEPRECATED ITEM: <sch:value-of select="name()"/> ID: <sch:value-of select="@id"/>
         </sch:report>
                         </sch:rule>
                    </sch:pattern>
   <sch:pattern id="win-sc_wmiitemnamespace">
                                                  <sch:rule context="win-sc:wmi_item/win-sc:namespace">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the namespace entity of a wmi_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmiitemwql">
                                                  <sch:rule context="win-sc:wmi_item/win-sc:wql">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the wql entity of a wmi_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmiitemresult">
                                                  <sch:rule context="win-sc:wmi_item/win-sc:value">
                                                       <sch:assert test="not(@datatype='record')">
            <sch:value-of select="../@id"/> - datatype attribute for the <sch:value-of select="name()"/> entity of an <sch:value-of select="name(..)"/> should not be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmi57itemnamespace">
                                                  <sch:rule context="win-sc:wmi57_item/win-sc:namespace">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the namespace entity of a wmi57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmi57itemwql">
                                                  <sch:rule context="win-sc:wmi57_item/win-sc:wql">
                                                       <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the wql entity of a wmi57_item should be 'string'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wmi57itemresult">
                                                  <sch:rule context="win-sc:wmi57_item/win-sc:result">
                                                       <sch:assert test="@datatype='record'">item <sch:value-of select="../@id"/> - datatype attribute for the result entity of a wmi57_item must be 'record'</sch:assert>
                                                  </sch:rule>
                                             </sch:pattern>
   <sch:pattern id="win-sc_wuaupdatesearcheritemsearchcriteria">
                                         <sch:rule context="win-sc:wuaupdatesearcher_item/win-sc:search_criteria">
                                             <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the search_criteria entity of a wuaupdatesearcher_item should be 'string'</sch:assert>
                                         </sch:rule>
                                     </sch:pattern>
   <sch:pattern id="win-sc_wuaupdatesearcheritemresult">
                                         <sch:rule context="win-sc:wuaupdatesearcher_item/win-sc:update_id">
                                             <sch:assert test="not(@datatype) or @datatype='string'">item <sch:value-of select="../@id"/> - datatype attribute for the update_id entity of a wuaupdatesearcher_item should be 'string'</sch:assert>
                                         </sch:rule>
                                     </sch:pattern>
   <sch:diagnostics/>
</sch:schema>