<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
    <sch:title>schematron validation for an OVAL Results file</sch:title>
    <sch:ns prefix="xsi" uri="http://www.w3.org/2001/XMLSchema-instance"/>
    <sch:ns prefix="oval" uri="http://oval.mitre.org/XMLSchema/oval-common-5"/>
    <sch:ns prefix="oval-res" uri="http://oval.mitre.org/XMLSchema/oval-results-5"/>
    <sch:pattern id="directives">
        <sch:rule context="oval-res:system[oval-res:tests]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">the tests element should not be included unless full results are to be provided (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:system[not(oval-res:tests)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">the tests element should be included when full results are specified (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:system[oval-sc:oval_system_characteristics]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full' or /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">system characteristics should not be included unless full results are to be provided (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:system[not(oval-sc:oval_system_characteristics)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin' and /oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">system characteristics should be included when full results are specified (see directives)</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="directives">
        <sch:rule context="oval-res:definition[@result='true' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='true' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should not be included (see directives) xx</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_true/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='false' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of FALSE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='false' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of FALSE should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_false/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of FALSE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='unknown' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='unknown' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of UNKNOWN should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_unknown/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='error' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='error' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of ERROR should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_error/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='not evaluated' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='not evaluated' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of NOT EVALUATED should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_evaluated/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='not applicable' and oval-res:criteria]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='full'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain THIN content (see directives)</sch:assert>
        </sch:rule>
        <sch:rule context="oval-res:definition[@result='not applicable' and not(oval-res:criteria)]">
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@reported='true'">
                <value-of select="@definition_id"/> - definitions with a result of NOT APPLICABLE should not be included (see directives)</sch:assert>
            <sch:assert test="/oval-res:oval_results/oval-res:directives/oval-res:definition_not_applicable/@content='thin'">
                <value-of select="@definition_id"/> - definitions with a result of TRUE should contain FULL content (see directives)</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="testids">
        <sch:rule context="oval-res:test">
            <sch:assert test="@test_id = ../../oval-res:definitions//oval-res:criterion/@test_ref">
                <value-of select="@test_id"/> - the specific test is not used in any definition's criteria</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern name="empty_def_doc" id="empty_def_doc">
        <sch:rule context="oval-def:oval_definitions">
            <sch:assert test="oval-def:definitions or oval-def:tests or oval-def:objects or oval-def:states or oval-def:variables">A valid OVAL Definition document must contain at least one definitions, tests, objects, states, or variables element. The optional definitions, tests, objects, states, and variables sections define the specific characteristics that should be evaluated on a system to determine the truth values of the OVAL Definition Document. To be valid though, at least one definitions, tests, objects, states, or variables element must be present.</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="value">
        <sch:rule context="oval-def:constant_variable/oval-def:value">
            <sch:assert test=".!=''">The value element of the constant_variable <value-of select="../../@id"/> can not be empty.</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="literal_component">
        <sch:rule context="oval-def:literal_component">
            <sch:assert test=".!=''">The literal_component of variable <value-of select="../../@id"/> can not be empty.</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="item_field">
        <sch:rule context="oval-def:object_component">
            <sch:assert test="@item_field!=''">The item_field attribute of an object_component of variable <value-of select="../../@id"/> can not be empty.</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="entityvarref">
        <sch:rule context="oval-def:objects/*/*|oval-def:states/*/*">
            <sch:assert test="not(@var_ref) or .=''">
                <value-of select="../@id"/> - a var-ref has been supplied for the <value-of select="name()"/> entity so no value should be provided</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:pattern id="entitystatus">
        <sch:rule context="oval-sc:system_data/*/*">
            <sch:assert test="not(@status) or @status='exists' or .=''">item <value-of select="../@id"/> - a value for the <value-of select="name()"/> entity should only be supplied if the status attribute is 'exists'</sch:assert>
        </sch:rule>
    </sch:pattern>
    <sch:diagnostics/>
</sch:schema>
