//
// $Id: OvalEnum.h,v 1.13 2006/05/25 00:34:21 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef OVALENUM_H
#define OVALENUM_H

#include <string>
#include <iostream>
#include <stdlib.h>

#include "Exception.h"
#include "Common.h"

using namespace std;

/**
	This class stores all the enumerations that are common to more than one oval schema.
	Along with each enumeration are the methods need for translating that enumeration tothe oval 
	schema equivalent values.
*/
class OvalEnum {

public:
	/** An enum to define the acceptable check values. */
	enum Check	{ALL_CHECK,
				AT_LEAST_ONE_CHECK,
				NONE_EXIST_CHECK,
				ONLY_ONE_CHECK};
	static string CheckToString(OvalEnum::Check check);
	static OvalEnum::Check ToCheck(string checkStr);

	/** An enum to define the acceptable data types. */
	enum Datatype	{STRING_TYPE,
					INTEGER_TYPE,
					IOS_VERSION_TYPE,
					BINARY_TYPE,
					BOOLEAN_TYPE,
					EVR_STRING_TYPE,
					FLOAT_TYPE,
					VERSION_TYPE};
	static string DatatypeToString(OvalEnum::Datatype datatype);
	static OvalEnum::Datatype ToDatatype(string datatypeStr);

	/** enumeration of possible CollectedObject Flag values. */
	enum Flag	{ERROR_FLAG,
				COMPLETE_FLAG,
				INCOMPLETE_FLAG,
				DOES_NOT_EXIST_FLAG,
				NOT_COLLECTED_FLAG,
				NOT_APPLICABLE_FLAG};
	static string FlagToString(OvalEnum::Flag flag);
	static OvalEnum::Flag ToFlag(string flagStr);

	/** An enum to define the acceptable levels. */
	enum Level	{DEBUG_LEVEL,
				ERROR_LEVEL,
				FATAL_LEVEL,
				INFO_LEVEL,
				WARNING_LEVEL};
	static string LevelToString(OvalEnum::Level level);
	static OvalEnum::Level ToLevel(string levelStr);


	/** enumeration of Operations and supporting methods. */
	enum Operation	{EQUALS_OPERATION, 
					NOT_EQUAL_OPERATION, 
					GREATER_THAN_OPERATION, 
					LESS_THAN_OPERATION, 
					GREATER_THAN_OR_EQUAL_OPERATION, 
					LESS_THAN_OR_EQUAL_OPERATION, 
					BITWISE_AND_OPERATION, 
					BITWISE_OR_OPERATION, 
					PATTERN_MATCH_OPERATION};
	static string OperationToString(OvalEnum::Operation operation);
	static OvalEnum::Operation ToOperation(string operationStr);

	/** enumeration of Operators and supporting methods. */
	enum Operator	{AND_OPERATOR,
							OR_OPERATOR,
							XOR_OPERATOR};
	static OvalEnum::Operator ToOperator(string operatorStr);
	static string OperatorToString(OvalEnum::Operator op);

	/** enumeration of Result Values and supporting methods. */
	enum ResultEnumeration	{TRUE_RESULT,
									FALSE_RESULT,
									UNKNOWN_RESULT,
									ERROR_RESULT,
									NOT_EVALUATED_RESULT,
									NOT_APPLICABLE_RESULT};
	static OvalEnum::ResultEnumeration ToResult(string resultStr);
	static string ResultToString(OvalEnum::ResultEnumeration result);

	static OvalEnum::ResultEnumeration CombineResultsByOperator(IntVector* results, OvalEnum::Operator op);    
	static OvalEnum::ResultEnumeration CombineResultsByCheck(IntVector* results, OvalEnum::Check check);
	static OvalEnum::ResultEnumeration NegateResult(OvalEnum::ResultEnumeration);

	/** An enum to define the acceptable status values. */
	enum SCStatus	{ERROR_STATUS,
					EXISTS_STATUS,
					DOES_NOT_EXIST_STATUS,
					NOT_COLLECTED_STATUS};
	static string SCStatusToString(OvalEnum::SCStatus status);
	static OvalEnum::SCStatus ToSCStatus(string statusStr);

	/** An eumeration of possible SetOperator values in the definition schema. */
	enum SetOperator	{COMPLEMENT_SET_OPERATOR, 
						INTERSECTION_SET_OPERATOR,
						UNION_SET_OPERATOR};
	static string SetOperatorToString(OvalEnum::SetOperator operation);
	static OvalEnum::SetOperator ToSetOperator(string operationStr);
};

#endif
