//
// $Id: Analyzer.h,v 1.8 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef ANALYZER_H
#define ANALYZER_H

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

// other includes
#include "Definition.h"
#include "DocumentManager.h"
#include "Exception.h"
#include "Common.h"
#include "XmlCommon.h"
#include "Version.h"
#include "Item.h"

using namespace std;

/**
	The Analyzer class is the starting point for the oval analysis.
*/
class Analyzer {
public:
	Analyzer();
	~Analyzer();

	void Run();

	static DOMElement* GetResultsTestsElm();
	static DOMElement* GetResultsDefinitionsElm();
	void PrintResults();

private:

	string ResultPairToStr(StringPair* pair);

	void InitResultsDocument();
	void FinializeResultsDocument();

	static DOMElement* definitionsElm;
	static DOMElement* testsElm;

	StringPairVector trueResults;
	StringPairVector falseResults;
	StringPairVector unknownResults;
	StringPairVector errorResults;
	StringPairVector notEvaluatedResults;
	StringPairVector notApplicableResults;
	DOMElement* resultsSystemElm;
	DOMElement* resultsElm;
};

/** 
	This class represents an Exception that occured while running the analyzer.
*/
class AnalyzerException : public Exception {
	public:
		AnalyzerException(string errMsgIn = "", int severity = ERROR_FATAL, Exception* ex = NULL);
		~AnalyzerException();
};

#endif
