//
// $Id: AbsDataCollector.h,v 1.3 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef OVALDATACOLLECTOR_H
#define OVALDATACOLLECTOR_H

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <vector>
#include <iostream>
#include <stdlib.h>

//	include common classes
#include "DocumentManager.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "Version.h"
#include "XmlCommon.h"
#include "AbsObjectCollector.h"
#include "CollectedObject.h"
#include "AbsVariable.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

class AbsObjectCollector; // forward declaration needed to allow successful compilation

/**
	This class acts as a base class for all data collectors. Doing so provides some common
	functionality to all child classes and simplifies the creation of a new data collector. 
	Collectors are family specific. That is each time a new family is added to the OVAL
	schema a new collector class should be created to support it. Each family specific
	collector is responsible for making calls to the probes used to gather data for that
	families tests. Look at the Run() method in the DataCollector class for guidance.
*/
class AbsDataCollector {

public:
	AbsDataCollector();
	virtual ~AbsDataCollector();

	static AbsDataCollector* Instance();
	void AddSchemaLocation(string newSchemaLocation);
	void AddXmlns(string newXmlnsAlias, string newXmlnsUri);
	void Run();

	DOMElement* GetSCCollectedObjectsElm();
	DOMElement* GetSCSystemDataElm();

	void InitBase(AbsObjectCollector*);

	static bool GetIsRunning();

protected:

	void ProcessLocalVariables();
	void WriteGenerator();
	virtual void WriteSystemInfo() = 0;

	DOMElement* collectedObjectsElm;
	DOMElement* systemDataElm;
	AbsObjectCollector *objectCollector;
	static AbsDataCollector* instance;
	static bool isRunning;
};

/** 
	This class represents an Exception that occured while running the Data collector.
*/
class AbsDataCollectorException : public Exception {
public:
	AbsDataCollectorException(string errMsgIn = "", int severity = ERROR_FATAL, Exception *ex = NULL);
	~AbsDataCollectorException();
};

#endif
