//
// $Id: ObjectComponent.cpp,v 1.9 2006/08/16 16:24:17 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "ObjectComponent.h"

//****************************************************************************************//
//								ObjectComponent Class									  //	
//****************************************************************************************//
ObjectComponent::ObjectComponent(string objectId, string itemField) : AbsComponent() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete ObjectComponent object
	//
	// -----------------------------------------------------------------------

	this->SetObjectId(objectId);
	this->SetItemField(itemField);
}

ObjectComponent::~ObjectComponent() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//
string ObjectComponent::GetObjectId() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the objectId field's value
	//
	// -----------------------------------------------------------------------

	return this->objectId;
}

void ObjectComponent::SetObjectId(string objectId) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the objectId field's value
	//
	// -----------------------------------------------------------------------

	this->objectId = objectId;
}

string ObjectComponent::GetItemField() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the itemField field's value
	//
	// -----------------------------------------------------------------------

	return this->itemField;
}

void ObjectComponent::SetItemField(string itemField) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the itemField field's value
	//
	// -----------------------------------------------------------------------

	this->itemField = itemField;
}

StringVector* ObjectComponent::ComputeValue() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	calculate the value of this ObjectComponent
	//	- make call to AbsObjectCollector
	//	- get a collected object and then get the matching Item(s)
	//	- then look for the Item with the Entity named the same as this->itemField
	//	- then get that value and return it as a string.
	// -----------------------------------------------------------------------

	StringVector* values = new StringVector();
	bool foundElm = false;
	ItemVector* items = NULL;
	string errorMsg = "";
	if(AbsDataCollector::GetIsRunning()) {
		CollectedObject* collectedObject = AbsObjectCollector::Instance()->Run(this->GetObjectId());
		items = collectedObject->GetReferences();
		if(collectedObject->GetMessages()->size() > 0) {
			errorMsg = collectedObject->GetMessages()->at(1)->GetValue();
		}

	} else {
		items = ObjectReader::GetItemsForObject(this->GetObjectId());
	}

	if(items->size() > 0) {
		
		ItemVector::iterator iterator;
		for(iterator = items->begin(); iterator != items->end(); iterator++) {
			Item* item = (*iterator);
		
			ItemEntityVector* elements = item->GetElementsByName(this->GetItemField());
			ItemEntityVector::iterator iterator;
			for(iterator = elements->begin(); iterator != elements->end(); iterator++) {
				string value = (*iterator)->GetValue();
				values->push_back(value);
				foundElm = true;
			}
		}

		if(!foundElm) {
			throw Exception("ObjectComponent::ComputeValue() - Unable to compute variable value. No elements found for the specified object_component id: " + this->GetObjectId() + " that match the specified field name: " + this->GetItemField());
		}

	} else {
		if(errorMsg.compare("") != 0) {
			throw Exception("ObjectComponent::ComputeValue() - Unable to compute variable value. No items found for the specified object_component id: " + this->GetObjectId() + errorMsg);
		} else {
			throw Exception("ObjectComponent::ComputeValue() - Unable to compute variable value. No items found for the specified object_component id: " + this->GetObjectId());
		}
	}

	return values;	
}

void ObjectComponent::Parse(DOMElement* ObjectComponentElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	parse the ObjectComponent element
	// -----------------------------------------------------------------------
    
	this->SetObjectId(XmlCommon::GetAttributeByName(ObjectComponentElm, "object_ref"));
	this->SetItemField(XmlCommon::GetAttributeByName(ObjectComponentElm, "item_field"));
}

VariableValueVector* ObjectComponent::GetVariableValues() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	return the variable values used to compute this component's value
	// -----------------------------------------------------------------------

	VariableValueVector* values = NULL;
	if(AbsDataCollector::GetIsRunning()) {
		CollectedObject* collectedObject = AbsObjectCollector::Instance()->Run(this->GetObjectId());
		values = collectedObject->GetVariableValues();
	} else {
		values = ObjectReader::GetVariableValuesForObject(this->GetObjectId());
	}
	
	return values;
}
