//
// $Id: AbsObjectCollector.h,v 1.7 2007/01/09 17:43:01 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef OVALOBJECTCOLLECTOR_H
#define OVALOBJECTCOLLECTOR_H

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <vector>
#include <iostream>
#include <stdlib.h>

#include "OvalEnum.h"
#include "Filter.h"
#include "Object.h"
#include "SetObject.h"
#include "Item.h"
#include "CollectedObject.h"
#include "CollectedSet.h"
#include "AbsProbe.h"

//	namespaces
using namespace std;

// forward declarations
class AbsProbe;
class SetObject;
class Object;
class Set;
class CollectedObject;
class CollectedSet;
class Filter;
class AbsState;
typedef vector < AbsState*, allocator<AbsState*> > AbsStateVector;


/**
	This class acts a base class for all platform specific object collectors.
*/
class AbsObjectCollector {
public:
	virtual ~AbsObjectCollector();
	static AbsObjectCollector* Instance();

	CollectedObject* Run(string objectId);

protected:
	AbsObjectCollector();
	static AbsObjectCollector* instance;

	virtual bool IsApplicable(AbsObject* object) = 0;
	virtual bool IsSupported(AbsObject* object) = 0;
	virtual AbsProbe* GetProbe(Object* object) = 0;
	
	CollectedObject* Process(AbsObject* absObject);
	CollectedObject* ProcessSetObject(SetObject* setObject);
	CollectedObject* ProcessObject(Object* object);

	CollectedSet* ProcessSet(Set* set);	
	
	OvalEnum::Flag CombineFlagBySetOperator(OvalEnum::SetOperator setOp, OvalEnum::Flag set1Flag, OvalEnum::Flag set2Flag);

	bool ExistsInSet(ItemVector* itemSet, Item* item);
	CollectedSet* Union(CollectedSet* collectedSet1, CollectedSet* collectedSet2);
	CollectedSet* Intersection(CollectedSet* collectedSet1, CollectedSet* collectedSet2);
	CollectedSet* Compelement(CollectedSet* collectedSet1, CollectedSet* collectedSet2);

	ItemVector* ApplyFilters(ItemVector* items, AbsStateVector* filters);
	
	void CopyItems(ItemVector* dest, ItemVector* src);
};

/** 
	This class represents an Exception that occured while runing the object collector.
*/
class AbsObjectCollectorException : public Exception {
	public:
		AbsObjectCollectorException(string errMsgIn = "", int severity = ERROR_FATAL, Exception *ex = NULL);
		~AbsObjectCollectorException();
};

#endif
