//
// $Id: AbsVariable.cpp,v 1.11 2007/01/09 17:43:01 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2002-2007, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "AbsVariable.h"

AbsVariableVector AbsVariable::processedVariables;

//****************************************************************************************//
//									AbsVariable Class									  //	
//****************************************************************************************//
AbsVariable::AbsVariable(string id,  string name, int version, OvalEnum::Datatype datatype, StringVector* msgs) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete Entity object
	//
	// -----------------------------------------------------------------------

	this->SetId(id);
	this->SetDatatype(datatype);
	this->SetName(name);
	this->SetVersion(version);
	this->SetFlag(OvalEnum::ERROR_FLAG);
	this->SetMessages(msgs);
}

AbsVariable::~AbsVariable() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	delete the messages
	//
	// -----------------------------------------------------------------------

	delete msgs;
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//

OvalEnum::Datatype AbsVariable::GetDatatype() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the datatype field's value
	//
	// -----------------------------------------------------------------------

	return this->datatype;
}

void AbsVariable::SetDatatype(OvalEnum::Datatype datatype) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the datatype field's value
	//
	// -----------------------------------------------------------------------

	this->datatype = datatype;
}

OvalEnum::Flag AbsVariable::GetFlag() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the flag field's value
	//
	// -----------------------------------------------------------------------

	return this->flag;
}

void AbsVariable::SetFlag(OvalEnum::Flag flag) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the flag field's value
	//
	// -----------------------------------------------------------------------

	this->flag = flag;
}

string AbsVariable::GetId() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the id field's value
	//
	// -----------------------------------------------------------------------

	return this->id;
}

void AbsVariable::SetId(string id) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the id field's value
	//
	// -----------------------------------------------------------------------

	this->id = id;
}

StringVector* AbsVariable::GetMessages() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the msgs field's value
	//
	// -----------------------------------------------------------------------

	return this->msgs;
}

void AbsVariable::SetMessages(StringVector* msgs) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the msgs field's value
	//
	// -----------------------------------------------------------------------

	this->msgs = msgs;
}

void AbsVariable::AppendMessage(string msg) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Add a msg to the end of the msgs vector
	//
	// -----------------------------------------------------------------------

	this->msgs->push_back(msg);
}

void AbsVariable::AppendMessages(StringVector* newMsgs) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Add a newMsgs to the end of the msgs vector
	//
	// -----------------------------------------------------------------------

	StringVector::iterator iterator;
	for(iterator = newMsgs->begin(); iterator != newMsgs->end(); iterator++) {
		this->AppendMessage((*iterator));
	}
}

string AbsVariable::GetName() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the name field's value
	//
	// -----------------------------------------------------------------------

	return this->name;
}

void AbsVariable::SetName(string name) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the name field's value
	//
	// -----------------------------------------------------------------------

	this->name = name;
}

VariableValueVector* AbsVariable::GetValues() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the value field's value
	//
	// -----------------------------------------------------------------------

	return &this->values;
}

void AbsVariable::SetValues(VariableValueVector* value) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the value field's value
	//
	// -----------------------------------------------------------------------

	this->values = values;
}

void AbsVariable::AppendVariableValue(VariableValue* value) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the version field's value
	//
	// -----------------------------------------------------------------------

	this->values.push_back(value);
}

int AbsVariable::GetVersion() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the version field's value
	//
	// -----------------------------------------------------------------------

	return this->version;
}

void AbsVariable::SetVersion(int version) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the version field's value
	//
	// -----------------------------------------------------------------------

	this->version = version;
}


AbsVariable* AbsVariable::SearchCache(string id) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	search the cache of variables for the specifed variable. 
	//	return NULL if not found
	//
	// -----------------------------------------------------------------------

	AbsVariable* cachedAbsVariable = NULL;

	AbsVariableVector::iterator iterator;
	for(iterator = AbsVariable::processedVariables.begin(); iterator != AbsVariable::processedVariables.end(); iterator++) {
		if((*iterator)->GetId().compare(id) == 0) {
			cachedAbsVariable = (*iterator);
			break;
		}
	}

	return cachedAbsVariable;
}

void AbsVariable::ClearCache() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	delete all items in the cache
	//
	// -----------------------------------------------------------------------

	AbsVariable* var = NULL;
	while(AbsVariable::processedVariables.size() != 0) {
	  	var = AbsVariable::processedVariables[AbsVariable::processedVariables.size()-1];
	  	AbsVariable::processedVariables.pop_back();
	  	delete var;
	  	var = NULL;
	}
}

void AbsVariable::Cache(AbsVariable* var) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	// cache the specified var
	//	TODO - do i need to add protection to this cache
	// -----------------------------------------------------------------------
	
	AbsVariable::processedVariables.push_back(var);
}
