#!/bin/bash

###############################################################################
# This wrapper script runs the definition interpreter with good arguments.    #
#									      #
#   by Jay Beale, 4/2004, Copyright Mitre Corporation 			      #
#   Updated by Brendan Dolan-Gavitt, 10/2006				      #
###############################################################################

#
# Test to make sure the user has either supplied their own defs or
# that they exist in the default location.
#
if [ $# == 1 ]; then
  DEFS="$1"
  # Check to make sure schema files are in the same directory
  SCHEMADIR=`dirname "$DEFS"`
  if [ ! -f ${SCHEMADIR}/oval-common-schema.xsd ]; then
    echo "Error: Schema files must be located in the same directory as the"
    echo "definition file."
    exit 1
  fi
elif [ -f /usr/share/ovaldi/linux.definitions.xml ]; then
  DEFS=/usr/share/ovaldi/linux.definitions.xml
else
  echo "Error: no definitions file specified and default definitions"
  echo "(/usr/share/ovaldi/linux.definitions.xml) do not exist."
  echo "usage: $0 [definitions.xml]"
  exit 1
fi
	

#
# Get a date of the start of the run, so we can date-stamp the results
# files.
#

DATE=`/bin/date +%F--%T`

#
# Next, run the definition interpreter pointing it to the locations of the
# files it uses.
#

cd /var/log/ovaldi
/usr/sbin/ovaldi -d /var/log/ovaldi/data-$DATE.xml \
		 -r /var/log/ovaldi/results-$DATE.xml \
		 -t /usr/share/ovaldi/results_to_html.xsl \
		 -x /var/log/ovaldi/results-$DATE.html \
		 -o $DEFS \
		 -m \

echo ...
echo Results-related files are stored in /var/log/ovaldi.
echo ...
