//
// $Id: AbsVariable.h,v 1.14 2006/10/27 18:32:56 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef ABSVARIABLE_H
#define ABSVARIABLE_H

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <vector>
#include <iostream>
#include <stdlib.h>

#include "Common.h"
#include "Exception.h"
#include "OvalEnum.h"
#include "VariableValue.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

class AbsVariable;

/**
	A vector for storing AbsVariable objects. 
	Stores only pointers to the objects. 
*/
typedef vector < AbsVariable*, allocator<AbsVariable*> > AbsVariableVector;

/**
	This class represents an AbsVariable in an oval definition schema.
*/
class AbsVariable {
public:
	virtual ~AbsVariable();

	virtual void Parse(DOMElement*) = 0;

	virtual VariableValueVector* GetVariableValues() = 0;
	
	string GetId();
	void SetId(string id);

	OvalEnum::Datatype GetDatatype();
	void SetDatatype(OvalEnum::Datatype datatype);

	OvalEnum::Flag GetFlag();
	void SetFlag(OvalEnum::Flag flag);

	string GetName();
	void SetName(string name);

	VariableValueVector* GetValues();
	void SetValues(VariableValueVector* value);
	void AppendVariableValue(VariableValue* value);

	int GetVersion();
	void SetVersion(int version);

	StringVector* GetMessages();
	void SetMessages(StringVector* msgs);
	void AppendMessage(string msg);
	void AppendMessages(StringVector* newMsgs);

	static AbsVariable* SearchCache(string id);
	static void ClearCache();
	static void Cache(AbsVariable* var);

protected:
	AbsVariable(string id = "", string name = "", int version = 1, OvalEnum::Datatype datatype = OvalEnum::STRING_TYPE, StringVector* msgs = new StringVector());

private:

	string id;
	OvalEnum::Flag flag;
	string name;
	int version;
	OvalEnum::Datatype datatype;
	VariableValueVector values; 
	bool error;
	StringVector* msgs;

	static AbsVariableVector processedVariables;
};

#endif
