//
// $Id: PossibleType.cpp,v 1.3 2006/08/18 14:01:45 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "PossibleType.h"

//****************************************************************************************//
//									PossibleType Class									  //	
//****************************************************************************************//

PossibleType::PossibleType() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete PossibleType
	//
	// -----------------------------------------------------------------------

}

PossibleType::~PossibleType() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	// -----------------------------------------------------------------------

}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//
void PossibleType::Parse(DOMElement* possibleTypeElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the provided PossibleType element into a PossibleType
	//
	// -----------------------------------------------------------------------

	// Get all the value elements' values
	DOMNodeList *possibleTypeElmChildren = possibleTypeElm->getChildNodes();
	unsigned int index = 0;
	while(index < possibleTypeElmChildren->getLength()) {
		DOMNode *tmpNode = possibleTypeElmChildren->item(index);
		if (tmpNode->getNodeType() == DOMNode::ELEMENT_NODE) {
			DOMElement *childElm = (DOMElement*)tmpNode;

			string elmName = XmlCommon::GetElementName(childElm);
			
			// parse each possible element
			if(elmName.compare("possible") == 0) {
				throw Exception("Error nested possible types are not supported.");
				/*PossibleType *possibleType = new PossibleType();
				possibleType->Parse(childElm);
				this->AppendPossibleType(possibleType);*/
			} else if(elmName.compare("restriction") == 0) {
				RestrictionType *restrictionType = new RestrictionType();
				restrictionType->Parse(childElm);
				this->AppendRestrictionType(restrictionType);
			}
		}
		index ++;
	}
}

PossibleTypeVector* PossibleType::GetPossibleTypes() {
	return &this->possibleTypes;
}

void PossibleType::AppendPossibleType(PossibleType* pt) {
	this->possibleTypes.push_back(pt);
}

RestrictionTypeVector* PossibleType::GetRestrictionTypes() {
	return &this->restrictionTypes;
}

void PossibleType::AppendRestrictionType(RestrictionType* rt) {
	this->restrictionTypes.push_back(rt);
}

bool PossibleType::ValidateValue(OvalEnum::Datatype datatype, string value) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Ensure that the specified value matches the criteria 
	//	specified by this possible element
	//	
	// ----------------------------------------------------------------------

	bool isValid = true;
	
	// loop through all restriction elements - if all are true return true 
	RestrictionTypeVector::iterator iterator;
	for(iterator = this->GetRestrictionTypes()->begin(); iterator != this->GetRestrictionTypes()->end(); iterator++) {
		isValid = (*iterator)->ValidateValue(datatype, value);
		if(!isValid) {
			break;
		}
	}

	return isValid;
}
