//
// $Id: Definition.h,v 1.7 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef DEFINITION_H
#define DEFINITION_H
#include <map>
#include <utility>
#include "AbsCriteria.h"
#include "Criteria.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

class Criteria;

class Definition;

/**
	A vector for storing Definition objects. 
	Stores only pointers to the objects. 
*/
typedef vector < Definition*, allocator<Definition*> > DefinitionVector;

/**	
	A pair for storing definition ids and Definition objects together. 
	Stores only pointers to the objects. 
*/
typedef pair <string, Definition* > DefinitionPair;

/**	
	A map for storing DefinitionPairs. 
	Stores only pointers to the objects. 
*/
typedef map <string, Definition* > DefinitionMap;

/**
	This class represents an oval definition.
	The Definition class provides methods for parsing a definition in an
	oval defintions files, analyzing that definitions, and then writing that defition
	with its analysis result to an oval results file.
*/
class Definition {

public:
	Definition();
	~Definition();

	void Write(DOMElement* parent);
	void Parse(DOMElement* DefinitionElm);
	OvalEnum::ResultEnumeration Analyze();

	int GetVersion();
	void SetVersion(int version);
	
	int GetVariableInstance();
	void SetVariableInstance(int variableInstance);
    
	OvalEnum::ResultEnumeration GetResult();
	void SetResult(OvalEnum::ResultEnumeration result);

	Criteria* GetCriteria();
	void SetCriteria(Criteria* criteria);
    
	string GetId();
	void SetId(string id);

	bool GetWritten();
	void SetWritten(bool written);

	bool GetAnalyzed();
	void SetAnalyzed(bool analyzed);

	static Definition* SearchCache(string id);
	static void ClearCache();

private:
	int version;
	int variableInstance;
	OvalEnum::ResultEnumeration result;
	Criteria* criteria;
	string id;
	bool written;
	bool analyzed;

	static DefinitionMap processedDefinitionsMap;
};


#endif
