//
// $Id: AbsFileFinder.h,v 1.9 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef ABSFILEFINDER_H
#define ABSFILEFINDER_H

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

#include "Log.h"
#include "Common.h"
#include "Exception.h"
#include "REGEX.h"
#include "ObjectEntity.h"
#include "ItemEntity.h"

#include <string>
#include <vector>

using namespace std;

/**
	This class provides a common mechanism for searching for files.
	Searches are based on a provided path and file name where each may contain
	operations like equal, not equal, and pattern match.
*/
class AbsFileFinder {
public:
	AbsFileFinder();
	virtual ~AbsFileFinder();

	StringPairVector* SearchFiles(ObjectEntity* path, ObjectEntity* fileName, BehaviorVector* behaviors);

	StringVector* GetPaths(ObjectEntity* path);
	StringVector* GetFileNames(string path, ObjectEntity* fileName, BehaviorVector* behaviors);

protected:
	virtual bool PathExists(string path) = 0;
	virtual bool FileNameExists(string path, string fileName) = 0;
	virtual void FindPaths(string regex, StringVector* paths, bool isRegex = true) = 0;
	virtual void GetFilesForPattern(string path, string pattern, BehaviorVector* behaviors, StringVector* fileNames, bool isRegex = true) =0;

	bool IsMatch(string pattern, string value, bool isRegex = true);

	REGEX *fileMatcher;
};
/** 
	This class represents an Exception that occured while useing a FileFinder.
*/
class FileFinderException : public Exception {
	public:
		FileFinderException(string errMsgIn = "", int severity = ERROR_FATAL, Exception* ex = NULL);
		~FileFinderException();
};

#endif
