%define name	ovaldi
%define version	5.1.0
%define release	1

Summary:	The reference interpreter for the Open Vulnerability and Assessment Language
Name:		%{name}
Version:	%{version}
Release:	%{release}
Source0:	http://oval.mitre.org/DontDownload/oval/download/Interpreters.tbz2
Copyright:	BSD
Group:		System/Configuration/Other
BuildRoot:	%{_tmppath}/%{name}-buildroot
Prefix:		%{_prefix}
BuildArchitectures: i386

%description
OVAL, or the Open Vulnerability Assessment Language, describes how
to check a system for vulnerabilities, providing a common human
readable and machine-parseable language to discuss, refine, and test
vulnerability definitions.

This Vulnerability Definition Interpreter checks a system against
vulnerabilities described in the bundled XML definitions file.


To run:

/usr/sbin/ovaldi.sh

%package libs
Summary: Libraries required to run the OVAL interpreter.
Group: System/Configuration/Other
%description libs
This package contains the Xerces and Xalan XML libraries needed to run
the OVAL interpreter. These libraries are available from the Apache
Foundation, but are not yet packaged for Redhat.

%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%setup -n Interpreters
#%patch -p0

%build
cd project/linux
mkdir -p Release/obj
make

%install
/bin/mkdir -p $RPM_BUILD_ROOT/usr/sbin
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/usr/lib/ovaldi
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/mkdir -m 700 -p $RPM_BUILD_ROOT/var/log/ovaldi
/bin/mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1

/bin/cp project/linux/Release/ovaldi $RPM_BUILD_ROOT/usr/sbin
/bin/cp project/linux/ovaldi.sh $RPM_BUILD_ROOT/usr/sbin

/usr/bin/gzip docs/ovaldi.1
/bin/cp docs/ovaldi.1.gz $RPM_BUILD_ROOT%{_mandir}/man1

/bin/cp xml/results_to_html.xsl $RPM_BUILD_ROOT/usr/share/ovaldi
/bin/cp xml/*.xsd $RPM_BUILD_ROOT/usr/share/ovaldi

if grep "release 3" /etc/redhat-release &> /dev/null ; then
  /bin/cp project/linux/EL3/libxerces-c.so.27.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
  /bin/cp project/linux/EL3/libxalan-c.so.110.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
  /bin/cp project/linux/EL3/libxalanMsg.so.110.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
elif grep "release 4" /etc/redhat-release &> /dev/null ; then
  /bin/cp project/linux/EL4/libxerces-c.so.27.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
  /bin/cp project/linux/EL4/libxalan-c.so.110.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
  /bin/cp project/linux/EL4/libxalanMsg.so.110.0 $RPM_BUILD_ROOT/usr/lib/ovaldi
else
  echo "Unsupported Redhat version. Exiting."
  exit 1
fi

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
/bin/rm -fr $RPM_BUILD_ROOT/%{name}

%post libs
# Add /usr/lib/ovaldi to the end of /etc/ld.so.conf if it's not yet present.
if [ `/bin/egrep -c '^/usr/lib/ovaldi' /etc/ld.so.conf ` -lt 1 ] ; then
        /bin/echo "/usr/lib/ovaldi" >>/etc/ld.so.conf
#	/sbin/ldconfig
fi
/sbin/ldconfig

%preun libs
if [ $1 = 0 ]; then
    #// Do stuff specific to uninstalls
    if [ -e /usr/lib/ovaldi/libxerces-c.so.27 ] ; then
        /bin/rm /usr/lib/ovaldi/libxerces-c.so.27
    fi
    if [ -e /usr/lib/ovaldi/libxerces-c.so ] ; then
        /bin/rm /usr/lib/ovaldi/libxerces-c.so
    fi
    if [ -e /usr/lib/ovaldi/libxalan-c.so.110 ] ; then
        /bin/rm /usr/lib/ovaldi/libxalan-c.so.110
    fi
    if [ -e /usr/lib/ovaldi/libxalan-c.so ] ; then
        /bin/rm /usr/lib/ovaldi/libxalan-c.so
    fi
    if [ -e /usr/lib/ovaldi/libxalanRMsg.so.110 ] ; then
        /bin/rm /usr/lib/ovaldi/libxalanMsg.so.110
    fi
    if [ -e /usr/lib/ovaldi/libxalanMsg.so ] ; then
        /bin/rm /usr/lib/ovaldi/libxalanMsg.so
    fi
fi

%postun libs
if [ $1 = 0 ]; then
   # // Do stuff specific to uninstalls
if  [ `/bin/egrep -c '^/usr/lib/ovaldi' /etc/ld.so.conf ` -gt 0 ] ; then
        /bin/egrep -v '^/usr/lib/ovaldi$' /etc/ld.so.conf >/usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/chown root:root /usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/chmod 644 /usr/lib/etc.ld.so.conf.uninstalling-oval
        /bin/mv /usr/lib/etc.ld.so.conf.uninstalling-oval /etc/ld.so.conf
fi
/sbin/ldconfig
fi
if [ $1 = 1 ]; then
	/sbin/ldconfig
   # // Do stuff specific to upgrades
fi

%files 
%defattr(-,root,root,0700)
%doc docs/terms.txt docs/README.txt docs/version.txt
%doc %{_mandir}/man1/ovaldi.1.gz
%defattr(-,root,root,0600)
%attr(0700,root,root)  /usr/sbin/ovaldi
%attr(0700,root,root)  /usr/sbin/ovaldi.sh
%attr(0700,root,root)  /var/log/ovaldi
/usr/share/ovaldi/results_to_html.xsl
/usr/share/ovaldi/*.xsd

%files libs
/usr/lib/ovaldi/libxerces-c.so.27.0
/usr/lib/ovaldi/libxalan-c.so.110.0
/usr/lib/ovaldi/libxalanMsg.so.110.0

%changelog

* Mon Oct 30 2006 Brendan Dolan-Gavitt <brendandg@mitre.org> 5.1.0-1.0
* Created subpackage for libs, updated to 5.1 source. Some .spec cleanup performed.

* Tue May 02 2006 Matt Burton <mburton@mitre.org> 5.0.0-1.0
* New RPM using version 5 source & new SPEC file

* Tue Oct 11 2005 Matt Burton <mburton@mitre.org> 4.3.0-1.3
* Rebuild RPM with new source

* Thu Aug 11 2005 Matt Burton <mburton@mitre.org> 4.2.0-1.3
* Added new schema files (independant, unix and xmldsig), new source

* Tue Apr 12 2005 Matt Burton <mburton@mitre.org> 4.1.0-1.2
* Added libxalan libraries and new source to RPM

* Tue Feb 22 2005 Matt Burton <mburton@mitre.org> 4.0.0-1.1
* Changed SPEC file to use the 2.6 xerces library

* Thu Jan 20 2005 Jay Beale <jay@bastille-linux.org> 4.0.0-1.0
* Modified RPM for ovaldi 4.0.0's new structure

* Mon Oct 18 2004 Jay Beale <jay@bastille-linux.org> 3.4.0-1.0
* Rebuilt RPM with new source

* Wed Sep 1 2004 Jay Beale <jay@bastille-linux.org> 3.3.0-1.0
* Rebuilt RPM with new source

* Wed Jul 14 2004 Jay Beale <jay@bastille-linux.org> 3.2.0-1.0
* Rebuilt RPM with new source

* Sun Jun 6 2004 Jay Beale <jay@bastille-linux.org> 3.1.0-1.0
- Rebuilt with new locations and such

* Thu May 6 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.3
- Removed xerces libraries symlinking

* Wed Apr 28 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.2
- Updated to new version

* Wed Apr 21 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.1
- Changed oval.xml to definitions.xml

* Mon Apr 19 2004 Jay Beale <jay@bastille-linux.org> 1.0.0-1.0
- Initial package creation - enjoy
