//
// $Id: RegistryProbe.h,v 1.3 2006/09/06 15:25:59 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
#ifndef REGISTRYPROBE_H
#define REGISTRYPROBE_H

#pragma warning(disable:4786)

#include "AbsProbe.h"
#include "WindowsCommon.h"

#include <windows.h>

using namespace std;

/**
	This class is responsbile for collecting registry information for windows registry_objects.
*/
class RegistryProbe : public AbsProbe {
public:
	~RegistryProbe();
	
	ItemVector* CollectItems(Object* object);
	Item* CreateItem();

	static AbsProbe* Instance();
	

private:
	RegistryProbe();

	static RegistryProbe* instance;

	ItemEntityVector* GetHives(ObjectEntity* hive);
	ItemEntityVector* GetKeys(ObjectEntity* key, ItemEntity* hive);
	ItemEntityVector* GetNames(ObjectEntity* name, ItemEntity* hive, ItemEntity* key);
	
	Item* GetRegistryKey(ItemEntity*, ItemEntity*, ItemEntity*);
	HKEY GetRootKey(string);
	void GetMatchingHives(string, ItemEntityVector*, bool isRegex = true);
	void GetMatchingKeys(string hiveIn, string keyIn, string pattern, ItemEntityVector* keys, bool isRegex = true);
	void GetMatchingNames(string hiveIn, string keyIn, string pattern, ItemEntityVector* names, bool isRegex = true);	
	void KeyPatternMatch(ItemEntity* hive, string pattern, ItemEntityVector* keys, bool isRegex = true);
	void RetrieveInfo(string, string, string, DWORD, LPBYTE, DWORD, Item*);
	bool KeyExists(string hive, string key);
	bool NameExists(string hive, string key, string name);
};

#endif
