//
// $Id: ExternalVariable.h,v 1.4 2006/10/27 18:33:05 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef EXTERNALVARIABLE_H
#define EXTERNALVARIABLE_H

#include "AbsVariable.h"
#include "PossibleType.h"
#include "DocumentManager.h"

using namespace std;

/**
	This class represents an external_variable in the oval definition schema.
*/
class ExternalVariable : public AbsVariable {
public:

	ExternalVariable(string id = "", string name = "external_variable", int version = 1, OvalEnum::Datatype datatype = OvalEnum::STRING_TYPE, StringVector* msgs = new StringVector());
	~ExternalVariable();

	void Parse(DOMElement* externalVariableElm);

	void ComputeValue();
	bool ValidateValue(OvalEnum::Datatype datatype, string value);

	PossibleTypeVector* GetPossibleTypes();
	void AppendPossibleType(PossibleType* pt);

	VariableValueVector* GetVariableValues();

	PossibleTypeVector possibleTypes;
};

#endif
