//
// $Id: Behavior.cpp,v 1.3 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "Behavior.h"

//****************************************************************************************//
//								Behavior Class											  //	
//****************************************************************************************//
Behavior::Behavior(string name, string value) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete Behavior object
	//
	// -----------------------------------------------------------------------

	this->SetName(name);
	this->SetValue(value);
}

Behavior::~Behavior() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//
string Behavior::GetName() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the name field's value
	//
	// -----------------------------------------------------------------------

	return this->name;
}

void Behavior::SetName(string name) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the name field's value
	//
	// -----------------------------------------------------------------------

	this->name = name;
}

string Behavior::GetValue() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the value field's value
	//
	// -----------------------------------------------------------------------

	return this->value;
}

void Behavior::SetValue(string value) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the value field's value
	//
	// -----------------------------------------------------------------------

	this->value = value;
}

BehaviorVector* Behavior::Parse(DOMElement* behaviorElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the behavior element into a vector of behavior objects
	//	return the vector.
	// -----------------------------------------------------------------------

	BehaviorVector* behaviors = new BehaviorVector();

	DOMNamedNodeMap* attributes = behaviorElm->getAttributes();
	int nSize = attributes->getLength();

	//	Loop through the attributes
	for(int i=0; i<nSize; ++i) {
		DOMAttr *pAttributeNode = (DOMAttr*) attributes->item(i);
		// get attribute name
		string attName = XmlCommon::ToString(pAttributeNode->getName());

		//	Get the attribute value
		string attVal = XmlCommon::ToString(pAttributeNode->getValue());
			
		Behavior* behavior = new Behavior(attName, attVal);
		behaviors->push_back(behavior);
	}

	return behaviors;
}

