//
// $Id: Test.h,v 1.9 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef TEST_H
#define TEST_H

#include <vector>
//#include "Analyzer.h"
#include "TestedItem.h"
#include "VariableValue.h"
#include "Log.h"
#include "State.h"


XERCES_CPP_NAMESPACE_USE
using namespace std;

class Test;

/**	
	A pair for storing test ids and Test objects together. 
	Stores only pointers to the objects. 
*/
typedef pair <string, Test* > TestPair;

/**	
	A map for storing TestPairs. 
	Stores only pointers to the objects. 
*/
typedef map <string, Test* > TestMap;

/**
	This class represents a test oval.
	The class provides a method for parsing a test in an oval definition as well as methods
	for analyzing that test and then writing the test result to an oval results document.
*/
class Test {

public:
	Test();
	~Test();

	void Write(DOMElement* parent);
	void Parse(DOMElement* testElm);
	OvalEnum::ResultEnumeration Analyze();

	int GetVersion();
	void SetVersion(int version);
	
	int GetVariableInstance();
	void SetVariableInstance(int variableInstance);
    
	OvalEnum::ResultEnumeration GetResult();
	void SetResult(OvalEnum::ResultEnumeration result);
    
	string GetId();
	void SetId(string id);

	string GetObjectId();
	void SetObjectId(string objectId);

	string GetStateId();
	void SetStateId(string stateId);

	bool GetWritten();
	void SetWritten(bool written);

	bool GetAnalyzed();
	void SetAnalyzed(bool analyzed);

	OvalEnum::Check GetCheck();
	void SetCheck(OvalEnum::Check check);

	TestedItemVector* GetTestedItems();
	void SetTestedItems(TestedItemVector* testedItems);
	void AppendTestedItem(TestedItem* testedItem);

	VariableValueVector* GetTestedVariables();
	void SetTestedVariables(VariableValueVector* testedVariables);
	void AppendTestedVariable(VariableValue* testedVariable);

	static Test* SearchCache(string id);
	static void ClearCache();

private:
	int version;
	int variableInstance;
	OvalEnum::ResultEnumeration result;
	string id;
	bool written;
	bool analyzed;
	OvalEnum::Check check;
	TestedItemVector testedItems;
	VariableValueVector testedVariables;
	string objectId;
	string stateId;

	//static TestVector processedTests;
	static TestMap processedTestsMap;
};

#endif
