//
// $Id: TestedItem.h,v 1.3 2006/05/01 13:27:33 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#ifndef TESTEDITEM_H
#define TESTEDITEM_H

#include "Log.h"
#include "Item.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;

/**
	This class representsa tested_item int eh oval results schema.
	The class pairs an Item tieh the result of its analysis in the context of a specific test.
*/
class TestedItem {

public:
	TestedItem();
	~TestedItem();

	void Write(DOMElement* parent);
	void Parse(DOMElement* itemElm);
	
	OvalEnum::ResultEnumeration GetResult();
	void SetResult(OvalEnum::ResultEnumeration result);
    
	Item* GetItem();
	void SetItem(Item* item);

private:
	OvalEnum::ResultEnumeration result;
	Item* item;
};

/**	
	A vector for storing TestedItem objects. 
	Stores only pointers to the objects. 
*/
typedef vector < TestedItem*, allocator<TestedItem*> > TestedItemVector;

#endif
