//
// $Id: ObjectComponent.cpp,v 1.10 2006/10/27 17:28:06 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2006, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "ObjectComponent.h"

//****************************************************************************************//
//								ObjectComponent Class									  //	
//****************************************************************************************//
ObjectComponent::ObjectComponent(string objectId, string itemField) : AbsComponent() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a compelete ObjectComponent object
	//
	// -----------------------------------------------------------------------

	this->SetObjectId(objectId);
	this->SetItemField(itemField);
}

ObjectComponent::~ObjectComponent() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	//
	// -----------------------------------------------------------------------
}

// ***************************************************************************************	//
//								 Public members												//
// ***************************************************************************************	//
string ObjectComponent::GetObjectId() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the objectId field's value
	//
	// -----------------------------------------------------------------------

	return this->objectId;
}

void ObjectComponent::SetObjectId(string objectId) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the objectId field's value
	//
	// -----------------------------------------------------------------------

	this->objectId = objectId;
}

string ObjectComponent::GetItemField() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Return the itemField field's value
	//
	// -----------------------------------------------------------------------

	return this->itemField;
}

void ObjectComponent::SetItemField(string itemField) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Set the itemField field's value
	//
	// -----------------------------------------------------------------------

	this->itemField = itemField;
}

ComponentValue* ObjectComponent::ComputeValue() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	calculate the value of this ObjectComponent
	//	- make call to AbsObjectCollector
	//	- get a collected object and then get the matching Item(s)
	//	- then look for the Item with the Entity named the same as this->itemField
	//	- then get that value and return it as a string.
	// -----------------------------------------------------------------------

	StringVector* values = new StringVector();
	bool foundElm = false;
	ItemVector* items = NULL;
	string errorMsg = "";
	OvalEnum::Flag collectedObjFlag = OvalEnum::ERROR_FLAG;
	if(AbsDataCollector::GetIsRunning()) {
		CollectedObject* collectedObject = AbsObjectCollector::Instance()->Run(this->GetObjectId());
		collectedObjFlag = collectedObject->GetFlag();
		items = collectedObject->GetReferences();
		if(collectedObject->GetMessages()->size() > 0) {
			errorMsg = collectedObject->GetMessages()->at(1)->GetValue();
		}

	} else {
		collectedObjFlag = ObjectReader::GetCollectedObjectFlag(this->GetObjectId());
		items = ObjectReader::GetItemsForObject(this->GetObjectId());
	}

	ComponentValue* result = new ComponentValue();
	// set the flag to the flag value of the collected object.
	result->SetFlag(collectedObjFlag);

	// only process the items if the flag on the colelcted obj is COMPLETE or INCOMPLETE
	if(collectedObjFlag == OvalEnum::COMPLETE_FLAG || collectedObjFlag == OvalEnum::INCOMPLETE_FLAG) {

		if(items->size() > 0) {
			
			ItemVector::iterator iterator;
			for(iterator = items->begin(); iterator != items->end(); iterator++) {
				Item* item = (*iterator);
			
				ItemEntityVector* elements = item->GetElementsByName(this->GetItemField());
				ItemEntityVector::iterator iterator;
				for(iterator = elements->begin(); iterator != elements->end(); iterator++) {
					// need to check status on item entity
					if((*iterator)->GetStatus() == OvalEnum::DOES_NOT_EXIST_STATUS) {
						result->SetFlag(OvalEnum::DOES_NOT_EXIST_FLAG);
					} else if((*iterator)->GetStatus() == OvalEnum::NOT_COLLECTED_STATUS) {
						result->SetFlag(OvalEnum::NOT_COLLECTED_FLAG);
					} else if((*iterator)->GetStatus() == OvalEnum::ERROR_STATUS) {
						result->SetFlag(OvalEnum::ERROR_FLAG);
					} else { // exists status
						result->SetFlag(OvalEnum::COMPLETE_FLAG);
						string value = (*iterator)->GetValue();
						result->AppendValue(value);
					}
					foundElm = true;
				}
			}

			if(!foundElm) {
				result->SetFlag(OvalEnum::NOT_COLLECTED_FLAG);
				result->AppendMessage("ObjectComponent::ComputeValue() - Unable to compute variable value. No elements found for the specified object_component id: " + this->GetObjectId() + " that match the specified field name: " + this->GetItemField());
			}

		} else {

			// This is an error because the collected object flag is set to COMPLETE or INCOMPLETE
			// and there are no items associated with it.
			result->SetFlag(OvalEnum::ERROR_FLAG);
			result->AppendMessage("Error no items are associated witht eh specified collected object: " + this->GetObjectId());
		}

	} else {

		if(errorMsg.compare("") != 0) {
			result->AppendMessage("ObjectComponent::ComputeValue() - Unable to compute variable value. No items found for the specified object_component id: " + this->GetObjectId() + errorMsg);			
		} else {
			result->AppendMessage("ObjectComponent::ComputeValue() - Unable to compute variable value. No items found for the specified object_component id: " + this->GetObjectId());
		}
	}

	return result;	
}

void ObjectComponent::Parse(DOMElement* ObjectComponentElm) {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	parse the ObjectComponent element
	// -----------------------------------------------------------------------
    
	this->SetObjectId(XmlCommon::GetAttributeByName(ObjectComponentElm, "object_ref"));
	this->SetItemField(XmlCommon::GetAttributeByName(ObjectComponentElm, "item_field"));
}

VariableValueVector* ObjectComponent::GetVariableValues() {
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	return the variable values used to compute this component's value
	// -----------------------------------------------------------------------

	VariableValueVector* values = NULL;
	if(AbsDataCollector::GetIsRunning()) {
		CollectedObject* collectedObject = AbsObjectCollector::Instance()->Run(this->GetObjectId());
		values = collectedObject->GetVariableValues();
	} else {
		values = ObjectReader::GetVariableValuesForObject(this->GetObjectId());
	}
	
	return values;
}
