//
// $Id: FileData.h,v 1.5 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	FilePermissionData.h
//  author: Jon Baker	
//
//	This class will store all data for a red hat process test.
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#ifndef __FILEDATA_H_
#define __FILEDATA_H_

#include "ProbeData.h"

class FileData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	FileData(DOMElement *test);
	FileData();
	~FileData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write();

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
	ObjectElement *path;

	// attribute data
	DataElement *type;
	DataElement *group_id;
	DataElement *user_id;
	DataElement *a_time;
	DataElement *c_time;
	DataElement *m_time;
	DataElement *md5;

	// permission data
	DataElement *gexec;
	DataElement *gread;
	DataElement *gwrite;
	DataElement *oexec;
	DataElement *oread;
	DataElement *owrite;
	DataElement *sgid;
	DataElement *sticky;
	DataElement *suid;
	DataElement *uexec;
	DataElement *uread;
	DataElement *uwrite;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMElement *test);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	// Store a string representation of each item collected
	static sVector items;
};

#endif
