//
// $Id: XmlProcessor.h,v 1.8 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  XmlProcessor
//  author: Jon Baker	
//
//	This class will handle parsing inputs to create a DOMDocument, writing DOMDocuments
//	to xml files, and creating new DOMDocuments..
//
//****************************************************************************************//

#ifndef __XMLPROCESSOR_H__
#define __XMLPROCESSOR_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>
#include <xercesc/dom/DOMImplementationRegistry.hpp>
#include <xercesc/dom/DOMBuilder.hpp>
#include <xercesc/dom/DOMException.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/dom/DOMError.hpp>
#include <xercesc/dom/DOMLocator.hpp>
#include <xercesc/dom/DOMNamedNodeMap.hpp>

// for dom Writer
#include <xercesc/dom/DOMImplementation.hpp>
#include <xercesc/dom/DOMImplementationLS.hpp>
#include <xercesc/dom/DOMWriter.hpp>
#include <xercesc/framework/StdOutFormatTarget.hpp>
#include <xercesc/framework/LocalFileFormatTarget.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
#include <xercesc/util/XMLUni.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <stdlib.h>

#include "Common.h"
#include "XmlCommon.h"
#include "Exception.h"

XERCES_CPP_NAMESPACE_USE
using namespace std;


class TestArray
{
	public:
		// -----------------------------------------------------------------------
		//	Constructors & Destructors
		// -----------------------------------------------------------------------
		TestArray(string type);
		~TestArray();

		// -----------------------------------------------------------------------
		//	Public members
		// -----------------------------------------------------------------------
		
		void flipTestBit(int testID);
		bool getTestBit(int testID);
        bool checkTestType(string testType);
        void setTestType(string testType);
		string getTestType();
		int getArraySize();
	private:

		// -----------------------------------------------------------------------
		//	Private members
		// -----------------------------------------------------------------------
        string testType;
		int arraysize;
		//bool* testBits = (bool*)malloc(1000);
		bool* testBits;
		void expandArray();
};


typedef vector < TestArray*, allocator<TestArray*> > taVector;


class XmlProcessor
{
	public:
		// -----------------------------------------------------------------------
		//	Constructors & Destructors
		// -----------------------------------------------------------------------
		XmlProcessor();
		~XmlProcessor();

		// -----------------------------------------------------------------------
		//	Public members
		// -----------------------------------------------------------------------
		XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* CreateDOMDocument(string);
		XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* CreateDOMDocumentNS(string, string);
		XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* ParseFile(string, bool validate=false);
		XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* PruneDOMDocument(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
		void WriteDOMDocument(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* doc, string filePath, bool writeToFile=true);
		
	private:
		// -----------------------------------------------------------------------
		//	Private members
		// -----------------------------------------------------------------------
		//taVector addTest(taVector testContainer, string testID);
		bool addTest(taVector *testContainer, string testID);
		//taVector processCompoundTest(taVector, string testID, XERCES_CPP_NAMESPACE_QUALIFIER DOMNodeList*); 
		void XmlProcessor::processCompoundTest(taVector *testContainer, string testID,  NodeVector *compoundTestVector);

		// -----------------------------------------------------------------------
		//	Private data
		// -----------------------------------------------------------------------
		DOMBuilder *parser;

};

class XmlProcessorException : public Exception
{
	public:
		XmlProcessorException(string errMsgIn = "", int severity = ERROR_FATAL);
		~XmlProcessorException();
};


// ---------------------------------------------------------------------------
//  Simple error handler deriviative to install on parser
// ---------------------------------------------------------------------------
class XmlProcessorErrorHandler : public DOMErrorHandler
{
public:
    // -----------------------------------------------------------------------
    //  Constructors and Destructor
    // -----------------------------------------------------------------------
    XmlProcessorErrorHandler();
    ~XmlProcessorErrorHandler();


    // -----------------------------------------------------------------------
    //  Getter methods
    // -----------------------------------------------------------------------
    bool getSawErrors() const;
	string getErrorMessages() const;

    // -----------------------------------------------------------------------
    //  Implementation of the DOM ErrorHandler interface
    // -----------------------------------------------------------------------
    bool handleError(const DOMError& domError);
    void resetErrors();


private :
    // -----------------------------------------------------------------------
    //  Unimplemented constructors and operators
    // -----------------------------------------------------------------------
    XmlProcessorErrorHandler(const XmlProcessorErrorHandler&);
    void operator=(const XmlProcessorErrorHandler&);


    // -----------------------------------------------------------------------
    //  Private data members
    //
    //  fSawErrors
    //      This is set if we get any errors, and is queryable via a getter
    //      method. Its used by the parser check if there are errors.
	//
	//	errorMessages
    //		This string is used to store all error messages that are generated 
	// -----------------------------------------------------------------------
    bool    fSawErrors;
	string	errorMessages;
};


#endif

