//
// $Id: OvalResultXml.h,v 1.10 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  OvalResultXml
//  author: Jon Baker	
//
//	This class is responsible for the creating, storing, and maintaining 
//	the results file.
//
//****************************************************************************************//

#ifndef __OVALRESULTXML_H__
#define __OVALRESULTXML_H__

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <iostream>
#include <sstream>

#include "Common.h"
#include "Exception.h"
#include "Version.h"
#include "XmlCommon.h"
#include "XmlProcessor.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

class OvalResultXml  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	OvalResultXml(XmlProcessor*, string, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
	virtual ~OvalResultXml();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	DOMElement* AddCompoundTest(string, string, string);
	void AddCriterion(DOMElement *resultDefinition, string type, string negateAttr, string test_refAttr, string criterionResult, string comment);
	DOMElement* AddDefinition(DOMElement*);
	void AddSubtest(DOMElement*, string, string, string);
	DOMElement* AddTest(DOMElement*);
	void AddTestedObject(DOMElement*, DOMElement*, string, string);
	void AddUnknownTest(string, string);
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* GetResultFile();
	void SetCriterionParentResult(DOMElement*, string, string);
	void SetResult(DOMElement*, string);

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void AddDefinitionData(DOMElement*, DOMElement*);
	void AddDefinitionObject(DOMElement*, DOMElement*);
	void AddGenerators(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
	void AddSystemInfo(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
	DOMElement* CopyElement(DOMElement*, bool useFamilyNS = false); 
	DOMElement* CreateNodeWithValue(DOMElement*, string, string);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *resultDocument; 
	string familyXMLNS;
	string familyXMLNSQualifier;
	string xsiSchemaLocation;
	string family;
};

//	Define a ProbeException
class OvalResultXmlException : public Exception
{
	public:;
		OvalResultXmlException(string errorMessageIn = "", int severity = ERROR_FATAL );
		~OvalResultXmlException();
};

#endif
