//
// $Id: OvalDataCollector.h,v 1.5 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  OvalDataCollector
//  author: Jon Baker	
//
//	This class acts as a base class for all data collectors. Doing so provides some common
//	functionality to all child classes and simplifies the creation of a new collector. 
//	Collectors are family specific. That is each time a new family is added to the OVAL
//	schema a new collector class should be created to support it. Each family specific
//	collector is responsible for making calls to the probes used to gather data for that
//	families tests. Look at the Run() method in the DataCollector class for guidance.
//
//****************************************************************************************//

#ifndef __OVALDATACOLLECTOR_H__
#define __OVALDATACOLLECTOR_H__

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <iostream>
#include <stdlib.h>

//	include common classes
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "REGEX.h"
#include "Version.h"
#include "XmlCommon.h"
#include "SystemInfoData.h"

//	Must include the base probe class
#include "Probe.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	define constants to represent os families
#define ERROR_OS_FAMILY -1
#define UNSUPPORTED_OS_FAMILY 0
#define REDHAT_OS_FAMILY 1
#define SOLARIS_OS_FAMILY 2
#define WINDOWS_OS_FAMILY 3
#define DEBIAN_OS_FAMILY 4
#define IOS_OS_FAMILY 5


class OvalDataCollector
{
public:
	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	virtual void Run() = 0;

protected:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	OvalDataCollector(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, string);
	virtual ~OvalDataCollector();
	
	// -----------------------------------------------------------------------
	//	Protected members
	// -----------------------------------------------------------------------
	int DetermineNodeFamily(DOMNode* node);
	void RunTest(Probe*, ProbeData*);
	void WriteGenerator();
	void WriteSystemInfo(Probe*);

	// -----------------------------------------------------------------------
	//	Protected data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDoc;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDoc;

};

class OvalDataCollectorException : public Exception
{
	public:

		OvalDataCollectorException(string errMsgIn = "", int severity = ERROR_FATAL);
		~OvalDataCollectorException();
};

#endif
