//
// $Id: RegistryEffectiveRightsProbe.h,v 1.4 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  RegistryEffectiveRightsProbe
//  author: Andrew Buttner
//			Jon Baker
//
//	Gathers registry data.
//
//****************************************************************************************//

#ifndef __REGISTRYEFFECTIVERIGHTSPROBE_H__
#define __REGISTRYEFFECTIVERIGHTSPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "RegistryEffectiveRightsData.h"

#include <aclapi.h>
#include <windows.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class RegistryEffectiveRightsProbe : public Probe
{
	public:

		~RegistryEffectiveRightsProbe();
		static Probe* Instance();
		pdVector Run(ProbeData*);
		
	private:
		RegistryEffectiveRightsProbe();
		string FixKey(string regkeyIn);
		RegistryEffectiveRightsData* GetEffectiveRights(string, string);
		RegistryEffectiveRightsData* GetRegistryKey(string, string, string);
		HKEY GetRootKey(string);
		void GetMatchingHives(string, sVector*);
		void GetMatchingKeys(string, string, string, sVector*);
		void GetMatchingNames(string, string, string, sVector*);	
		void KeyPatternMatch(string, string, sVector*);

		static RegistryEffectiveRightsProbe *instance;
};

class RegistryEffectiveRightsProbeException : public Exception
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
		RegistryEffectiveRightsProbeException(string errMsgIn = "", int severity = ERROR_FATAL);
		~RegistryEffectiveRightsProbeException();
};

#endif
