//
// $Id: FileProbe.h,v 1.6 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  FileProbe
//  author: Andrew Buttner
//			Jon Baker
//
//    Gathers information about specified files.
//
//****************************************************************************************//

#ifndef __FILEPROBE_H__
#define __FILEPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Exception.h"
#include "Common.h"
#include "Log.h"
#include "MD5.h"
#include "FileData.h"

#include <TCHAR.H>
#include <aclapi.h>
#include <imagehlp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <windows.h>

#include <iostream>
#include <string>
#include <vector>


using namespace std;


class FileProbe : public Probe
{
	public:
		~FileProbe();
		static Probe* Instance();
		pdVector Run(ProbeData*);

		static FileProbe *instance;

	private:
		FileProbe();
		sVector GetDrives();
		//void GetFileEffectiveRights(FileData*);
		FileData* GetFileAttributes(string);
		void GetFilePathsForPattern(string dirIn, string pattern, sVector *pathVector);
		sVector PathPatternMatch(string pattern);

};

class FileProbeException : public Exception
{
	public:
		FileProbeException(string errMsgIn = "", int severity = ERROR_FATAL);
		~FileProbeException();
};


#endif
