//
// $Id: SimpleTestAnalyzer.h,v 1.8 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	SimpleTestAnalyzer.h
//  author: Jon Baker	
//	
//****************************************************************************************//
#ifndef __SIMPLETESTANALYZER_H__
#define __SIMPLETESTANALYZER_H__


#include "Analyzer.h"
#include "REGEX.h"

using namespace std;

//****************************************************************************************//
//	Class : SimpleTestAnalyzer
//	The SimpleTestAnalyzer class extends the Analyzer class and will handle 
//	analyzing a definition
//****************************************************************************************//

class SimpleTestAnalyzer : Analyzer
{
public:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	~SimpleTestAnalyzer();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	static Analyzer* Instance();
	Result Run(DOMElement*);

private:
	// -----------------------------------------------------------------------
	//	Destructor
	// -----------------------------------------------------------------------
	SimpleTestAnalyzer();

	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	Result AnalyzeItem(DOMElement*, DOMElement*);
	string CombineComponents(DOMElement*);
	Result CompareData(DOMElement*, DOMElement*);
	Result CompareBinaryData(string, string, string);
	Result CompareFloatData(string, string, string);
	Result CompareIntData(string, string, string);
	Result ComparePropertyData(DOMElement*, DOMElement*);
	Result CompareStringData(string, string, string);
	Result CompareVersionData(DOMElement*, DOMElement*);
	bool CompareObjectElements(DOMElement*, DOMElement*, string comparisonType = "litteral");
	bool CompareObjectValues(string, string, string);
	DOMElement* GetLiteralItemMatch(DOMElement*, string);
	NodeVector GetRegexItemMatches(DOMElement*, string);
	string GetEnvironmentVariableValue(string);
	string GetRegistryKeyValue(string);
	NodeVector GetMatchingItemNodes(string, DOMElement*);
	void MapTestToItem(string*, string*, string);

/*
	void EvaluateSimpleTest(DOMNode*);



	int ComputeSimpleTestResult(DOMNode*, DOMNode*, string parentOp = "", bool useParentOp = false, string parentType = "", bool useParentType = false);
*/

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	static SimpleTestAnalyzer* instance;
	string currentTestId;
};

#endif
