//
// $Id: RegistryData.cpp,v 1.9 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "RegistryData.h"

// Initialize the item Vector
sVector RegistryData::items;

//****************************************************************************************//
//								RegistryData Class										  //	
//****************************************************************************************//
RegistryData::RegistryData(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RegistryData based on the node provided
	// -----------------------------------------------------------------------

	//	Validate the test node
	string testName = XmlCommon::GetElementName((DOMElement*)test);
	if(testName.compare("registry_test") != 0)
		throw ProbeDataException("Error: RegistryData() Invalid test node specified.");

	//	Init the data members 
	hive = new ObjectElement();
	key = new ObjectElement();
	name = new ObjectElement();
	type = new DataElement();
	value = new DataElement();

	//	Call the parse node function
	ParseNode(test);
}

RegistryData::RegistryData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new RegistryData as an empty object.
	// -----------------------------------------------------------------------

	//	Init the data members 
	hive = new ObjectElement();
	key = new ObjectElement();
	name = new ObjectElement();
	type = new DataElement();
	value = new DataElement();
}

RegistryData::~RegistryData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Delete data memebers
	// -----------------------------------------------------------------------

	delete hive;
	delete key;
	delete name;
	delete type;
	delete value;
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void RegistryData::Write()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Write a windows registry key data element to the data document.
	// -----------------------------------------------------------------------

	// Create a string representation of the item
	string item = hive->object + ":" + key->object + ":" + name->object;

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *registryItem = CreateNewItemNode(dataDocument, "registry_item");

	// Add the object element
	DOMElement *objectElm = XmlCommon::AddChildElement(dataDocument, registryItem, "object");

	// Add the status attribute to the object if not default value
	string strStatus = this->SwitchStatusType(this->objectStatus);
	if (strStatus.compare("exists") != 0)
		XmlCommon::AddAttribute(objectElm, "status", strStatus);

	//	Add the hive element - as a string
	AddObjectChildElement(dataDocument, objectElm, "hive", this->hive);

	//	Add the key element - as a string
	AddObjectChildElement(dataDocument, objectElm, "key", this->key);
	
	//	Add the name element - as a string
	AddObjectChildElement(dataDocument, objectElm, "name", this->name);

	// Add the data section if the object status is exists
	if(objectStatus == exists && !this->isPatternMatchObject) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, registryItem, "data");

		// Add data subelements
		AddDataChildElement(dataDocument, dataElm, "type", this->type);
		AddDataChildElement(dataDocument, dataElm, "value", this->value);
	}

	// Add the new item to the data document
	InsertItem(dataDocument, registryItem, "registry_items");
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void RegistryData::ParseNode(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to popular this RegistryData
	//	
	// -----------------------------------------------------------------------

	// Retreive the test id from the DOMNode.
	testId = XmlCommon::GetAttributeByName(test, "id");
	if (testId.compare("") == 0) {
		throw ProbeDataException("Error: Unable to find the 'id' attribute for specified the test.");
	}

	///////////////////////////////////////////////////////////////////////////
	//	Parse the node
	///////////////////////////////////////////////////////////////////////////
	// Get the object element
	DOMNode *object = XmlCommon::FindNodeNS(test, "object");
	if (object == NULL) {
		throw new ProbeDataException("Error: Unable to locate object section for test: " + testId + "\n");

	}

	// Loop over childern of the object node
	//	get a list of the child nodes and their values
	string childName	= "";
	string childValue	= "";
	string childOp		= "";
	

	DOMNodeList *objectChildren = object->getChildNodes();
	unsigned int index = 0;
	while(index < objectChildren->getLength())
	{
		DOMNode *objectChild = objectChildren->item(index);

		//	only concerned with ELEMENT_NODEs
		if (objectChild->getNodeType() == DOMNode::ELEMENT_NODE)
		{
			//	get the name of the child
			childName = XmlCommon::GetElementName((DOMElement*)objectChild);
			childValue = XmlCommon::GetDataNodeValue(objectChild);
			childOp = XmlCommon::GetAttributeByName(objectChild, "operator");
			
			// Convert the type
			objectTypes curType;
			if(childOp.compare("pattern match") == 0){
				curType = pattern_match;
				this->isPatternMatchObject = true;
			} else {
				curType = literal;
			}

			//	Get the hive value	
			if(childName.compare("hive")==0) {

				hive->object = childValue;
				hive->type = curType;
				
			//	Get the key value
			}else if(childName.compare("key")==0) {

				key->object = childValue;
				key->type = curType;
			
			//	Get the name value
			}else if(childName.compare("name")==0) {

				name->object = childValue;
				name->type = curType;
			}
		}

		index ++;
	}
}
	