//
// $Id: DataCollector.h,v 1.4 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  DataCollector
//  author: Jon Baker	
//
//	This class is the data collector for Red Hat. It extends OvalDataCollector
//****************************************************************************************//

#ifndef __DATACOLLECTOR_H__
#define __DATACOLLECTOR_H__

#include <unistd.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <vector>

//	include the parent class.
#include "OvalDataCollector.h"

//	include the probe classes
#include "FileProbe.h"
#include "InetListeningServersProbe.h"
#include "ProcessProbe.h"
#include "RPMInfoProbe.h"
#include "RPMVersionCompareProbe.h"
#include "UnameProbe.h"
#include "SystemInfoProbe.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

class DataCollector : public OvalDataCollector
{
 public:
  // -----------------------------------------------------------------------
  //	Constructors & Destructors
  // -----------------------------------------------------------------------
  DataCollector(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *oval, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *data);
  ~DataCollector();

  // -----------------------------------------------------------------------
  //	Public members
  // -----------------------------------------------------------------------
  void Run();
};

#endif
