//
// $Id: UnknownTestAnalyzer.cpp,v 1.7 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "UnknownTestAnalyzer.h"

//****************************************************************************************//
//							UnknownTestAnalyzer Class									  //	
//****************************************************************************************//
UnknownTestAnalyzer *UnknownTestAnalyzer::instance = NULL;

UnknownTestAnalyzer::UnknownTestAnalyzer() : Analyzer()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	
	// -----------------------------------------------------------------------

}

UnknownTestAnalyzer::~UnknownTestAnalyzer()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//
	// -----------------------------------------------------------------------
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Public Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
Analyzer* UnknownTestAnalyzer::Instance()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Force this class to be a singleton. Return an Instance of the 
	//	DefiitionAnalyzer
	//
	// -----------------------------------------------------------------------

	if(instance == NULL)
		instance = new UnknownTestAnalyzer();

	return instance;
}

Result UnknownTestAnalyzer::Run(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Just add the the unknown test to the result document and return 
	//	unknown_result as the result
	// -----------------------------------------------------------------------

	// Get the test id
	string testId = XmlCommon::GetAttributeByName(test, "id");

	// debug output
	//Log::WriteLog("\t"+testId);
	// end debug output

	// Check if the test has already been processed.
	if(!Processed(testId)) {

		// Get the comment
		string comment = XmlCommon::GetAttributeByName(test, "comment");	

		// Add the test to the result doc	
		resultWriter->AddUnknownTest(testId, comment);

		// Store the test id and result
		Store(testId, unknown_result);
	}	

	return unknown_result;
}
