//
// $Id: Common.h,v 4.7 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:	Common
//  author:	Jon Baker
//
//  Functions that are common to many probe classes.,
//	Also used by main() for handling runtime configuration.
//
//****************************************************************************************//

#ifndef __COMMON_H__
#define __COMMON_H__

#ifdef WIN32
	#pragma warning(disable:4786)
	#include <aclapi.h>
	#include <windows.h>
#endif

#include "Log.h"
#include "Exception.h"

#include <iostream>
#include <string>
#include <vector>
#include <time.h>
#include <sstream>
#include <algorithm>

#ifdef WIN32
	
#else

#endif


using namespace std;

//	Define a vector for holding strings
typedef vector < string, allocator<string> > sVector;

class Common
{
	public:
		static string   GetFamilyType();
		static string   GetClassType();
		static string	GetStatusType();
		static string	GetDatafile();
		static bool		GetGenerateMD5();
		static string	GetMappingfile();
		static string	GetXMLfile();
		static string	GetXMLfileMD5();
		static string	GetOutputFilename();
		static bool		GetOutputToFile();
		static bool		GetSaveData();
		static string	GetStartTime();
		static bool		GetUseConfiguration();
		static bool		GetUseProvidedData();
		static bool		GetUseVariableFile();
		static bool		GetValidateXMLSchemas();
		static string	GetVariableFilename();
		static bool		GetVerifyXMLfile();

		static bool		CompareStatusType(string);
		static bool		CompareFamilyType(string);
		static bool		CompareClassType(string);
		
		static void		SetFamilyType(string);
		static void     SetClassType(string);
		static void 	SetStatusType(string);
		static void		SetDataFile(string);
		static void		SetGenerateMD5(bool);
		static void		SetMappingFile(string);
		static void		SetXMLfile(string);
		static void		SetXMLfileMD5(string);
		static void		SetOutputFilename(string);
		static void		SetOutputToFile(bool);
		static void		SetSaveData(bool);
		static void		SetStartTime(string);
		static void		SetUseConfiguration(bool);
		static void		SetUseProvidedData(bool);
		static void		SetUseVariableFile(bool);
		static void		SetValidateXMLSchemas(bool);
		static void		SetVariableFilename(string);
		static void		SetVerifyXMLfile(bool);

#ifdef WIN32
		static bool DisableAllPrivileges();
		static bool EnablePrivilege(string);
		static bool GetTextualSid(PSID, LPTSTR*);
#endif
		static string	GetEnviromentVariable(string);
		static string	PadString(string, unsigned int);
		static string	SwitchChar(string stringIn, string oldChr, string newChr);
		static string	ToString(int);
		static string	ToString(long);
		static string	ToString(unsigned long);

		static string	GetTimeStamp();

	private:
		static string familyType;
		static string classType;
		static string statusType;
		static string dataFile;
		static string mappingFile;
		static string outputFilename;
		static string startTime;
		static string variablesFilename;
		static string xmlfile;
		static string xmlfileMD5;
		static bool	generateMD5;
		static bool outputToFile;
		static bool saveData;
		static bool useConfiguration;
		static bool useProvidedData;
		static bool useVariableFile;
		static bool validateXMLSchemas;
		static bool verifyXMLfile;
		static string statusTypes[6];
		static sVector statusVector;
};


class CommonException : public Exception
{
	public:
		CommonException(string errMsgIn = "", int severity = ERROR_FATAL);
		~CommonException();
};


#endif
