// $Id: FileData.h,v 1.7 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	FileData.h
//  author: Jon Baker	
//
//	This class will store all data for a windows file. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#ifndef __FILEDATA_H__
#define __FILEDATA_H__

#include "ProbeData.h"
#include "EnvironmentVariableData.h"
#include "EnvironmentVariableProbe.h"


//	Must include the registry probe to allow a file test to get a registry value 
//	and create a filepath.
#include "RegistryProbe.h"

using namespace std;

class FileData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	FileData(DOMElement *test);
	FileData();
	~FileData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write();
	nvpVector* GetPathVector();

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------	
	ObjectElement *path;
	DataElement *owner;
	DataElement *size;
	DataElement *a_time;
	DataElement *c_time;
	DataElement *development_class;
	DataElement *m_time;
	DataElement *ms_checksum;
	DataElement *md5;
	DataElement *majVer;
	DataElement *minVer;
	DataElement *buildVer;
	DataElement *priVer;
	DataElement *type;
/*	
	DataElement *trustee_name;
	DataElement *trustee_domain;
	DataElement *trustee_sid;
	DataElement *acl_type;
	DataElement *standard_delete;
	DataElement *standard_read_control;
	DataElement *standard_write_dac;
	DataElement *standard_write_owner;
	DataElement *standard_synchronize;
	DataElement *access_system_security;
	DataElement *generic_read;
	DataElement *generic_write;
	DataElement *generic_execute;
	DataElement *generic_all;
	DataElement *file_read_data;
	DataElement *file_write_data;
	DataElement *file_append_data;
	DataElement *file_read_ea;
	DataElement *file_write_ea;
	DataElement *file_execute;
	DataElement *file_delete_child;
	DataElement *file_read_attributes;
	DataElement *file_write_attributes;
*/

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMElement *test);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	// Store a string representation of each item collected
	static sVector items;
};

#endif