//
// $Id: VariableCollector.h,v 1.2 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  VariableCollector
//  author: Jon Baker	
//  date:   22 June 2004
//
//	This class is responsible for the collecting variable values from the specified
//	variables file and setting those values in teh oval definitions that reference them.
//
//****************************************************************************************//

#ifndef __VARIABLECOLLECTOR_H__
#define __VARIABLECOLLECTOR_H__


//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>

#include "Common.h"
#include "Exception.h"
#include "DOMCommon.h"
#include "DOMProcessor.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;


class VariableCollector  
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	VariableCollector(DOMProcessor*, string, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*);
	virtual ~VariableCollector();
	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Run();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void GetVariableValue(string, string*, string*);
	void ProcessTest(DOMElement*);
	void SetValue(DOMElement*, string, string);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDocument; 
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *variableDocument; 
};

//	Define an Exception class
class VariableCollectorException : public Exception
{
	public:

		VariableCollectorException();
		VariableCollectorException(string errorMessageIn);
		~VariableCollectorException();
};

#endif
