//
// $Id: Log.cpp,v 4.1 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "Log.h"

// Initialize static variables.

bool Log::verboseMode = false;
string Log::logFilename = "oval.log";

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  Public Members  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//

bool Log::ClearLogFile()
{
	//------------------------------------------------------------------------------------//
	//
	//  ABSTRACT
	//
	//  This function clears the existing log file.  Only return false if an existing
	//  file can not be deleted.
	//
	//------------------------------------------------------------------------------------//

	FILE* fp = NULL;
	fp = fopen(logFilename.c_str(), "w+"); 
	if (fp != NULL)
	{
		fclose(fp);
		return true;

	}

	return false;
}

void Log::WriteLog(string logMessageIn)
{
	//------------------------------------------------------------------------------------//
	//
	//  ABSTRACT
	//
	//  Writes the given message to the log file
	//
	//  The log file is opened using fopen with a mode of "a+".  This opens the file for
	//  reading and appending.  The appending operation includes the removal of the EOF
	//  marker before new data is written to the file and the EOF marker is restored after
	//  writing is complete.  The file is created first if it doesnt exist.
	//
	//  If an error occurs, ignore it.  Just means that the error message will not get
	//  written to the log file.
	//
	//------------------------------------------------------------------------------------//

	FILE* fp = NULL;

	fp = fopen(logFilename.c_str(), "a+");
	if (fp != NULL)
	{
		fputs(logMessageIn.c_str(), fp);
		fclose(fp);
	}
}
