//
// $Id: WMIProbe.h,v 1.2 2005/09/19 22:39:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  WMIProbe
//  author: Charles Schmidt
//
//	Gathers WMI data.  Need to link to Wldap32.lib and Netapi32.lib
//
//****************************************************************************************//

#ifndef __WMIPROBE_H__
#define __WMIPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "WMIData.h"

/***********************************************************************/
// The followin include statment is needed for the code in this probe to
// work. However, comdef.h includes comdefsp.h which utilizes a DOMDocument.
// This application uses Xerces for xml parsing. Xerces defines a DOMDocument
// This application also uses windows apis which include references to MsXml.h
// MsXml.h defines a DOMDocument as well. Either Microsoft or Xerces is not 
// correctly qualifying thier classes. this causes the following error message:
/*
c:\Program Files\Microsoft Visual Studio .NET 2003\Vc7\include\comdefsp.h(1305) : error C2872: 'DOMDocument' : ambiguous symbol
        could be 'c:\Program Files\Microsoft Visual Studio .NET 2003\Vc7\PlatformSDK\Include\MsXml.h(161) : DOMDocument'
        or       'c:\xerces-c_2_6_0-windows_nt-msvc_60\include\xercesc\dom\DOMDocument.hpp(63) : xercesc_2_6::DOMDocument'
*/
// The only solution icould come up with is to edit comdefsp.h. By simply 
// commenting out line 1305 I am able to compile and run the aplication. 
// the line to comment looks like:
// _COM_SMARTPTR_TYPEDEF(DOMDocument, __uuidof(DOMDocument));
//
// If you come up with a better solution please let me know. Send email to
// oval@mitre.org
//
/***********************************************************************/
#include <comdef.h>
#include <Dsgetdc.h>
#include <Lm.h>
#include <Wbemidl.h>
#include <windows.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class WMIProbe : public Probe
{
	public:
		~WMIProbe();
		static Probe* Instance();
		pdVector Run(ProbeData*);
		
	private:
		WMIProbe();
		pdVector GetWMI(string, string);
		bool GetWqlField(string, string*);
		
		static WMIProbe *instance;
};

class WMIProbeException : public Exception
{
	public:
		WMIProbeException(string errMsgIn = "", int severity = ERROR_FATAL);
		~WMIProbeException();
};

#endif
