//
// $Id: ActiveDirectoryProbe.h,v 1.7 2005/08/30 19:02:22 abuttner Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  ActiveDirectoryProbe
//  author: Andrew Buttner
//
//	Gathers acitve directory data.  Need to link to Wldap32.lib and Netapi32.lib
//
//****************************************************************************************//

#ifndef __ACTIVEDIRECTORYPROBE_H__
#define __ACTIVEDIRECTORYPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Common.h"
#include "Exception.h"
#include "Log.h"
#include "ActiveDirectoryData.h"

#include <Dsgetdc.h>
#include <Lm.h>
#include <windows.h>
#include <Winldap.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class ActiveDirectoryProbe : public Probe
{
	public:
		~ActiveDirectoryProbe();
		static Probe* Instance();
		pdVector Run(ProbeData*);
		
	private:
		ActiveDirectoryProbe();
		ActiveDirectoryData* GetActiveDirectory(string, string, string);
		string BuildDistinguishedName(string, string);
		void DnPatternMatch(string, string, sVector*);
		void GatherAuthentication();
		string GetDomainComponents();
		void GetMatchingAttributes(string, string, string, sVector*);
		void GetMatchingDistinguishedNames(string, string, string, sVector*);
		void GetMatchingNamingContext(string, sVector*);
		string RemoveDnBase(string, string);

		static ActiveDirectoryProbe *instance;

		static string ldap_user;
		static string ldap_password;
};

class ActiveDirectoryProbeException : public Exception
{
	public:
		ActiveDirectoryProbeException(string errMsgIn = "", int severity = ERROR_FATAL);
		~ActiveDirectoryProbeException();
};

#endif
