//
// $Id: UnameData.cpp,v 1.11 2005/07/12 18:17:59 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
#include "UnameData.h"

//****************************************************************************************//
//								UnameData Class											  //	
//****************************************************************************************//
// Initialize the item Vector
sVector UnameData::items;

UnameData::UnameData(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new UnameData and populate with the node's data
	// -----------------------------------------------------------------------

	//	Validate the test node
	string testName = XmlCommon::GetElementName(test);
	if(testName.compare("uname_test") != 0)
		throw ProbeDataException("Error: UnameData() Invalid test node specified. Received: " + testName);

	//	Init the data members
	machine_class = new DataElement();
	node_name = new DataElement();
	os_name = new DataElement();
	os_release = new DataElement();
	processor_type = new DataElement();

	//	Call the parse node function
	ParseNode(test);

	// set the xmlns and schema location
	this->SetXmlnsAlias("unix");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#unix");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#unix unix-system-characteristics-schema.xsd");
}

UnameData::UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new UnameData as an empty object.
	// -----------------------------------------------------------------------
	machine_class = new DataElement();
	node_name = new DataElement();
	os_name = new DataElement();
	os_release = new DataElement();
	os_version = new DataElement();
	processor_type = new DataElement();

	// set the xmlns and schema location
	this->SetXmlnsAlias("unix");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#unix");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#unix unix-system-characteristics-schema.xsd");
}

UnameData::~UnameData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------

	delete machine_class;
	delete node_name;
	delete os_name;
	delete os_release;
	delete os_version;
	delete processor_type;
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//

void UnameData::Write()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Create a new uname node and add it 
  //	to the dataDocument.
  //	
  // -----------------------------------------------------------------------

	// Because uname tests do not have an Object 
	// i have hard coded the value of the item string.
	// This is normally used to ensure taht only unique items are written tothe sc file
	// in this case only one item should ever be written
  	// Create a string representation of the item
	string item = "uname_written";

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *unameItem = CreateNewItemNode(dataDocument, "uname_item");

	// Add the data section if the object status is exists
	if(objectStatus == exists) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, unameItem, "data");

		// Add data subelements
		AddDataChildElement(dataDocument, dataElm, "machine_class", this->machine_class);
		AddDataChildElement(dataDocument, dataElm, "node_name", this->node_name);
		AddDataChildElement(dataDocument, dataElm, "os_name", this->os_name);
		AddDataChildElement(dataDocument, dataElm, "os_release", this->os_release);
		AddDataChildElement(dataDocument, dataElm, "os_version", this->os_version);
		AddDataChildElement(dataDocument, dataElm, "processor_type", this->processor_type);
	}

	// Add the new item to the data document
	InsertItem(dataDocument, unameItem, "uname_items");
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void UnameData::ParseNode(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse the node gathering all data to popular this UnameData
	//	Really just need to gather the Test id.
	// -----------------------------------------------------------------------

	///////////////////////////////////////////////////////////////////////////
	//	Get the test id
	///////////////////////////////////////////////////////////////////////////
	testId = XmlCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a uname test.");
}
