//
// $Id: RPMVersionCompareProbe.h,v 1.7 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  RPMVersionCompareProbe
//  author: Jay Beale & Jon Baker
//
//  Compares an RPM epoch, version and release to the RPM installed on the 
//  system, to determine whether that RPM must be updated ("patched").
//
//****************************************************************************************//

#ifndef __RPMVERSIONCOMPAREPROBE_H__
#define __RPMVERSIONCOMPAREPROBE_H__

#include "Probe.h"

// Include probe data class
#include "RPMVersionCompareData.h"

#include <rpm/rpmlib.h>
#include <rpm/rpmio.h>
#include <rpm/rpmdb.h>
#include <rpm/rpmts.h>
#include <strings.h>

#include <iostream>
#include <string>

using namespace std;

class RPMVersionCompareProbe : public Probe
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	~RPMVersionCompareProbe();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	pdVector Run(ProbeData*);
	static Probe* Instance();

private:
	// -----------------------------------------------------------------------
	//	Private mambers
	// -----------------------------------------------------------------------
	RPMVersionCompareProbe();
	void CompareRPMtoGood(RPMVersionCompareData*, pdVector*);
	void CompareRPMtoGoodPatternMatch(RPMVersionCompareData*, pdVector*);
	int sense(char *installed_epoch,char *installed_version,
	char *installed_release,
	const char *epoch, const char *version, const char *release);
	char *readHeaderString(Header header,int_32 tag_id);
	int_32 readHeaderInt32(Header header,int_32 tag_id);

	static RPMVersionCompareProbe *instance;
};

#endif
