//
// $Id: ProcessProbe.h,v 1.5 2005/03/28 15:59:42 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//  class:  ProcessProbe
//  author: Jonathan Baker
//          Andrew Buttner
//          Michael Michnikov
//
//  Gathers process data.
//
//****************************************************************************************//

#ifndef _PROCESSPROBE_H_
#define _PROCESSPROBE_H_

#include "Probe.h"

// Include the data class
#include "ProcessData.h"

#include <strings.h>
#include <dirent.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <iostream>
#include <string>

// Define some buffer lengths
#define CMDLINE_LEN 1024
#define SCHED_CLASS_LEN 128
#define TTY_LEN PATH_MAX

using namespace std;

class ProcessProbe : public Probe
{
 public:
  
  ~ProcessProbe();
  pdVector Run(ProbeData *);
  static Probe* Instance();
  
 private:
  ProcessProbe();

  void GetPSInfo(ProcessData *, pdVector*);
  int RetrieveCommandLine(char *process, char *cmdline, string *errMsg);
  int RetrieveStatFile(char *process, int *uid, int *pid, int *ppid, long *priority, unsigned long *starttime, string *errMsg);
  void RetrieveTTY(char *process, char *ttyName);
  int RetrieveUptime(unsigned long *uptime, string *errMsg);

  static ProcessProbe *instance;
};

#endif
