//
// $Id: InetListeningServersData.cpp,v 1.14 2005/08/10 17:06:39 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "InetListeningServersData.h"

//****************************************************************************************//
//						InetListeningServersData Class									  //	
//****************************************************************************************//
// Initialize the item Vector
sVector InetListeningServersData::items;

InetListeningServersData::InetListeningServersData(DOMElement *test)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData and populate 
  //	with the node's data
  // -----------------------------------------------------------------------

	string testName = XmlCommon::GetElementName(test);
	if(testName.compare("inetlisteningservers_test") != 0) {
		 throw ProbeDataException("Error: InetListeningServersData() Invalid test node specified. Received: " + testName);
    }

	//	Init the data members
	program_name = new ObjectElement();
	local_full_address = new DataElement();
	local_address = new DataElement();
	local_port = new DataElement();
	foreign_full_address = new DataElement();
	foreign_address = new DataElement();
	foreign_port = new DataElement();
	user_id = new DataElement();
	pid = new DataElement();
	protocol = new DataElement();

	//	Call the parse node function
	ParseNode(test);

	// set the xmlns and schema location
	this->SetXmlnsAlias("redhat");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#redhat");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#redhat redhat-system-characteristics-schema.xsd");
}

InetListeningServersData::InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Initialize a new InetListeningServersData as an empty object.
  // -----------------------------------------------------------------------

	//	Init the data members
	program_name = new ObjectElement();
	local_full_address = new DataElement();
	local_address = new DataElement();
	local_port = new DataElement();
	foreign_full_address = new DataElement();
	foreign_address = new DataElement();
	foreign_port = new DataElement();
	user_id = new DataElement();
	pid = new DataElement();
	protocol = new DataElement();

	// set the xmlns and schema location
	this->SetXmlnsAlias("redhat");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#redhat");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#redhat redhat-system-characteristics-schema.xsd");
}

InetListeningServersData::~InetListeningServersData()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Delete data members
  // -----------------------------------------------------------------------

	delete program_name;
	delete local_full_address;
	delete local_address;
	delete local_port;
	delete foreign_full_address;
	delete foreign_address;
	delete foreign_port;
	delete user_id;
	delete pid;
	delete protocol;

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void InetListeningServersData::Write()
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Create a new inetlisteningservers_test node and add it 
  //	to the dataDocument.
  //	
  // -----------------------------------------------------------------------

  	// Create a string representation of the item
	string item = program_name->object;

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *inetlisteningserverItem = CreateNewItemNode(dataDocument, "inetlisteningserver_item");

	// Add the object element
	DOMElement *objectElm = XmlCommon::AddChildElement(dataDocument, inetlisteningserverItem, "object");

	// Add the status attribute to the object if not default value
	string strStatus = this->SwitchStatusType(this->objectStatus);
	if (strStatus.compare("exists") != 0)
		XmlCommon::AddAttribute(objectElm, "status", strStatus);

	//	Add the program_name element
	AddObjectChildElement(dataDocument, objectElm, "program_name", program_name);		

	// Add the data section if the object status is exists
	if(objectStatus == exists && !this->isPatternMatchObject) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, inetlisteningserverItem, "data");

		// Add data subelements
		AddDataChildElement(dataDocument, dataElm, "local_address", this->local_address);
		AddDataChildElement(dataDocument, dataElm, "local_full_address", this->local_full_address);
		AddDataChildElement(dataDocument, dataElm, "local_port", this->local_port);
		AddDataChildElement(dataDocument, dataElm, "foreign_address", this->foreign_address);
		AddDataChildElement(dataDocument, dataElm, "foreign_full_address", this->foreign_full_address);
		AddDataChildElement(dataDocument, dataElm, "foreign_port", this->foreign_port);
		AddDataChildElement(dataDocument, dataElm, "pid", this->pid);
		AddDataChildElement(dataDocument, dataElm, "protocol", this->protocol);
		AddDataChildElement(dataDocument, dataElm, "user_id", this->user_id);
	}

	// Add the new item to the data document
	InsertItem(dataDocument, inetlisteningserverItem, "inetlisteningserver_items");
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void InetListeningServersData::ParseNode(DOMElement *test)
{
  // -----------------------------------------------------------------------
  //	Abstract
  //
  //	Parse the node gathering all data to populate this
  //	InetListeningServersData object. 
  //	Really just need to gather the Test id and the program name
  // -----------------------------------------------------------------------

	///////////////////////////////////////////////////////////////////////////
	//	Get the test id
	///////////////////////////////////////////////////////////////////////////
	testId = XmlCommon::GetAttributeByName(test, "id");
	if(testId.compare("") == 0)
		throw ProbeDataException("Error: Unable to find the 'id' attribute for a Red Hat InetListeningServers test.");	

  	///////////////////////////////////////////////////////////////////////////
	//	Parse the node
	///////////////////////////////////////////////////////////////////////////
	// Get the object element
	DOMElement *object = XmlCommon::FindNodeNS(test, "object");
	if (object == NULL) {
		throw new ProbeDataException("Error: Unable to locate object section for test: " + testId + "\n");
	}

	// Loop over childern of the object node
	//	get a list of the child nodes and their values
	string childName	= "";
	string childValue	= "";
	string childOp		= "";

	DOMNodeList *objectChildren = object->getChildNodes();
	unsigned int index = 0;
	while(index < objectChildren->getLength()) {
		DOMNode *tmpNode = objectChildren->item(index);

		//	only concerned with ELEMENT_NODEs
		if (tmpNode->getNodeType() == DOMNode::ELEMENT_NODE) {
			DOMElement* objectChild = (DOMElement*)tmpNode;

			//	get the name of the child
			childName = XmlCommon::GetElementName(objectChild);
			childValue = XmlCommon::GetDataNodeValue(objectChild);
			childOp = XmlCommon::GetAttributeByName(objectChild, "operator");
			
			// Convert the type
			objectTypes curType;
			if(childOp.compare("pattern match") == 0) {
				curType = pattern_match;
				this->isPatternMatchObject = true;
			} else {
				curType = literal;
			}
			
			//	Get the program name value	
			if(childName.compare("program_name") == 0) {

				program_name->object = childValue;
				program_name->type = curType;
			}
		}
		index ++;
	}
}
