//
// $Id: SystemInfoData.h,v 1.6 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:	SystemInfoData
//  author: Jon Baker	
//
//	This class will store all data needed in the system_info element of the 
//	System Characteristics file
//
//****************************************************************************************//

#ifndef __SYSTEMINFODATA_H__
#define __SYSTEMINFODATA_H__

#include "ProbeData.h"

using namespace std;

//	A class for storing interface information
class IfData 
{

	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	IfData(){};
	~IfData(){};
	IfData(string ifn, string ipAddr, string macAddr) : ifName(ifn), ipAddress(ipAddr), macAddress(macAddr) {}

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------
	string ifName;
	string ipAddress;
	string macAddress;
};

//	Define a vector for storing IfData objects
typedef vector < IfData*, allocator<IfData*> > ifVector;

class SystemInfoData : public ProbeData
{
	public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
		SystemInfoData();
		~SystemInfoData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
		void Write();
		
	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------

		string os_name;
		string os_version;
		string architecture;
		string primary_host_name;
		ifVector interfaces;

	private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
		void ParseNode(DOMElement *test){throw new ProbeDataException("Error: ParseNode is not implmented for the SystemInfoData class.");};
};

#endif

