//
// $Id: EnvironmentVariableData.cpp,v 1.4 2005/07/12 17:33:29 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "EnvironmentVariableData.h"

// Initialize the item Vector
sVector EnvironmentVariableData::items;

//****************************************************************************************//
//								EnvironmentVariableData Class							  //	
//****************************************************************************************//
EnvironmentVariableData::EnvironmentVariableData(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new EnvironmentVariableData and populate with the node's data
	// -----------------------------------------------------------------------

	//	Validate the test node
	string testName = XmlCommon::GetElementName((DOMElement*)test);
	if(testName.compare("metabase_test") != 0)
		throw ProbeDataException("Error: EnvironmentVariableData() Invalid test node specified.");


	//	Init the data members
	name = new ObjectElement();
	value = new DataElement();

	//	Call the parse node function
	ParseNode(test);

	// set the xmlns and schema location
	this->SetXmlnsAlias("windows");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#windows");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#windows windows-system-characteristics-schema.xsd");
}

EnvironmentVariableData::EnvironmentVariableData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new EnvironmentVariableData as an empty object with 
	//	default values
	// -----------------------------------------------------------------------
	name = new ObjectElement();
	value = new DataElement();

	// set the xmlns and schema location
	this->SetXmlnsAlias("windows");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#windows");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#windows windows-system-characteristics-schema.xsd");
}


EnvironmentVariableData::~EnvironmentVariableData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Do nothing for now
	// -----------------------------------------------------------------------
	delete name;
	delete value;

}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void EnvironmentVariableData::Write()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new metabase_test node and add it to the dataDocument.
	//	
	// -----------------------------------------------------------------------

	// Create a string representation of the item
	string item = name->object;

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *environmentvariableItem = CreateNewItemNode(dataDocument, "environmentvariable_item");

	// Add the object element
	DOMElement *objectElm = XmlCommon::AddChildElement(dataDocument, environmentvariableItem, "object");

	// Add the status attribute to the object if not default value
	string strStatus = this->SwitchStatusType(this->objectStatus);
	if (strStatus.compare("exists") != 0)
		XmlCommon::AddAttribute(objectElm, "status", strStatus);

	//	Add the value element
	AddObjectChildElement(dataDocument, objectElm, "name", this->name);


	// Add the data section if the object status is exists
	if(objectStatus == exists) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, environmentvariableItem, "data");

		// Add data subelements
	
		AddDataChildElement(dataDocument, dataElm, "value", this->value);
	}

	// Add the new item to the data document
	InsertItem(dataDocument, environmentvariableItem, "environmentvariable_items");
}

