//
// $Id: AbsXmlFileContentData.cpp,v 1.2 2005/07/12 17:33:48 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "AbsXmlFileContentData.h"

// Initialize the item Vector
sVector AbsXmlFileContentData::items;

//****************************************************************************************//
//								FileData Class											  //	
//****************************************************************************************//
AbsXmlFileContentData::AbsXmlFileContentData(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new AbsXmlFileContentData and populate with the node's data
	// -----------------------------------------------------------------------
	string testName;

	//	Validate the test node
	testName = XmlCommon::GetElementName((DOMElement*)test);
	if(testName.compare("xmlfilecontent_test") != 0)
		throw ProbeDataException("Error: AbsXmlFileContentData() Invalid test node specified.");
	
	//	Init the data members
	path = new ObjectElement();
	xpath = new ObjectElement();
	valueOf = new DataElement();

	// set the xmlns and schema location
	this->SetXmlnsAlias("independent");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#independent");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#independent independent-system-characteristics-schema.xsd");
}

AbsXmlFileContentData::AbsXmlFileContentData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new AbsXmlFileContentData as an empty object.
	// -----------------------------------------------------------------------
	
	//	Init the data members
	path = new ObjectElement();
	xpath = new ObjectElement();
	valueOf = new DataElement();

	// set the xmlns and schema location
	this->SetXmlnsAlias("independent");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#independent");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/oval#independent independent-system-characteristics-schema.xsd");
}

AbsXmlFileContentData::~AbsXmlFileContentData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Delete data members
	// -----------------------------------------------------------------------

	delete path;
	delete xpath;
	delete valueOf;
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void AbsXmlFileContentData::Write()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new xmlfilecontent_test node and add it to the dataDocumentument.
	//	
	// -----------------------------------------------------------------------

	// Create a string representation of the item
	string item = path->object;

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *xmlFileContentItem = CreateNewItemNode(dataDocument, "xmlfilecontent_item");

	// Add the object element
	DOMElement *objectElm = XmlCommon::AddChildElement(dataDocument, xmlFileContentItem, "object");

	// Add the status attribute to the object if not default value
	string strStatus = this->SwitchStatusType(this->objectStatus);
	if (strStatus.compare("exists") != 0)
		XmlCommon::AddAttribute(objectElm, "status", strStatus);

	//	Add the path element
	AddObjectChildElement(dataDocument, objectElm, "path", this->path);
	// Add the xpath element
	AddObjectChildElement(dataDocument, objectElm, "xpath", this->xpath);
		
	// Add the data section if the object status is exists
	if(objectStatus == exists && !this->isPatternMatchObject) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, xmlFileContentItem, "data");

		// Add data subelements
		AddDataChildElement(dataDocument, dataElm, "value_of", this->valueOf);
	}

	// Add the new item to the data document
	InsertItem(dataDocument, xmlFileContentItem, "xmlfilecontent_items");
}
