//
// $Id: XmlCommon.h,v 1.8 2005/08/05 20:19:16 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	XmlCommon.h
//  author: Jon Baker	
//
//	This file contains common functions used by the Xml* classes
//****************************************************************************************//

#ifndef __XMLCOMMON_H__
#define __XMLCOMMON_H__

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>


//	other includes
#include <string>
#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <vector>

#include "Exception.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

//	A vector used to store pointers to DOMNodes
typedef vector < DOMElement*, allocator<DOMElement*> > ElementVector;

// -----------------------------------------------------------------------
//	NVP class
//	A simple class to hold an element and its coresponding value.
//	The Two data items are stored as strings
// -----------------------------------------------------------------------	

class NameValuePair
{
	public:
		NameValuePair::NameValuePair(){}
		NameValuePair(string n, string v) : elName(n), elValue(v) {}

		string elName;
		string elValue;
};

typedef vector < NameValuePair*, allocator<NameValuePair*> > nvpVector;

class XmlCommon
{
public:

	// -----------------------------------------------------------------------
    //  Public Members
    // -----------------------------------------------------------------------
	static void AddAttribute(DOMElement*, string, string); 
	static DOMElement* AddChildElement(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, DOMElement*, string, string nodeValue = "");
	static DOMElement* CreateElement(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument*, string, string nodeValue = "");
	static ElementVector* FindAllNodes(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *node, string nodeName, string attribute = "", string attValue = "", string xmlns = "*");
	static DOMElement* FindNode(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc, string nodeName, string attribute = "", string attValue ="");
	static DOMElement* FindNode(DOMElement *node, string nodeName, string attribute = "", string attValue ="");
	static DOMElement* FindNodeNS(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *doc, string nodeName, string attribute = "", string attValue ="", string xmlns = "*");
	static DOMElement* FindNodeNS(DOMElement *node, string nodeName, string attribute = "", string attValue ="", string xmlns = "*");
	static DOMElement* FindNodeByAttribute(DOMElement *node, string attribute, string attValue);
	static string GetAttributeByName(DOMElement*, string);
	static string GetDataNodeValue(DOMElement*);
	static string GetElementName(DOMElement*);
	static string GetElementPrefix(DOMElement*);
	static bool HasChildElements(DOMNode*);
	static void RemovetAttributeByName(DOMElement*, string);
	static string ToString(const XMLCh*);
	//static void SplitnNSPrefixandElmenetName(string nameAndPrefix

private:
	// -----------------------------------------------------------------------
    //  Private Members
    // -----------------------------------------------------------------------
	
};

class XmlCommonException : public Exception
{
	public:
		XmlCommonException(string errMsgIn = "", int severity = ERROR_FATAL);
		~XmlCommonException();
};


#endif
