//
// $Id: AnalysisEngine.h,v 1.8 2005/03/28 15:59:41 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:	AnalysisEngine
//  author: Jon Baker	
//
//	This class is responsible for the analysis portion of the definition interperter.
//	Essentially it attempts to process a oval xml file from the top down. Each OVAL 
//	definition is evaluated by first evaluating all the tests it uses and then combining
//	the results to get the result for the test.
//
//****************************************************************************************//
#ifndef __ANALYSISENGINE_H__
#define __ANALYSISENGINE_H__

#ifdef WIN32
	#pragma warning(disable:4786)
#endif

//	required xerces includes
#include <xercesc/dom/DOM.hpp>
#include <xercesc/dom/DOMAttr.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMNodeList.hpp>
#include <xercesc/util/XMLString.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/AbstractDOMParser.hpp>

//	other includes
#include <string>
#include <iostream>
#include <sstream>
#include <vector>

#include "Common.h"
#include "XmlCommon.h"
#include "OvalResultXml.h"
#include "Exception.h"

// Analyzer classes
#include "Analyzer.h"
#include "DefinitionAnalyzer.h"
#include "CompoundTestAnalyzer.h"
#include "SimpleTestAnalyzer.h"
#include "UnknownTestAnalyzer.h"
#include "AnalyzerFactory.h"

//	namespaces
XERCES_CPP_NAMESPACE_USE
using namespace std;

class AnalysisEngine
{
public:

	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	AnalysisEngine(XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *oval, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *data, XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *mapping, XmlProcessor*, bool useConfig, string analysisFamily);
	~AnalysisEngine();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument* Run();

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void EvaluateDefinitions();
	string GetDefinitionFamily(DOMElement*);
	void Print(sVector*, sVector*, sVector*);
	string DefinitionToString(DOMElement*);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	//	pointers to private representations of the oval file and the data file
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *ovalDoc;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *dataDoc;
	XERCES_CPP_NAMESPACE_QUALIFIER DOMDocument *mappingDoc;

	string analysisFamily;
	string analysisClass;

	// Write and manage the results file.
	OvalResultXml *myResultXml;
};

class AnalysisEngineException : public Exception
{
	public:
		AnalysisEngineException(string errMsgIn = "", int severity = ERROR_FATAL);
		~AnalysisEngineException();
};

#endif

