// $Id: XmlFileContentData.h,v 1.1 2005/04/05 17:05:18 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	XmlFileContentData.h
//  author: Jon Baker	
//
//	This class is an abstract base class for platform specific XmlFileContentData classes. 
//	The class is a child class of ProbeData and implments the Write() function.
//  The parseNode function is left to be implemented by the children of this class.
//****************************************************************************************//

#ifndef __XMLFILECONTENTDATA_H__
#define __XMLFILECONTENTDATA_H__

#include "AbsXmlFileContentData.h"
#include "EnvironmentVariableData.h"
#include "EnvironmentVariableProbe.h"
#include "RegistryProbe.h"


using namespace std;

class XmlFileContentData : public AbsXmlFileContentData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	XmlFileContentData(DOMElement *test);
	XmlFileContentData();
	~XmlFileContentData();


private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMElement *test);


};

#endif