//
// $Id: MetabaseKeyProbe.h,v 1.7 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  class:  MetabaseKeyProbe
//  author: Andrew Buttner
//			Jon Baker
//
//	Gathers metabase data.
//
//  NOTE: Define _WIN32_DCOM (in your project settings pre-processor defines) norder to
//  use CoInitializeEx() The API is specific to DCOM release of the OS is surrounded by
//  conditional compilation statements that require you to #define to access the
//	definitions.
//
//	NOTE: Only key and id are suppored at this time. searching on name has not yet
//	been implemented.
//	
//****************************************************************************************//

#ifndef __METABASEKEYPROBE_H__
#define __METABASEKEYPROBE_H__

#pragma warning(disable:4786)

#include "Probe.h"
#include "Exception.h"
#include "Common.h"
#include "Log.h"
#include "MetabaseKeyData.h"

// NOTE: #include <initguid.h> must come before #include <iadmw.h> and #include <iiscnfg.h>
// you will get a link error.  At least I think you will.

#include <initguid.h>
#include <iadmw.h>
#include <iiscnfg.h>

#include <iostream>
#include <string>
#include <vector>

using namespace std;

class MetabaseKeyProbe : public Probe
{
	public:
		~MetabaseKeyProbe();
		static Probe* Instance();
		pdVector Run(ProbeData*);

	private:
		MetabaseKeyProbe();
		void GetMatchingKeys(string, string, sVector*, IMSAdminBase*);
		MetabaseKeyData* GetMetaData(string, string, IMSAdminBase*);
		void GetMatchingIdentifiers(string, string, pdVector*, IMSAdminBase*);
		void GetMetaKeys(pdVector*, string, IMSAdminBase*);
		void RetrieveInfo(MetabaseKeyData**, string, METADATA_RECORD*);
		DataElement* GetData(METADATA_GETALL_RECORD*, unsigned char*);
		DataElement* GetDataType(METADATA_GETALL_RECORD*);
		string GetIdentifier(METADATA_GETALL_RECORD*);
		DataElement* GetUserType(METADATA_GETALL_RECORD*);
		bool ValidateKey(string, IMSAdminBase*);

		static MetabaseKeyProbe *instance;
};

class MetabaseKeysProbeException : public Exception
{
	public:

		MetabaseKeysProbeException(string errMsgIn = "", int severity = ERROR_FATAL);
		~MetabaseKeysProbeException();
};

#endif
