//
// $Id: FileData.cpp,v 1.16 2005/08/05 20:19:38 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//

#include "FileData.h"

// Initialize the item Vector
sVector FileData::items;

//****************************************************************************************//
//								FileData Class											  //	
//****************************************************************************************//
FileData::FileData(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new FileData and populate with the node's data
	// -----------------------------------------------------------------------

	string testName;

	//	Validate the test node
	testName = XmlCommon::GetElementName((DOMElement*)test);
	if(testName.compare("file_test") != 0)
		throw ProbeDataException("Error: FileData() Invalid test node specified.");

	//	Init the data members
	path = new ObjectElement();
	owner = new DataElement();
	size = new DataElement();
	a_time = new DataElement();
	c_time = new DataElement();
	development_class = new DataElement();
	m_time = new DataElement();
	ms_checksum = new DataElement();
	md5 = new DataElement();
	majVer = new DataElement();
	minVer = new DataElement();
	buildVer = new DataElement();
	priVer = new DataElement();
	type = new DataElement();
	versionStatus = doesNotExist;
/*
	trustee_name = new DataElement();
	trustee_domain = new DataElement();
	trustee_sid = new DataElement();
	acl_type = new DataElement();
	standard_delete = new DataElement();
	standard_read_control = new DataElement();
	standard_write_dac = new DataElement();
	standard_write_owner = new DataElement();
	standard_synchronize = new DataElement();
	access_system_security = new DataElement();
	generic_read = new DataElement();
	generic_write = new DataElement();
	generic_execute = new DataElement();
	generic_all = new DataElement();
	file_read_data = new DataElement();
	file_write_data = new DataElement();
	file_append_data = new DataElement();
	file_read_ea = new DataElement();
	file_write_ea = new DataElement();
	file_execute = new DataElement();
	file_delete_child = new DataElement();
	file_read_attributes = new DataElement();
	file_write_attributes = new DataElement();
*/

	//	Call the parse node function
	ParseNode(test);

	// set the xmlns and schema location
	this->SetXmlnsAlias("windows");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#windows");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#windows windows-system-characteristics-schema.xsd");
}

FileData::FileData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Initialize a new FileData as an empty object.
	// -----------------------------------------------------------------------
	
	path = new ObjectElement();
	owner = new DataElement();
	size = new DataElement();
	a_time = new DataElement();
	c_time = new DataElement();
	development_class = new DataElement();
	m_time = new DataElement();
	ms_checksum = new DataElement();
	md5 = new DataElement();
	majVer = new DataElement();
	minVer = new DataElement();
	buildVer = new DataElement();
	priVer = new DataElement();
	type = new DataElement();
	versionStatus = doesNotExist;
/*
	trustee_name = new DataElement();
	trustee_domain = new DataElement();
	trustee_sid = new DataElement();
	acl_type = new DataElement();
	standard_delete = new DataElement();
	standard_read_control = new DataElement();
	standard_write_dac = new DataElement();
	standard_write_owner = new DataElement();
	standard_synchronize = new DataElement();
	access_system_security = new DataElement();
	generic_read = new DataElement();
	generic_write = new DataElement();
	generic_execute = new DataElement();
	generic_all = new DataElement();
	file_read_data = new DataElement();
	file_write_data = new DataElement();
	file_append_data = new DataElement();
	file_read_ea = new DataElement();
	file_write_ea = new DataElement();
	file_execute = new DataElement();
	file_delete_child = new DataElement();
	file_read_attributes = new DataElement();
	file_write_attributes = new DataElement();
*/

	// set the xmlns and schema location
	this->SetXmlnsAlias("windows");
	this->SetXmlns("http://oval.mitre.org/XMLSchema/system_characteristics#windows");
	this->SetSchemaLocation("http://oval.mitre.org/XMLSchema/system_characteristics#windows windows-system-characteristics-schema.xsd");
}

FileData::~FileData()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Delete data members
	// -----------------------------------------------------------------------

	delete path;
	delete owner;
	delete size;
	delete a_time;
	delete c_time;
	delete development_class;
	delete m_time;
	delete ms_checksum;
	delete md5;
	delete majVer;
	delete minVer;
	delete buildVer;
	delete priVer;
	delete type;
/*
	delete trustee_name;
	delete trustee_domain;
	delete trustee_sid;
	delete acl_type;
	delete standard_delete;
	delete standard_read_control;
	delete standard_write_dac;
	delete standard_write_owner;
	delete standard_synchronize;
	delete access_system_security;
	delete generic_read;
	delete generic_write;
	delete generic_execute;
	delete generic_all;
	delete file_read_data;
	delete file_write_data;
	delete file_append_data;
	delete file_read_ea;
	delete file_write_ea;
	delete file_execute;
	delete file_delete_child;
	delete file_read_attributes;
	delete file_write_attributes;
*/
}

// ***************************************************************************************	//
//								Public members												//
// ***************************************************************************************	//
void FileData::Write()
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Create a new file_test node and add it to the dataDocumentument.
	//	
	// -----------------------------------------------------------------------

	// Create a string representation of the item
	string item = path->object;

	// Ensure that the item has not already been written
	if(WroteItem(&items, item))
		return;

	//	Create a new item node
	DOMElement *fileItem = CreateNewItemNode(dataDocument, "file_item");

	// Add the object element
	DOMElement *objectElm = XmlCommon::AddChildElement(dataDocument, fileItem, "object");

	// Add the status attribute to the object if not default value
	string strStatus = this->SwitchStatusType(this->objectStatus);
	if (strStatus.compare("exists") != 0)
		XmlCommon::AddAttribute(objectElm, "status", strStatus);

	//	Add the key element
	AddObjectChildElement(dataDocument, objectElm, "path", this->path);
		
	// Add the data section if the object status is exists
	if(objectStatus == exists && !this->isPatternMatchObject) {
		DOMElement *dataElm = XmlCommon::AddChildElement(dataDocument, fileItem, "data");

		// Add data subelements
		AddDataChildElement(dataDocument, dataElm, "owner", this->owner);
		AddDataChildElement(dataDocument, dataElm, "size", this->size);
		AddDataChildElement(dataDocument, dataElm, "a_time", this->a_time);
		AddDataChildElement(dataDocument, dataElm, "c_time", this->c_time);
		AddDataChildElement(dataDocument, dataElm, "m_time", this->m_time);
		AddDataChildElement(dataDocument, dataElm, "ms_checksum", this->ms_checksum);
		AddDataChildElement(dataDocument, dataElm, "md5", this->md5);

		// Add the version element
		DOMElement *versionElm = XmlCommon::AddChildElement(dataDocument, dataElm, "version");
		XmlCommon::AddAttribute(versionElm, "datatype", "version");
		XmlCommon::AddAttribute(versionElm, "status", this->SwitchStatusType(this->versionStatus));
		if(this->versionStatus == exists) {
			XmlCommon::AddChildElement(dataDocument, versionElm, "major", this->majVer->value);
			XmlCommon::AddChildElement(dataDocument, versionElm, "minor", this->minVer->value);
			XmlCommon::AddChildElement(dataDocument, versionElm, "build", this->buildVer->value);
			XmlCommon::AddChildElement(dataDocument, versionElm, "private", this->priVer->value);
		} else {

			/////////////////////////////////////////////////////
			// Due to a bug in version 4 of the oval schema
			// the following elements are required and can not 
			// be empty. This will be fixed in the next oval 
			// schema release. When it is fixed I will add
			// xsi:nil="true" as an attribute of the version
			// element.
			/////////////////////////////////////////////////////
   			XmlCommon::AddChildElement(dataDocument, versionElm, "major", "0");
			XmlCommon::AddChildElement(dataDocument, versionElm, "minor", "0");
			XmlCommon::AddChildElement(dataDocument, versionElm, "build", "0");
			XmlCommon::AddChildElement(dataDocument, versionElm, "private", "0");
		}
		

		// Add remaining elements
		AddDataChildElement(dataDocument, dataElm, "type", this->type);
		AddDataChildElement(dataDocument, dataElm, "development_class", this->development_class);
/*
		AddDataChildElement(dataDocument, dataElm, "trustee_name", this->trustee_name);
		AddDataChildElement(dataDocument, dataElm, "trustee_domain", this->trustee_domain);
		AddDataChildElement(dataDocument, dataElm, "trustee_sid", this->trustee_sid);
		AddDataChildElement(dataDocument, dataElm, "acl_type", this->acl_type);
		AddDataChildElement(dataDocument, dataElm, "standard_delete", this->standard_delete);
		AddDataChildElement(dataDocument, dataElm, "standard_read_control", this->standard_read_control);
		AddDataChildElement(dataDocument, dataElm, "standard_write_dac", this->standard_write_dac);
		AddDataChildElement(dataDocument, dataElm, "standard_write_owner", this->standard_write_owner);
		AddDataChildElement(dataDocument, dataElm, "standard_synchronize", this->standard_synchronize);
		AddDataChildElement(dataDocument, dataElm, "access_system_security", this->access_system_security);
		AddDataChildElement(dataDocument, dataElm, "generic_read", this->generic_read);
		AddDataChildElement(dataDocument, dataElm, "generic_write", this->generic_write);
		AddDataChildElement(dataDocument, dataElm, "generic_execute", this->generic_execute);
		AddDataChildElement(dataDocument, dataElm, "generic_all", this->generic_all);
		AddDataChildElement(dataDocument, dataElm, "file_read_data", this->file_read_data);
		AddDataChildElement(dataDocument, dataElm, "file_write_data", this->file_write_data);
		AddDataChildElement(dataDocument, dataElm, "file_append_data", this->file_append_data);
		AddDataChildElement(dataDocument, dataElm, "file_read_ea", this->file_read_ea);
		AddDataChildElement(dataDocument, dataElm, "file_write_ea", this->file_write_ea);
		AddDataChildElement(dataDocument, dataElm, "file_execute", this->file_execute);
		AddDataChildElement(dataDocument, dataElm, "file_delete_child", this->file_delete_child);
		AddDataChildElement(dataDocument, dataElm, "file_read_attributes", this->file_read_attributes);
		AddDataChildElement(dataDocument, dataElm, "file_write_attributes", this->file_write_attributes);	
*/
	}

	// Add the new item to the data document
	InsertItem(dataDocument, fileItem, "file_items");
}

// ***************************************************************************************	//
//								Private members												//
// ***************************************************************************************	//
void FileData::ParseNode(DOMElement *test)
{
	// -----------------------------------------------------------------------
	//	Abstract
	//
	//	Parse a test node. Set all data elements for this FileData
	//	object.
	//	
	// -----------------------------------------------------------------------

	// Retreive the test id from the DOMNode.
	testId = XmlCommon::GetAttributeByName(test, "id");
	if (testId.compare("") == 0) {
		throw ProbeDataException("Error: Unable to find the 'id' attribute for specified the test.");
	}

	///////////////////////////////////////////////////////////////////////////
	//	Parse the node
	///////////////////////////////////////////////////////////////////////////
	// Get the object element
	DOMElement *object = XmlCommon::FindNodeNS(test, "object");
	if (object == NULL) {
		throw new ProbeDataException("Error: Unable to locate object section for test: " + testId + "\n");

	}

	// Get the path element - path is required
	DOMElement *pathNode = XmlCommon::FindNodeNS(object, "path");
	if (object == NULL) {
		throw new ProbeDataException("Error: Unable to locate path element for test: " + testId + "\n");
	}

	// get the operator for path
	string pathOperator = XmlCommon::GetAttributeByName(pathNode, "operator");
	if(pathOperator.compare("pattern match") == 0){
		path->type = pattern_match;
		this->isPatternMatchObject = true;
	} else {
		path->type = literal;
	}


	// Get the components and their types
	string componentType	= "";
	string componentValue	= "";

	REGEX myMatcher;
	DOMNodeList *pathChildren = pathNode->getChildNodes();
	unsigned int index = 0;
	while(index < pathChildren->getLength()) {

		DOMNode *tmpNode = pathChildren->item(index);

		//	only concerned with ELEMENT_NODEs
		if (tmpNode->getNodeType() == DOMNode::ELEMENT_NODE) {
			DOMElement *pathChild = (DOMElement*)tmpNode;

			componentValue = XmlCommon::GetDataNodeValue(pathChild);
			componentType = XmlCommon::GetAttributeByName(pathChild, "type");

			if(componentType.compare("literal") == 0) {
				
				// do nothing for now
				
			} else if(componentType.compare("environment_variable") == 0) {

				componentValue = EnvironmentVariableProbe::GetEnvironmentVariableValue(componentValue);
				
			} else if(componentType.compare("registry_value") == 0) {

				componentValue = RegistryProbe::GetRegKeyValue(componentValue);			
			}

			//	Build the file path
			path->object.append(componentValue);
		}
		index ++;
	}
}
