//
// $Id: UnameData.h,v 1.5 2005/03/28 15:59:43 bakerj Exp $
//
//****************************************************************************************//
// Copyright (c) 2005, The MITRE Corporation
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without modification, are
// permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice, this list
//       of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice, this 
//       list of conditions and the following disclaimer in the documentation and/or other
//       materials provided with the distribution.
//     * Neither the name of The MITRE Corporation nor the names of its contributors may be
//       used to endorse or promote products derived from this software without specific 
//       prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
// SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
// OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
// TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
// EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//****************************************************************************************//
//
//  file:	UnameData.h
//  author: Jon Baker	
//
//	This class will store all data for a red hat uname. 
//	The class is a child class of ProbeData and implments the Write() function.
//****************************************************************************************//

#ifndef __UNAMEDATA_H__
#define __TUNAMEDATA_H__

#include "ProbeData.h"

class UnameData : public ProbeData
{
public:
	// -----------------------------------------------------------------------
	//	Constructors & Destructors
	// -----------------------------------------------------------------------
	UnameData(DOMElement *test);
	UnameData();
	~UnameData();

	// -----------------------------------------------------------------------
	//	Public members
	// -----------------------------------------------------------------------
	void Write();

	// -----------------------------------------------------------------------
	//	Public data
	// -----------------------------------------------------------------------	
	 DataElement *machine_class;
	 DataElement *node_name;
	 DataElement *os_name;
	 DataElement *os_release;
	 DataElement *os_version;
	 DataElement *processor_type;

private:
	// -----------------------------------------------------------------------
	//	Private members
	// -----------------------------------------------------------------------
	void ParseNode(DOMElement *test);

	// -----------------------------------------------------------------------
	//	Private data
	// -----------------------------------------------------------------------
	// Store a string representation of each item collected
	static sVector items;
};

#endif
